/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.python.maven.plugin;

import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import javax.inject.Inject;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.ProjectBuilder;
import org.graalvm.python.embedding.tools.exec.BuildToolLog;
import org.graalvm.python.embedding.tools.vfs.VFSUtils;
import org.graalvm.python.maven.plugin.AbstractGraalPyMojo;
import org.graalvm.python.maven.plugin.MavenDelegateLog;

@Mojo(name="lock-packages", requiresDependencyCollection=ResolutionScope.COMPILE_PLUS_RUNTIME, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class LockPackagesMojo
extends AbstractGraalPyMojo {
    protected static final String LOCK_FILE_HEADER = "This file was generated by maven goal 'org.graalvm.python:graalpy-maven-plugin:lock-packages'.\n\nWARNING: Any manual changes are done at your own risk and will be overwritten when the goal is executed.\n\nThis file is meant to be tracked in a version control system.\n\nThis file contains a list of all required Python packages with their specific versions,\nbased on the packages defined in the plugin configuration and their dependencies.\n";

    @Inject
    public LockPackagesMojo(ProjectBuilder projectBuilder) {
        super(projectBuilder);
    }

    public void execute() throws MojoExecutionException {
        this.preExec(false);
        this.checkEmptyPackages();
        this.manageVenv();
        this.listGraalPyResources();
        this.postExec();
    }

    protected void manageVenv() throws MojoExecutionException {
        Path venvDirectory = this.getVenvDirectory();
        MavenDelegateLog log = new MavenDelegateLog(this.getLog());
        Path requirements = this.getLockFile();
        try {
            VFSUtils.lockPackages((Path)venvDirectory, (List)this.packages, (Path)requirements, (String)LOCK_FILE_HEADER, (VFSUtils.Launcher)this.createLauncher(), (String)LockPackagesMojo.getGraalPyVersion(this.project), (BuildToolLog)log);
        }
        catch (IOException e) {
            throw new MojoExecutionException(String.format("failed to create venv %s", venvDirectory), (Exception)e);
        }
    }

    private void checkEmptyPackages() throws MojoExecutionException {
        if (this.packages == null || this.packages.isEmpty()) {
            this.getLog().error((CharSequence)"");
            this.getLog().error((CharSequence)"In order to run the lock-packages goal there have to be python packages declared in the graalpy-maven-plugin configuration.");
            this.getLog().error((CharSequence)"");
            this.getLog().error((CharSequence)"NOTE that the <configuration> section has to be declared for the whole graalpy-maven-plugin");
            this.getLog().error((CharSequence)"and not specifically for the process-graalpy-resources execution goal.");
            this.getLog().error((CharSequence)"");
            this.getLog().error((CharSequence)"Please add the <packages> section to your configuration as follows:");
            this.getLog().error((CharSequence)"<plugin>");
            this.getLog().error((CharSequence)"  <groupId>org.graalvm.python</groupId>");
            this.getLog().error((CharSequence)"  <artifactId>graalpy-maven-plugin</artifactId>");
            this.getLog().error((CharSequence)"  <configuration>");
            this.getLog().error((CharSequence)"    <packages>");
            this.getLog().error((CharSequence)"      <package>{package_name}=={package_version}</package>");
            this.getLog().error((CharSequence)"    </packages>");
            this.getLog().error((CharSequence)"    ...");
            this.getLog().error((CharSequence)"  </configuration>");
            this.getLog().error((CharSequence)"");
            this.getLog().error((CharSequence)"For more information, please refer to https://github.com/oracle/graalpython/blob/master/docs/user/Embedding-Build-Tools.md");
            this.getLog().error((CharSequence)"");
            throw new MojoExecutionException("missing python packages in plugin configuration");
        }
    }
}

