/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.python.maven.plugin;

import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import javax.inject.Inject;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.ProjectBuilder;
import org.graalvm.python.embedding.tools.exec.BuildToolLog;
import org.graalvm.python.embedding.tools.vfs.VFSUtils;
import org.graalvm.python.maven.plugin.AbstractGraalPyMojo;
import org.graalvm.python.maven.plugin.MavenDelegateLog;

@Mojo(name="process-graalpy-resources", defaultPhase=LifecyclePhase.PROCESS_RESOURCES, requiresDependencyCollection=ResolutionScope.COMPILE_PLUS_RUNTIME, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class InstallPackagesMojo
extends AbstractGraalPyMojo {
    private static final String PACKAGES_CHANGED_ERROR = "\nInstall of python packages is based on lock file %s,\nbut packages and their version constraints in graalpy-maven-plugin configuration are different then previously used to generate the lock file.\n\nPackages currently declared in graalpy-maven-plugin configuration: %s\nPackages which were used to generate the lock file: %s\n\nThe lock file has to be refreshed by running the maven goal 'org.graalvm.python:graalpy-maven-plugin:lock-packages'.\n\nFor more information, please refer to https://www.graalvm.org/latest/reference-manual/python/Embedding-Build-Tools#Python-Dependency-Management\n";
    protected static final String MISSING_LOCK_FILE_WARNING = "\nThe list of installed Python packages does not match the packages specified in the graalpy-maven-plugin configuration.\nThis could indicate that either extra dependencies were installed or some packages were installed with a more specific versions than declared.\n\nIn such cases, it is strongly recommended to lock the Python dependencies by executing the Maven goal 'org.graalvm.python:graalpy-maven-plugin:lock-packages'.\n\nFor more details on managing Python dependencies, please refer to https://www.graalvm.org/latest/reference-manual/python/Embedding-Build-Tools#Python-Dependency-Management\n\n";

    @Inject
    public InstallPackagesMojo(ProjectBuilder projectBuilder) {
        super(projectBuilder);
    }

    public void execute() throws MojoExecutionException {
        this.preExec(true);
        this.manageVenv();
        this.listGraalPyResources();
        this.manageNativeImageConfig();
        this.postExec();
    }

    private void manageVenv() throws MojoExecutionException {
        Path venvDirectory = this.getVenvDirectory();
        MavenDelegateLog log = new MavenDelegateLog(this.getLog());
        Path lockFile = this.getLockFile();
        try {
            VFSUtils.createVenv((Path)venvDirectory, (List)this.packages, (Path)lockFile, (String)MISSING_LOCK_FILE_WARNING, (VFSUtils.Launcher)this.createLauncher(), (String)InstallPackagesMojo.getGraalPyVersion(this.project), (BuildToolLog)log);
        }
        catch (VFSUtils.PackagesChangedException pce) {
            String pluginPkgsString = pce.getPluginPackages().isEmpty() ? "None" : String.join((CharSequence)", ", pce.getPluginPackages());
            String lockFilePkgsString = pce.getLockFilePackages().isEmpty() ? "None" : String.join((CharSequence)", ", pce.getLockFilePackages());
            throw new MojoExecutionException(InstallPackagesMojo.formatMultiline(PACKAGES_CHANGED_ERROR, lockFile, pluginPkgsString, lockFilePkgsString));
        }
        catch (IOException e) {
            throw new MojoExecutionException(String.format("failed to create venv %s", venvDirectory), (Exception)e);
        }
    }

    private static String formatMultiline(String str, Object ... args) {
        return str.formatted(args);
    }
}

