/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.python.maven.plugin;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.DefaultArtifactHandler;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.project.ProjectBuildingResult;
import org.eclipse.aether.graph.Dependency;
import org.graalvm.python.embedding.tools.vfs.VFSUtils;
import org.graalvm.python.maven.plugin.SuppressFBWarnings;

public abstract class AbstractGraalPyMojo
extends AbstractMojo {
    private static final String PYTHON_LAUNCHER_ARTIFACT_ID = "python-launcher";
    private static final String POLYGLOT_GROUP_ID = "org.graalvm.polyglot";
    private static final String PYTHON_COMMUNITY_ARTIFACT_ID = "python-community";
    private static final String PYTHON_ARTIFACT_ID = "python";
    private static final String GRAALPY_MAVEN_PLUGIN_ARTIFACT_ID = "graalpy-maven-plugin";
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    MavenProject project;
    @Parameter
    String pythonResourcesDirectory;
    @Parameter(property="externalDirectory")
    String externalDirectory;
    @Parameter(property="resourceDirectory")
    String resourceDirectory;
    @Parameter(property="graalPyLockFile", defaultValue="graalpy.lock")
    String graalPyLockFile;
    @Parameter
    List<String> packages;
    @Parameter
    PythonHome pythonHome;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    private MavenSession session;
    private ProjectBuilder projectBuilder;
    private Set<String> launcherClassPath;

    public AbstractGraalPyMojo(ProjectBuilder projectBuilder) {
        this.projectBuilder = projectBuilder;
    }

    protected void manageNativeImageConfig() throws MojoExecutionException {
        try {
            VFSUtils.writeNativeImageConfig((Path)Path.of(this.project.getBuild().getOutputDirectory(), "META-INF"), (String)GRAALPY_MAVEN_PLUGIN_ARTIFACT_ID, (String)this.resourceDirectory);
        }
        catch (IOException e) {
            throw new MojoExecutionException("failed to create native image configuration files", (Exception)e);
        }
    }

    protected void listGraalPyResources() throws MojoExecutionException {
        Path vfs = Path.of(this.project.getBuild().getOutputDirectory(), this.resourceDirectory);
        if (Files.exists(vfs, new LinkOption[0])) {
            try {
                VFSUtils.generateVFSFilesList((Path)Path.of(this.project.getBuild().getOutputDirectory(), new String[0]), (Path)vfs);
            }
            catch (IOException e) {
                throw new MojoExecutionException(String.format("Failed to generate files list in '%s'", vfs), (Exception)e);
            }
        }
    }

    protected void preExec(boolean enableWarnings) throws MojoExecutionException {
        this.pythonResourcesDirectory = AbstractGraalPyMojo.normalizeEmpty(this.pythonResourcesDirectory);
        this.externalDirectory = AbstractGraalPyMojo.normalizeEmpty(this.externalDirectory);
        this.resourceDirectory = AbstractGraalPyMojo.normalizeEmpty(this.resourceDirectory);
        this.graalPyLockFile = AbstractGraalPyMojo.normalizeEmpty(this.graalPyLockFile);
        List<Object> list = this.packages = this.packages != null ? this.packages.stream().filter(p -> p != null && !p.trim().isEmpty()).toList() : List.of();
        if (this.pythonResourcesDirectory != null) {
            if (this.externalDirectory != null) {
                throw new MojoExecutionException("Cannot use <externalDirectory> and <resourceDirectory> at the same time. New option <externalDirectory> is a replacement for deprecated <pythonResourcesDirectory>. If you want to deploy the virtual environment into physical filesystem, use <externalDirectory>. The deployment of the external directory alongside the application is not handled by the GraalPy Maven plugin in such case.If you want to bundle the virtual filesystem in Java resources, use <resourceDirectory>. For more details, please refer to https://www.graalvm.org/latest/reference-manual/python/Embedding-Build-Tools. ");
            }
            this.getLog().warn((CharSequence)"Option <pythonResourcesDirectory> is deprecated and will be removed. Use <externalDirectory> instead.");
            this.externalDirectory = this.pythonResourcesDirectory;
        }
        if (this.resourceDirectory != null && (this.resourceDirectory.startsWith("/") || this.resourceDirectory.endsWith("/"))) {
            throw new MojoExecutionException("Value of <resourceDirectory> should be relative resources path, i.e., without the leading '/', and it also must not end with trailing '/'");
        }
        if (this.resourceDirectory == null) {
            if (enableWarnings && this.externalDirectory == null) {
                this.getLog().info((CharSequence)String.format("Virtual filesystem is deployed to default resources directory '%s'. This can cause conflicts if used with other Java libraries that also deploy GraalPy virtual filesystem. Consider adding <resourceDirectory>GRAALPY-VFS/${project.groupId}/${project.artifactId}</resourceDirectory> to your pom.xml, moving any existing sources from '%s' to '%s', and using VirtualFileSystem$Builder#resourceDirectory.For more details, please refer to https://www.graalvm.org/latest/reference-manual/python/Embedding-Build-Tools. ", "org.graalvm.python.vfs", Path.of("org.graalvm.python.vfs", "src"), Path.of("GRAALPY-VFS", this.project.getGroupId(), this.project.getArtifactId())));
            }
            this.resourceDirectory = "org.graalvm.python.vfs";
        }
        if (enableWarnings && this.pythonHome != null) {
            this.getLog().warn((CharSequence)"The GraalPy plugin <pythonHome> configuration setting was deprecated and has no effect anymore.%nFor execution in jvm mode, the python language home is always available.%nWhen building a native executable using GraalVM Native Image, then the full python language home is by default embedded into the native executable.%nFor more details, please refer to the documentation of GraalVM Native Image options IncludeLanguageResources and CopyLanguageResources.");
        }
    }

    protected void postExec() throws MojoExecutionException {
        for (Resource r : this.project.getBuild().getResources()) {
            if (Files.exists(Path.of(r.getDirectory(), this.resourceDirectory, "proj"), new LinkOption[0])) {
                this.getLog().warn((CharSequence)String.format("usage of %s is deprecated, use %s instead", Path.of(this.resourceDirectory, "proj"), Path.of(this.resourceDirectory, "src")));
            }
            if (!Files.exists(Path.of(r.getDirectory(), this.resourceDirectory), new LinkOption[0]) && Files.exists(Path.of(r.getDirectory(), "vfs", "proj"), new LinkOption[0])) {
                throw new MojoExecutionException(String.format("Wrong virtual filesystem root!%nSince 24.1.0 the virtual filesystem root has to be '%s'.%nPlease rename the resource directory '%s' to '%s'", this.resourceDirectory, Path.of(r.getDirectory(), "vfs"), Path.of(r.getDirectory(), this.resourceDirectory)));
            }
            Path srcPath = Path.of(r.getDirectory(), this.resourceDirectory, "src");
            if (this.externalDirectory == null || !Files.exists(srcPath, new LinkOption[0])) continue;
            this.getLog().warn((CharSequence)String.format("Found Java resources directory %s, however, the GraalPy Maven plugin is configured to use <externalDirectory> instead of Java resources. The files from %s will not be available in Contexts created using GraalPyResources#contextBuilder(Path). Move them to '%s' if you want to make them available when using external directory, or use Java resources by removing <externalDirectory> option.", srcPath, srcPath, Path.of(this.externalDirectory, "src")));
        }
    }

    protected Path getVenvDirectory() {
        Path venvDirectory = this.externalDirectory == null ? Path.of(this.project.getBuild().getOutputDirectory(), this.resourceDirectory, "venv") : Path.of(this.externalDirectory, "venv");
        return venvDirectory;
    }

    private static String normalizeEmpty(String s) {
        if (s == null) {
            return s;
        }
        String trimmed = s.trim();
        return trimmed.isEmpty() ? null : trimmed;
    }

    protected VFSUtils.Launcher createLauncher() {
        VFSUtils.Launcher launcherArg = new VFSUtils.Launcher(this.getLauncherPath()){

            public Set<String> computeClassPath() throws IOException {
                return AbstractGraalPyMojo.this.calculateLauncherClasspath(AbstractGraalPyMojo.this.project);
            }
        };
        return launcherArg;
    }

    protected Path getLockFile() {
        Path rfp = Path.of(this.graalPyLockFile, new String[0]);
        if (rfp.isAbsolute()) {
            return rfp;
        }
        return this.project.getBasedir().toPath().resolve(this.graalPyLockFile);
    }

    private Path getLauncherPath() {
        return Paths.get(this.project.getBuild().getDirectory(), VFSUtils.LAUNCHER_NAME);
    }

    protected static String getGraalPyVersion(MavenProject project) throws IOException {
        DefaultArtifact a = (DefaultArtifact)AbstractGraalPyMojo.getGraalPyArtifact(project);
        Object version = a.getVersion();
        if (a.isSnapshot() && !((String)(version = a.getBaseVersion())).endsWith("-SNAPSHOT")) {
            version = (String)version + "-SNAPSHOT";
        }
        return version;
    }

    private static Artifact getGraalPyArtifact(MavenProject project) throws IOException {
        Collection<Artifact> projectArtifacts = AbstractGraalPyMojo.resolveProjectDependencies(project);
        Artifact graalPyArtifact = projectArtifacts.stream().filter(a -> AbstractGraalPyMojo.isPythonArtifact(a)).findFirst().orElse(null);
        return Optional.ofNullable(graalPyArtifact).orElseThrow(() -> new IOException("Missing GraalPy dependency. Please add to your pom either %s:%s or %s:%s".formatted(POLYGLOT_GROUP_ID, PYTHON_COMMUNITY_ARTIFACT_ID, POLYGLOT_GROUP_ID, PYTHON_ARTIFACT_ID)));
    }

    private static boolean isPythonArtifact(Artifact a) {
        return !(!POLYGLOT_GROUP_ID.equals(a.getGroupId()) && !"org.graalvm.python".equals(a.getGroupId()) || !PYTHON_COMMUNITY_ARTIFACT_ID.equals(a.getArtifactId()) && !PYTHON_ARTIFACT_ID.equals(a.getArtifactId()));
    }

    private static Collection<Artifact> resolveProjectDependencies(MavenProject project) {
        return project.getArtifacts().stream().filter(a -> !"test".equals(a.getScope())).collect(Collectors.toList());
    }

    private Set<String> calculateLauncherClasspath(MavenProject project) throws IOException {
        if (this.launcherClassPath == null) {
            String version = AbstractGraalPyMojo.getGraalPyVersion(project);
            this.launcherClassPath = new HashSet<String>();
            this.getLog().debug((CharSequence)("calculateLauncherClasspath based on org.graalvm.python:graalpy-maven-plugin:" + version));
            DefaultArtifact mvnPlugin = new DefaultArtifact("org.graalvm.python", GRAALPY_MAVEN_PLUGIN_ARTIFACT_ID, version, "compile", "jar", null, (ArtifactHandler)new DefaultArtifactHandler("pom"));
            ProjectBuildingResult result = this.buildProjectFromArtifact((Artifact)mvnPlugin);
            Artifact graalPyLauncherArtifact = result.getProject().getArtifacts().stream().filter(a -> "org.graalvm.python".equals(a.getGroupId()) && PYTHON_LAUNCHER_ARTIFACT_ID.equals(a.getArtifactId())).findFirst().orElse(null);
            this.launcherClassPath.add(graalPyLauncherArtifact.getFile().getAbsolutePath());
            this.launcherClassPath.addAll(this.resolveDependencies(graalPyLauncherArtifact));
            Artifact graalPyArtifact = AbstractGraalPyMojo.getGraalPyArtifact(project);
            assert (graalPyArtifact != null);
            this.launcherClassPath.addAll(this.resolveDependencies(graalPyArtifact));
        }
        return this.launcherClassPath;
    }

    private Set<String> resolveDependencies(Artifact artifact) throws IOException {
        HashSet<String> dependencies = new HashSet<String>();
        ProjectBuildingResult result = this.buildProjectFromArtifact(artifact);
        for (Dependency d : result.getDependencyResolutionResult().getResolvedDependencies()) {
            this.addDependency(d, dependencies);
        }
        return dependencies;
    }

    private ProjectBuildingResult buildProjectFromArtifact(Artifact artifact) throws IOException {
        try {
            DefaultProjectBuildingRequest buildingRequest = new DefaultProjectBuildingRequest(this.session.getProjectBuildingRequest());
            buildingRequest.setProject(null);
            buildingRequest.setResolveDependencies(true);
            buildingRequest.setPluginArtifactRepositories(this.project.getPluginArtifactRepositories());
            buildingRequest.setRemoteRepositories(this.project.getRemoteArtifactRepositories());
            return this.projectBuilder.build(artifact, (ProjectBuildingRequest)buildingRequest);
        }
        catch (ProjectBuildingException e) {
            throw new IOException("Error while building project", e);
        }
    }

    private void addDependency(Dependency d, Set<String> dependencies) {
        File f = d.getArtifact().getFile();
        if (f != null) {
            dependencies.add(f.getAbsolutePath());
        } else {
            this.getLog().warn((CharSequence)("could not retrieve local file for artifact " + String.valueOf(d.getArtifact())));
        }
    }

    @SuppressFBWarnings(value={"UUF_UNUSED_FIELD"})
    public static class PythonHome {
        private List<String> includes;
        private List<String> excludes;
    }
}

