/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.python.maven.plugin;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.DefaultArtifactHandler;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.project.ProjectBuildingResult;
import org.eclipse.aether.graph.Dependency;
import org.graalvm.python.embedding.tools.exec.GraalPyRunner;
import org.graalvm.python.embedding.tools.exec.SubprocessLog;
import org.graalvm.python.embedding.tools.vfs.VFSUtils;
import org.graalvm.python.maven.plugin.MavenDelegateLog;

@Mojo(name="process-graalpy-resources", defaultPhase=LifecyclePhase.PROCESS_RESOURCES, requiresDependencyCollection=ResolutionScope.COMPILE_PLUS_RUNTIME, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class ManageResourcesMojo
extends AbstractMojo {
    private static final String PYTHON_LANGUAGE_ARTIFACT_ID = "python-language";
    private static final String PYTHON_RESOURCES = "python-resources";
    private static final String PYTHON_LAUNCHER_ARTIFACT_ID = "python-launcher";
    private static final String GRAALPY_GROUP_ID = "org.graalvm.python";
    private static final String POLYGLOT_GROUP_ID = "org.graalvm.polyglot";
    private static final String PYTHON_COMMUNITY_ARTIFACT_ID = "python-community";
    private static final String PYTHON_ARTIFACT_ID = "python";
    private static final String GRAALPY_MAVEN_PLUGIN_ARTIFACT_ID = "graalpy-maven-plugin";
    private static final String GRAALPY_MAIN_CLASS = "com.oracle.graal.python.shell.GraalPythonMain";
    private static final boolean IS_WINDOWS = System.getProperty("os.name").startsWith("Windows");
    private static final String LAUNCHER = IS_WINDOWS ? "graalpy.exe" : "graalpy.sh";
    private static final String INCLUDE_PREFIX = "include:";
    private static final String EXCLUDE_PREFIX = "exclude:";
    private static final String NATIVE_IMAGE_RESOURCES_CONFIG = "{\n  \"resources\": {\n    \"includes\": [\n      {\"pattern\": \"$vfs/.*\"}\n    ]\n  }\n}\n".replace("$vfs", "org.graalvm.python.vfs");
    private static final String NATIVE_IMAGE_ARGS = "Args = -H:-CopyLanguageResources";
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    MavenProject project;
    @Parameter
    String pythonResourcesDirectory;
    @Parameter
    List<String> packages;
    @Parameter
    PythonHome pythonHome;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    private MavenSession session;
    @Component
    private ProjectBuilder projectBuilder;
    private Set<String> launcherClassPath;

    static Path getMetaInfDirectory(MavenProject project) {
        return Path.of(project.getBuild().getOutputDirectory(), "META-INF", "native-image", GRAALPY_GROUP_ID, GRAALPY_MAVEN_PLUGIN_ARTIFACT_ID);
    }

    public void execute() throws MojoExecutionException {
        if (this.pythonResourcesDirectory != null) {
            this.pythonResourcesDirectory = this.pythonResourcesDirectory.trim().isEmpty() ? null : this.pythonResourcesDirectory.trim();
        }
        this.manageHome();
        this.manageVenv();
        this.listGraalPyResources();
        this.manageNativeImageConfig();
        for (Resource r : this.project.getBuild().getResources()) {
            if (Files.exists(Path.of(r.getDirectory(), "org.graalvm.python.vfs", "proj"), new LinkOption[0])) {
                this.getLog().warn((CharSequence)String.format("usage of %s is deprecated, use %s instead", Path.of("org.graalvm.python.vfs", "proj"), Path.of("org.graalvm.python.vfs", "src")));
            }
            if (Files.exists(Path.of(r.getDirectory(), "org.graalvm.python.vfs"), new LinkOption[0]) || !Files.exists(Path.of(r.getDirectory(), "vfs", "proj"), new LinkOption[0])) continue;
            throw new MojoExecutionException(String.format("Wrong virtual filesystem root!\nSince 24.1.0 the virtual filesystem root has to be '%s'.\nPlease rename the resource directory '%s' to '%s'", "org.graalvm.python.vfs", Path.of(r.getDirectory(), "vfs"), Path.of(r.getDirectory(), "org.graalvm.python.vfs")));
        }
    }

    private void trim(List<String> l) {
        Iterator<String> it = l.iterator();
        while (it.hasNext()) {
            String p = it.next();
            if (p != null && !p.trim().isEmpty()) continue;
            it.remove();
        }
    }

    private void manageNativeImageConfig() throws MojoExecutionException {
        Path metaInf = ManageResourcesMojo.getMetaInfDirectory(this.project);
        Path resourceConfig = metaInf.resolve("resource-config.json");
        try {
            Files.createDirectories(resourceConfig.getParent(), new FileAttribute[0]);
            Files.writeString(resourceConfig, (CharSequence)NATIVE_IMAGE_RESOURCES_CONFIG, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (IOException e) {
            throw new MojoExecutionException(String.format("failed to write %s", resourceConfig), (Exception)e);
        }
        Path nativeImageProperties = metaInf.resolve("native-image.properties");
        try {
            Files.createDirectories(nativeImageProperties.getParent(), new FileAttribute[0]);
            Files.writeString(nativeImageProperties, (CharSequence)NATIVE_IMAGE_ARGS, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (IOException e) {
            throw new MojoExecutionException(String.format("failed to write %s", nativeImageProperties), (Exception)e);
        }
    }

    private void manageHome() throws MojoExecutionException {
        if (this.pythonHome == null) {
            this.pythonHome = new PythonHome();
            this.pythonHome.includes = Arrays.asList(".*");
            this.pythonHome.excludes = Collections.emptyList();
        } else {
            if (this.pythonHome.includes != null) {
                this.trim(this.pythonHome.includes);
            }
            if (this.pythonHome.includes == null || this.pythonHome.includes.isEmpty()) {
                this.pythonHome.includes = Arrays.asList(".*");
            }
            if (this.pythonHome.excludes == null) {
                this.pythonHome.excludes = Collections.emptyList();
            } else {
                this.trim(this.pythonHome.excludes);
            }
        }
        Path homeDirectory = this.pythonResourcesDirectory == null ? Path.of(this.project.getBuild().getOutputDirectory(), "org.graalvm.python.vfs", "home") : Path.of(this.pythonResourcesDirectory, "home");
        Path tag = homeDirectory.resolve("tagfile");
        String graalPyVersion = ManageResourcesMojo.getGraalPyVersion(this.project);
        ArrayList<String> pythonHomeIncludes = this.toSortedArrayList(this.pythonHome.includes);
        ArrayList<String> pythonHomeExcludes = this.toSortedArrayList(this.pythonHome.excludes);
        if (Files.isReadable(tag)) {
            List<String> lines = null;
            try {
                lines = Files.readAllLines(tag);
            }
            catch (IOException e) {
                throw new MojoExecutionException(String.format("failed to read tag file %s", tag), (Exception)e);
            }
            if (lines.isEmpty() || !graalPyVersion.equals(lines.get(0))) {
                this.getLog().info((CharSequence)String.format("Stale GraalPy home, updating to %s", graalPyVersion));
                this.delete(homeDirectory);
            }
            if (this.pythonHomeChanged(pythonHomeIncludes, pythonHomeExcludes, lines)) {
                this.getLog().info((CharSequence)String.format("Deleting GraalPy home due to changed includes or excludes", new Object[0]));
                this.delete(homeDirectory);
            }
        }
        try {
            if (!Files.exists(homeDirectory, new LinkOption[0])) {
                this.getLog().info((CharSequence)String.format("Creating GraalPy %s home in %s", graalPyVersion, homeDirectory));
                Files.createDirectories(homeDirectory.getParent(), new FileAttribute[0]);
                VFSUtils.copyGraalPyHome(this.calculateLauncherClasspath(this.project), (Path)homeDirectory, pythonHomeIncludes, pythonHomeExcludes, (SubprocessLog)new MavenDelegateLog(this.getLog()));
            }
            Files.write(tag, List.of(graalPyVersion), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
            this.write(tag, pythonHomeIncludes, INCLUDE_PREFIX);
            this.write(tag, pythonHomeExcludes, EXCLUDE_PREFIX);
        }
        catch (IOException | InterruptedException e) {
            throw new MojoExecutionException(String.format("failed to copy graalpy home %s", homeDirectory), e);
        }
    }

    private boolean pythonHomeChanged(List<String> includes, List<String> excludes, List<String> lines) throws MojoExecutionException {
        ArrayList<String> prevIncludes = new ArrayList<String>();
        ArrayList<String> prevExcludes = new ArrayList<String>();
        for (int i = 1; i < lines.size(); ++i) {
            String l = lines.get(i);
            if (l.startsWith(INCLUDE_PREFIX)) {
                prevIncludes.add(l.substring(INCLUDE_PREFIX.length()));
                continue;
            }
            if (!l.startsWith(EXCLUDE_PREFIX)) continue;
            prevExcludes.add(l.substring(EXCLUDE_PREFIX.length()));
        }
        prevIncludes = this.toSortedArrayList(prevIncludes);
        prevExcludes = this.toSortedArrayList(prevExcludes);
        return !prevIncludes.equals(includes) || !prevExcludes.equals(excludes);
    }

    private void write(Path tag, List<String> list, String prefix) throws IOException {
        if (list != null) {
            Files.write(tag, (Iterable<? extends CharSequence>)list.stream().map(l -> prefix + l).collect(Collectors.toList()), StandardOpenOption.APPEND);
        }
    }

    private ArrayList<String> toSortedArrayList(List<String> l) {
        if (l != null) {
            Collections.sort(l);
            return new ArrayList<String>(l);
        }
        return new ArrayList<String>(0);
    }

    private void delete(Path homeDirectory) throws MojoExecutionException {
        try (Stream<Path> s = Files.walk(homeDirectory, new FileVisitOption[0]);){
            s.sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
        }
        catch (IOException e) {
            new MojoExecutionException(String.format("failed to delete %s", homeDirectory), (Exception)e);
        }
    }

    private void listGraalPyResources() throws MojoExecutionException {
        Path vfs = Path.of(this.project.getBuild().getOutputDirectory(), "org.graalvm.python.vfs");
        if (Files.exists(vfs, new LinkOption[0])) {
            try {
                VFSUtils.generateVFSFilesList((Path)vfs);
            }
            catch (IOException e) {
                throw new MojoExecutionException(String.format("Failed to generate files list in '%s'", vfs.toString()), (Exception)e);
            }
        }
    }

    private void manageVenv() throws MojoExecutionException {
        this.generateLaunchers();
        Path venvDirectory = this.pythonResourcesDirectory == null ? Path.of(this.project.getBuild().getOutputDirectory(), "org.graalvm.python.vfs", "venv") : Path.of(this.pythonResourcesDirectory, "venv");
        if (this.packages != null) {
            this.trim(this.packages);
        }
        if (this.packages == null && this.pythonResourcesDirectory == null) {
            this.getLog().info((CharSequence)String.format("No venv packages declared, deleting %s", venvDirectory));
            this.delete(venvDirectory);
            return;
        }
        Path tag = venvDirectory.resolve("contents");
        ArrayList<String> installedPackages = new ArrayList<String>();
        String graalPyVersion = ManageResourcesMojo.getGraalPyVersion(this.project);
        if (Files.isReadable(tag)) {
            List<String> lines = null;
            try {
                lines = Files.readAllLines(tag);
            }
            catch (IOException e) {
                throw new MojoExecutionException(String.format("failed to read tag file %s", tag), (Exception)e);
            }
            if (lines.isEmpty() || !graalPyVersion.equals(lines.get(0))) {
                this.getLog().info((CharSequence)String.format("Stale GraalPy venv, updating to %s", graalPyVersion));
                this.delete(venvDirectory);
            } else {
                for (int i = 1; i < lines.size(); ++i) {
                    installedPackages.add(lines.get(i));
                }
            }
        } else {
            this.getLog().info((CharSequence)String.format("Creating GraalPy %s venv", graalPyVersion));
        }
        if (!Files.exists(venvDirectory, new LinkOption[0])) {
            this.runLauncher(this.getLauncherPath().toString(), "-m", "venv", venvDirectory.toString(), "--without-pip");
            this.runVenvBin(venvDirectory, "graalpy", "-I", "-m", "ensurepip");
        }
        this.deleteUnwantedPackages(venvDirectory, installedPackages);
        this.installWantedPackages(venvDirectory, installedPackages);
        try {
            Files.write(tag, List.of(graalPyVersion), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
            Files.write(tag, this.packages, StandardOpenOption.APPEND);
        }
        catch (IOException e) {
            throw new MojoExecutionException(String.format("failed to write tag file %s", tag), (Exception)e);
        }
    }

    private void installWantedPackages(Path venvDirectory, List<String> installedPackages) throws MojoExecutionException {
        HashSet<String> pkgsToInstall = new HashSet<String>(this.packages);
        pkgsToInstall.removeAll(installedPackages);
        if (pkgsToInstall.isEmpty()) {
            return;
        }
        this.runPip(venvDirectory, "install", pkgsToInstall.toArray(new String[pkgsToInstall.size()]));
    }

    private void deleteUnwantedPackages(Path venvDirectory, List<String> installedPackages) throws MojoExecutionException {
        ArrayList<String> args = new ArrayList<String>(installedPackages);
        args.removeAll(this.packages);
        if (args.isEmpty()) {
            return;
        }
        args.add(0, "-y");
        this.runPip(venvDirectory, "uninstall", args.toArray(new String[args.size()]));
    }

    private Path getLauncherPath() {
        return Paths.get(this.project.getBuild().getDirectory(), LAUNCHER);
    }

    private void generateLaunchers() throws MojoExecutionException {
        this.getLog().info((CharSequence)"Generating GraalPy launchers");
        Path launcher = this.getLauncherPath();
        if (!Files.exists(launcher, new LinkOption[0])) {
            File tmp;
            Path java = Paths.get(System.getProperty("java.home"), "bin", "java");
            Set<String> classpath = this.calculateLauncherClasspath(this.project);
            if (!IS_WINDOWS) {
                String script = String.format("#!/usr/bin/env bash\n%s -classpath %s %s --python.Executable=\"$0\" \"$@\"\n", java, String.join((CharSequence)File.pathSeparator, classpath), GRAALPY_MAIN_CLASS);
                try {
                    Files.createDirectories(launcher.getParent(), new FileAttribute[0]);
                    Files.writeString(launcher, (CharSequence)script, new OpenOption[0]);
                    Set<PosixFilePermission> perms = Files.getPosixFilePermissions(launcher, new LinkOption[0]);
                    perms.addAll(List.of(PosixFilePermission.OWNER_EXECUTE, PosixFilePermission.GROUP_EXECUTE, PosixFilePermission.OTHERS_EXECUTE));
                    Files.setPosixFilePermissions(launcher, perms);
                }
                catch (IOException e) {
                    throw new MojoExecutionException(String.format("failed to create launcher %s", launcher), (Exception)e);
                }
            }
            String script = String.format("import os, shutil, struct, venv\nfrom pathlib import Path\nvl = os.path.join(venv.__path__[0], 'scripts', 'nt', 'graalpy.exe')\ntl = os.path.join(r'%s')\nos.makedirs(Path(tl).parent.absolute(), exist_ok=True)\nshutil.copy(vl, tl)\ncmd = r'%s -classpath \"%s\" %s'\npyvenvcfg = os.path.join(os.path.dirname(tl), \"pyvenv.cfg\")\nwith open(pyvenvcfg, 'w', encoding='utf-8') as f:\n    f.write('venvlauncher_command = ')\n    f.write(cmd)\n", launcher, java, String.join((CharSequence)File.pathSeparator, classpath), GRAALPY_MAIN_CLASS);
            try {
                tmp = File.createTempFile("create_launcher", ".py");
            }
            catch (IOException e) {
                throw new MojoExecutionException("failed to create tmp launcher", (Exception)e);
            }
            tmp.deleteOnExit();
            try (FileWriter wr = new FileWriter(tmp);){
                wr.write(script);
            }
            catch (IOException e) {
                throw new MojoExecutionException(String.format("failed to write tmp launcher %s", tmp), (Exception)e);
            }
            this.runGraalPy(this.project, this.getLog(), tmp.getAbsolutePath());
        }
    }

    private void runLauncher(String launcherPath, String ... args) throws MojoExecutionException {
        try {
            GraalPyRunner.runLauncher((String)launcherPath, (SubprocessLog)new MavenDelegateLog(this.getLog()), (String[])args);
        }
        catch (IOException | InterruptedException e) {
            throw new MojoExecutionException(String.format("failed to execute launcher command %s", List.of(args)));
        }
    }

    private void runPip(Path venvDirectory, String command, String ... args) throws MojoExecutionException {
        try {
            GraalPyRunner.runPip((Path)venvDirectory, (String)command, (SubprocessLog)new MavenDelegateLog(this.getLog()), (String[])args);
        }
        catch (IOException | InterruptedException e) {
            throw new MojoExecutionException(String.format("failed to execute pip", args), e);
        }
    }

    private void runVenvBin(Path venvDirectory, String bin, String ... args) throws MojoExecutionException {
        try {
            GraalPyRunner.runVenvBin((Path)venvDirectory, (String)bin, (SubprocessLog)new MavenDelegateLog(this.getLog()), (String[])args);
        }
        catch (IOException | InterruptedException e) {
            throw new MojoExecutionException(String.format("failed to execute venv", args), e);
        }
    }

    private void runGraalPy(MavenProject project, Log log, String ... args) throws MojoExecutionException {
        Set<String> classpath = this.calculateLauncherClasspath(project);
        try {
            GraalPyRunner.run(classpath, (SubprocessLog)new MavenDelegateLog(log), (String[])args);
        }
        catch (IOException | InterruptedException e) {
            throw new MojoExecutionException(String.format("failed to run Graalpy launcher", new Object[0]), e);
        }
    }

    private static String getGraalPyVersion(MavenProject project) throws MojoExecutionException {
        DefaultArtifact a = (DefaultArtifact)ManageResourcesMojo.getGraalPyArtifact(project);
        Object version = a.getVersion();
        if (a.isSnapshot() && !((String)(version = a.getBaseVersion())).endsWith("-SNAPSHOT")) {
            version = (String)version + "-SNAPSHOT";
        }
        return version;
    }

    private static Artifact getGraalPyArtifact(MavenProject project) throws MojoExecutionException {
        Collection<Artifact> projectArtifacts = ManageResourcesMojo.resolveProjectDependencies(project);
        Artifact graalPyArtifact = projectArtifacts.stream().filter(a -> ManageResourcesMojo.isPythonArtifact(a)).findFirst().orElse(null);
        return Optional.ofNullable(graalPyArtifact).orElseThrow(() -> new MojoExecutionException("Missing GraalPy dependency. Please add to your pom either %s:%s or %s:%s".formatted(POLYGLOT_GROUP_ID, PYTHON_COMMUNITY_ARTIFACT_ID, POLYGLOT_GROUP_ID, PYTHON_ARTIFACT_ID)));
    }

    private static boolean isPythonArtifact(Artifact a) {
        return !(!POLYGLOT_GROUP_ID.equals(a.getGroupId()) && !GRAALPY_GROUP_ID.equals(a.getGroupId()) || !PYTHON_COMMUNITY_ARTIFACT_ID.equals(a.getArtifactId()) && !PYTHON_ARTIFACT_ID.equals(a.getArtifactId()));
    }

    private static Collection<Artifact> resolveProjectDependencies(MavenProject project) {
        return project.getArtifacts().stream().filter(a -> !"test".equals(a.getScope())).collect(Collectors.toList());
    }

    private Set<String> calculateLauncherClasspath(MavenProject project) throws MojoExecutionException {
        if (this.launcherClassPath == null) {
            String version = ManageResourcesMojo.getGraalPyVersion(project);
            this.launcherClassPath = new HashSet<String>();
            this.getLog().debug((CharSequence)("calculateLauncherClasspath based on org.graalvm.python:graalpy-maven-plugin:" + version));
            DefaultArtifact mvnPlugin = new DefaultArtifact(GRAALPY_GROUP_ID, GRAALPY_MAVEN_PLUGIN_ARTIFACT_ID, version, "compile", "jar", null, (ArtifactHandler)new DefaultArtifactHandler("pom"));
            ProjectBuildingResult result = this.buildProjectFromArtifact((Artifact)mvnPlugin);
            Artifact graalPyLauncherArtifact = result.getProject().getArtifacts().stream().filter(a -> GRAALPY_GROUP_ID.equals(a.getGroupId()) && PYTHON_LAUNCHER_ARTIFACT_ID.equals(a.getArtifactId())).findFirst().orElse(null);
            this.launcherClassPath.add(graalPyLauncherArtifact.getFile().getAbsolutePath());
            this.launcherClassPath.addAll(this.resolveDependencies(graalPyLauncherArtifact));
            Artifact graalPyArtifact = ManageResourcesMojo.getGraalPyArtifact(project);
            assert (graalPyArtifact != null);
            this.launcherClassPath.addAll(this.resolveDependencies(graalPyArtifact));
        }
        return this.launcherClassPath;
    }

    private Set<String> resolveDependencies(Artifact artifact) throws MojoExecutionException {
        HashSet<String> dependencies = new HashSet<String>();
        ProjectBuildingResult result = this.buildProjectFromArtifact(artifact);
        for (Dependency d : result.getDependencyResolutionResult().getResolvedDependencies()) {
            this.addDependency(d, dependencies);
        }
        return dependencies;
    }

    private ProjectBuildingResult buildProjectFromArtifact(Artifact artifact) throws MojoExecutionException {
        try {
            DefaultProjectBuildingRequest buildingRequest = new DefaultProjectBuildingRequest(this.session.getProjectBuildingRequest());
            buildingRequest.setProject(null);
            buildingRequest.setResolveDependencies(true);
            buildingRequest.setPluginArtifactRepositories(this.project.getPluginArtifactRepositories());
            buildingRequest.setRemoteRepositories(this.project.getRemoteArtifactRepositories());
            return this.projectBuilder.build(artifact, (ProjectBuildingRequest)buildingRequest);
        }
        catch (ProjectBuildingException e) {
            throw new MojoExecutionException("Error while building project", (Exception)((Object)e));
        }
    }

    private void addDependency(Dependency d, Set<String> dependencies) {
        File f = d.getArtifact().getFile();
        if (f != null) {
            dependencies.add(f.getAbsolutePath());
        } else {
            this.getLog().warn((CharSequence)("could not retrieve local file for artifact " + String.valueOf(d.getArtifact())));
        }
    }

    public static class PythonHome {
        private List<String> includes;
        private List<String> excludes;
    }
}

