/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.jdk;

import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.jdk.JNIRegistrationUtil;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.jdk.JNIRegistrationSupport;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.hosted.Feature;

@Platforms(value={Platform.WINDOWS.class, Platform.LINUX.class})
@AutomaticallyRegisteredFeature
public class JNIRegistrationAWTSupport
extends JNIRegistrationUtil
implements InternalFeature {
    @Override
    public void afterAnalysis(Feature.AfterAnalysisAccess access) {
        JNIRegistrationSupport jniRegistrationSupport = JNIRegistrationSupport.singleton();
        if (jniRegistrationSupport.isRegisteredLibrary("awt")) {
            jniRegistrationSupport.addJvmShimExports("jio_snprintf");
            jniRegistrationSupport.addJavaShimExports("JNU_CallMethodByName", "JNU_CallStaticMethodByName", "JNU_GetEnv", "JNU_GetStaticFieldByName", "JNU_IsInstanceOfByName", "JNU_NewObjectByName", "JNU_NewStringPlatform", "JNU_SetFieldByName", "JNU_ThrowArrayIndexOutOfBoundsException", "JNU_ThrowByName", "JNU_ThrowIllegalArgumentException", "JNU_ThrowInternalError", "JNU_ThrowNullPointerException", "JNU_ThrowOutOfMemoryError");
            if (JNIRegistrationAWTSupport.isWindows()) {
                jniRegistrationSupport.addJvmShimExports("JVM_CurrentTimeMillis", "JVM_RaiseSignal");
                jniRegistrationSupport.addJavaShimExports("JDK_LoadSystemLibrary", "JNU_CallMethodByNameV", "JNU_ClassString", "JNU_GetFieldByName", "JNU_ThrowIOException", "getEncodingFromLangID", "getJavaIDFromLangID");
            } else {
                jniRegistrationSupport.addJvmShimExports("jio_fprintf");
                jniRegistrationSupport.addJavaShimExports("JNU_GetStringPlatformChars", "JNU_ReleaseStringPlatformChars");
                jniRegistrationSupport.registerLibrary("awt_headless");
                jniRegistrationSupport.registerLibrary("awt_xawt");
            }
        }
        if (jniRegistrationSupport.isRegisteredLibrary("javaaccessbridge")) {
            jniRegistrationSupport.registerLibrary("jawt");
        }
        if (jniRegistrationSupport.isRegisteredLibrary("javajpeg")) {
            jniRegistrationSupport.addJavaShimExports("JNU_GetEnv", "JNU_ThrowByName", "JNU_ThrowNullPointerException");
            if (JNIRegistrationAWTSupport.isWindows()) {
                jniRegistrationSupport.addJavaShimExports("jio_snprintf");
            } else {
                jniRegistrationSupport.addJvmShimExports("jio_snprintf");
            }
        }
    }

    public void beforeImageWrite(Feature.BeforeImageWriteAccess access) {
        if (JNIRegistrationAWTSupport.isWindows() && JNIRegistrationSupport.singleton().isRegisteredLibrary("awt")) {
            ((FeatureImpl.BeforeImageWriteAccessImpl)access).registerLinkerInvocationTransformer(linkerInvocation -> {
                linkerInvocation.addNativeLinkerOption("shell32.lib");
                linkerInvocation.addNativeLinkerOption("ole32.lib");
                return linkerInvocation;
            });
        }
    }
}

