/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.image;

import com.oracle.graal.pointsto.heap.ImageHeapConstant;
import com.oracle.graal.pointsto.heap.ImageHeapPrimitiveArray;
import com.oracle.graal.pointsto.util.AnalysisError;
import com.oracle.objectfile.ObjectFile;
import com.oracle.svm.core.FrameAccess;
import com.oracle.svm.core.StaticFieldsSupport;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.config.ObjectLayout;
import com.oracle.svm.core.heap.Heap;
import com.oracle.svm.core.heap.ObjectHeader;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.image.ImageHeapLayoutInfo;
import com.oracle.svm.core.meta.MethodPointer;
import com.oracle.svm.core.meta.SubstrateObjectConstant;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.config.HybridLayout;
import com.oracle.svm.hosted.image.NativeImageHeap;
import com.oracle.svm.hosted.image.RelocatableBuffer;
import com.oracle.svm.hosted.meta.HostedClass;
import com.oracle.svm.hosted.meta.HostedField;
import com.oracle.svm.hosted.meta.HostedInstanceClass;
import com.oracle.svm.hosted.meta.MaterializedConstantFields;
import com.oracle.svm.hosted.meta.RelocatableConstant;
import java.lang.reflect.Array;
import java.lang.reflect.Modifier;
import java.nio.ByteBuffer;
import jdk.graal.compiler.api.replacements.SnippetReflectionProvider;
import jdk.graal.compiler.core.common.CompressEncoding;
import jdk.graal.compiler.core.common.NumUtil;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.debug.Indent;
import jdk.internal.misc.Unsafe;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.PrimitiveConstant;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.c.function.CFunctionPointer;
import org.graalvm.nativeimage.c.function.RelocatedPointer;
import org.graalvm.word.WordBase;

public final class NativeImageHeapWriter {
    private final NativeImageHeap heap;
    private final ImageHeapLayoutInfo heapLayout;
    private long sectionOffsetOfARelocatablePointer;
    private final boolean useHeapBase = NativeImageHeap.useHeapBase();
    private final CompressEncoding compressEncoding = (CompressEncoding)ImageSingletons.lookup(CompressEncoding.class);

    public NativeImageHeapWriter(NativeImageHeap heap, ImageHeapLayoutInfo heapLayout) {
        this.heap = heap;
        this.heapLayout = heapLayout;
        this.sectionOffsetOfARelocatablePointer = -1L;
    }

    public long writeHeap(DebugContext debug, RelocatableBuffer buffer) {
        try (Indent perHeapIndent = debug.logAndIndent("NativeImageHeap.writeHeap:");){
            for (NativeImageHeap.ObjectInfo info : this.heap.getObjects()) {
                assert (!(info.getConstant() instanceof SubstrateObjectConstant) || !this.heap.isBlacklisted(info.getObject()));
                this.writeObject(info, buffer);
            }
            this.writeStaticFields(buffer);
            this.heap.getLayouter().writeMetadata(buffer.getByteBuffer(), 0L);
        }
        return this.sectionOffsetOfARelocatablePointer;
    }

    private void writeStaticFields(RelocatableBuffer buffer) {
        NativeImageHeap.ObjectInfo primitiveFields = this.heap.getObjectInfo(StaticFieldsSupport.getStaticPrimitiveFields());
        NativeImageHeap.ObjectInfo objectFields = this.heap.getObjectInfo(StaticFieldsSupport.getStaticObjectFields());
        for (HostedField field : this.heap.hUniverse.getFields()) {
            if (!Modifier.isStatic(field.getModifiers()) || !field.hasLocation() || !field.isRead()) continue;
            assert (field.isWritten() || !field.isValueAvailable() || MaterializedConstantFields.singleton().contains(field.wrapped));
            NativeImageHeap.ObjectInfo fields = field.getStorageKind() == JavaKind.Object ? objectFields : primitiveFields;
            this.writeField(buffer, fields, field, null, null);
        }
    }

    private int referenceSize() {
        return this.heap.objectLayout.getReferenceSize();
    }

    private void mustBeReferenceAligned(int index) {
        assert (index % this.heap.objectLayout.getReferenceSize() == 0) : "index " + index + " must be reference-aligned.";
    }

    private static void verifyTargetDidNotChange(Object target, Object reason, Object targetInfo) {
        if (targetInfo == null) {
            throw NativeImageHeap.reportIllegalType(target, reason);
        }
    }

    private void writeField(RelocatableBuffer buffer, NativeImageHeap.ObjectInfo fields, HostedField field, JavaConstant receiver, NativeImageHeap.ObjectInfo info) {
        JavaConstant value;
        int index = fields.getIndexInBuffer(field.getLocation());
        try {
            value = this.heap.hConstantReflection.readFieldValue(field, receiver);
        }
        catch (AnalysisError.TypeNotFoundError ex) {
            throw NativeImageHeap.reportIllegalType(ex.getType(), info);
        }
        if (value instanceof RelocatableConstant) {
            this.addNonDataRelocation(buffer, index, this.prepareRelocatable(info, value));
        } else {
            this.write(buffer, index, value, info != null ? info : field);
        }
    }

    private void write(RelocatableBuffer buffer, int index, JavaConstant con, Object reason) {
        if (con.getJavaKind() == JavaKind.Object) {
            this.writeReference(buffer, index, con, reason);
        } else {
            NativeImageHeapWriter.writePrimitive(buffer, index, con);
        }
    }

    void writeReference(RelocatableBuffer buffer, int index, JavaConstant target, Object reason) {
        assert (!this.heap.hMetaAccess.isInstanceOf(target, WordBase.class)) : "word values are not references";
        this.mustBeReferenceAligned(index);
        if (target.isNonNull()) {
            NativeImageHeap.ObjectInfo targetInfo = this.heap.getConstantInfo(target);
            NativeImageHeapWriter.verifyTargetDidNotChange(target, reason, targetInfo);
            if (this.useHeapBase) {
                int shift = this.compressEncoding.getShift();
                this.writeReferenceValue(buffer, index, targetInfo.getAddress() >>> shift);
            } else {
                this.addDirectRelocationWithoutAddend(buffer, index, this.referenceSize(), target);
            }
        }
    }

    private void writeConstant(RelocatableBuffer buffer, int index, JavaKind kind, JavaConstant constant, NativeImageHeap.ObjectInfo info) {
        Object con;
        if (constant instanceof RelocatableConstant) {
            this.addNonDataRelocation(buffer, index, this.prepareRelocatable(info, constant));
            return;
        }
        if (this.heap.hMetaAccess.isInstanceOf(constant, WordBase.class)) {
            Object value = this.snippetReflection().asObject(Object.class, constant);
            con = JavaConstant.forIntegerKind((JavaKind)FrameAccess.getWordKind(), (long)((WordBase)value).rawValue());
        } else {
            con = constant.isNull() && kind == FrameAccess.getWordKind() ? JavaConstant.forIntegerKind((JavaKind)FrameAccess.getWordKind(), (long)0L) : constant;
        }
        this.write(buffer, index, (JavaConstant)con, info);
    }

    private RelocatedPointer prepareRelocatable(NativeImageHeap.ObjectInfo info, JavaConstant value) {
        return (RelocatedPointer)this.maybeReplace(this.snippetReflection().asObject(RelocatedPointer.class, value), info);
    }

    private void writeConstant(RelocatableBuffer buffer, int index, JavaKind kind, Object value, NativeImageHeap.ObjectInfo info) {
        PrimitiveConstant con;
        if (value instanceof RelocatedPointer) {
            this.addNonDataRelocation(buffer, index, (RelocatedPointer)value);
            return;
        }
        if (value instanceof WordBase) {
            con = JavaConstant.forIntegerKind((JavaKind)FrameAccess.getWordKind(), (long)((WordBase)value).rawValue());
        } else if (value == null && kind == FrameAccess.getWordKind()) {
            con = JavaConstant.forIntegerKind((JavaKind)FrameAccess.getWordKind(), (long)0L);
        } else {
            assert (kind == JavaKind.Object || value != null) : "primitive value must not be null";
            con = this.snippetReflection().forBoxed(kind, value);
        }
        this.write(buffer, index, (JavaConstant)con, info);
    }

    private void writeObjectHeader(RelocatableBuffer buffer, int index, NativeImageHeap.ObjectInfo obj) {
        this.mustBeReferenceAligned(index);
        DynamicHub hub = obj.getClazz().getHub();
        assert (hub != null) : "Null DynamicHub found during native image generation.";
        NativeImageHeap.ObjectInfo hubInfo = this.heap.getObjectInfo(hub);
        assert (hubInfo != null) : "Unknown object " + hub.toString() + " found. Static field or an object referenced from a static field changed during native image generation?";
        ObjectHeader objectHeader = Heap.getHeap().getObjectHeader();
        if (NativeImageHeap.useHeapBase()) {
            long targetOffset = hubInfo.getAddress();
            long headerBits = objectHeader.encodeAsImageHeapObjectHeader(obj, targetOffset);
            this.writeReferenceValue(buffer, index, headerBits);
        } else {
            long headerBits = objectHeader.encodeAsImageHeapObjectHeader(obj, 0L);
            this.addDirectRelocationWithAddend(buffer, index, hub, headerBits);
        }
    }

    private void addDirectRelocationWithoutAddend(RelocatableBuffer buffer, int index, int size, Object target) {
        assert (size == 4 || size == 8);
        assert (!NativeImageHeap.spawnIsolates() || this.heapLayout.isReadOnlyRelocatable(index));
        buffer.addRelocationWithoutAddend(index, size == 8 ? ObjectFile.RelocationKind.DIRECT_8 : ObjectFile.RelocationKind.DIRECT_4, target);
        if (this.sectionOffsetOfARelocatablePointer == -1L) {
            this.sectionOffsetOfARelocatablePointer = index;
        }
    }

    private void addDirectRelocationWithAddend(RelocatableBuffer buffer, int index, DynamicHub target, long objectHeaderBits) {
        assert (!NativeImageHeap.spawnIsolates() || this.heapLayout.isReadOnlyRelocatable(index));
        buffer.addRelocationWithAddend(index, this.referenceSize() == 8 ? ObjectFile.RelocationKind.DIRECT_8 : ObjectFile.RelocationKind.DIRECT_4, objectHeaderBits, this.snippetReflection().forObject((Object)target));
        if (this.sectionOffsetOfARelocatablePointer == -1L) {
            this.sectionOffsetOfARelocatablePointer = index;
        }
    }

    private void addNonDataRelocation(RelocatableBuffer buffer, int index, RelocatedPointer pointer) {
        this.mustBeReferenceAligned(index);
        assert (pointer instanceof CFunctionPointer) : "unknown relocated pointer " + String.valueOf(pointer);
        assert (pointer instanceof MethodPointer) : "cannot create relocation for unknown FunctionPointer " + String.valueOf(pointer);
        int pointerSize = ConfigurationValues.getTarget().wordSize;
        this.addDirectRelocationWithoutAddend(buffer, index, pointerSize, pointer);
    }

    private static void writePrimitive(RelocatableBuffer buffer, int index, JavaConstant con) {
        ByteBuffer bb = buffer.getByteBuffer();
        switch (con.getJavaKind()) {
            case Boolean: {
                bb.put(index, (byte)con.asInt());
                break;
            }
            case Byte: {
                bb.put(index, (byte)con.asInt());
                break;
            }
            case Char: {
                bb.putChar(index, (char)con.asInt());
                break;
            }
            case Short: {
                bb.putShort(index, (short)con.asInt());
                break;
            }
            case Int: {
                bb.putInt(index, con.asInt());
                break;
            }
            case Long: {
                bb.putLong(index, con.asLong());
                break;
            }
            case Float: {
                bb.putFloat(index, con.asFloat());
                break;
            }
            case Double: {
                bb.putDouble(index, con.asDouble());
                break;
            }
            default: {
                throw VMError.shouldNotReachHere(con.getJavaKind().toString());
            }
        }
    }

    private void writeReferenceValue(RelocatableBuffer buffer, int index, long value) {
        if (this.referenceSize() == 8) {
            buffer.getByteBuffer().putLong(index, value);
        } else if (this.referenceSize() == 4) {
            buffer.getByteBuffer().putInt(index, NumUtil.safeToInt((long)value));
        } else {
            throw VMError.shouldNotReachHere("Unsupported reference size: " + this.referenceSize());
        }
    }

    private void writeObject(NativeImageHeap.ObjectInfo info, RelocatableBuffer buffer) {
        ObjectLayout objectLayout = this.heap.objectLayout;
        int indexInBuffer = info.getIndexInBuffer(objectLayout.getHubOffset());
        assert (objectLayout.isAligned(indexInBuffer));
        this.writeObjectHeader(buffer, indexInBuffer, info);
        ByteBuffer bufferBytes = buffer.getByteBuffer();
        HostedClass clazz = info.getClazz();
        if (clazz.isInstanceClass()) {
            long l;
            JavaConstant con = info.getConstant();
            HybridLayout<?> hybridLayout = this.heap.getHybridLayout(clazz);
            HostedField hybridArrayField = null;
            HostedField hybridTypeIDSlotsField = null;
            int maxBitIndex = -1;
            int maxTypeIDSlotIndex = -1;
            Object hybridArray = null;
            if (hybridLayout != null) {
                short[] sArray;
                hybridArrayField = hybridLayout.getArrayField();
                hybridArray = this.heap.readHybridField(hybridArrayField, con);
                hybridTypeIDSlotsField = hybridLayout.getTypeIDSlotsField();
                if (hybridTypeIDSlotsField != null && (sArray = (short[])this.heap.readHybridField(hybridTypeIDSlotsField, con)) != null) {
                    int length = sArray.length;
                    for (int i = 0; i < length; ++i) {
                        int index2 = info.getIndexInBuffer(HybridLayout.getTypeIDSlotsFieldOffset(objectLayout)) + i * 2;
                        if (index2 + 1 > maxTypeIDSlotIndex) {
                            maxTypeIDSlotIndex = index2 + 1;
                        }
                        short value = sArray[i];
                        bufferBytes.putShort(index2, value);
                    }
                }
            }
            for (HostedField field : clazz.getInstanceFields(true)) {
                if (field.equals(hybridArrayField) || field.equals(hybridTypeIDSlotsField) || !field.isRead()) continue;
                assert (field.getLocation() >= 0);
                assert (info.getIndexInBuffer(field.getLocation()) > maxBitIndex);
                assert (info.getIndexInBuffer(field.getLocation()) > maxTypeIDSlotIndex);
                this.writeField(buffer, info, field, con, info);
            }
            if (hybridArray != null) {
                int length = Array.getLength(hybridArray);
                bufferBytes.putInt(info.getIndexInBuffer(objectLayout.getArrayLengthOffset()), length);
                for (int i = 0; i < length; ++i) {
                    int elementIndex = info.getIndexInBuffer(hybridLayout.getArrayElementOffset(i));
                    JavaKind elementStorageKind = hybridLayout.getArrayElementStorageKind();
                    Object array = Array.get(hybridArray, i);
                    this.writeConstant(buffer, elementIndex, elementStorageKind, array, info);
                }
                l = hybridLayout.getIdentityHashOffset(length);
            } else {
                l = ((HostedInstanceClass)clazz).getIdentityHashOffset();
            }
            assert (l > 0L);
            bufferBytes.putInt(info.getIndexInBuffer(l), info.getIdentityHashCode());
        } else if (clazz.isArray()) {
            JavaKind kind = clazz.getComponentType().getStorageKind();
            JavaConstant constant = info.getConstant();
            int length = this.heap.hConstantReflection.readArrayLength(constant);
            bufferBytes.putInt(info.getIndexInBuffer(objectLayout.getArrayLengthOffset()), length);
            bufferBytes.putInt(info.getIndexInBuffer(objectLayout.getArrayIdentityHashOffset(kind, length)), info.getIdentityHashCode());
            if (constant instanceof ImageHeapConstant) {
                if (clazz.getComponentType().isPrimitive()) {
                    ImageHeapPrimitiveArray imageHeapArray = (ImageHeapPrimitiveArray)constant;
                    NativeImageHeapWriter.writePrimitiveArray(info, buffer, objectLayout, kind, imageHeapArray.getArray(), length);
                } else {
                    this.heap.hConstantReflection.forEachArrayElement(constant, (element, index) -> {
                        int elementIndex = info.getIndexInBuffer(objectLayout.getArrayElementOffset(kind, index));
                        this.writeConstant(buffer, elementIndex, kind, (JavaConstant)element, info);
                    });
                }
            } else {
                Object array = info.getObject();
                if (array instanceof Object[]) {
                    Object[] oarray = (Object[])array;
                    assert (oarray.length == length);
                    for (int i = 0; i < length; ++i) {
                        int elementIndex = info.getIndexInBuffer(objectLayout.getArrayElementOffset(kind, i));
                        Object object = this.maybeReplace(oarray[i], info);
                        assert (oarray[i] instanceof RelocatedPointer == object instanceof RelocatedPointer);
                        this.writeConstant(buffer, elementIndex, kind, object, info);
                    }
                } else {
                    NativeImageHeapWriter.writePrimitiveArray(info, buffer, objectLayout, kind, array, length);
                }
            }
        } else {
            throw VMError.shouldNotReachHereUnexpectedInput(clazz);
        }
    }

    private static void writePrimitiveArray(NativeImageHeap.ObjectInfo info, RelocatableBuffer buffer, ObjectLayout objectLayout, JavaKind kind, Object array, int length) {
        int elementIndex = info.getIndexInBuffer(objectLayout.getArrayElementOffset(kind, 0));
        int elementTypeSize = Unsafe.getUnsafe().arrayIndexScale(array.getClass());
        assert (elementTypeSize == kind.getByteCount());
        Unsafe.getUnsafe().copyMemory(array, Unsafe.getUnsafe().arrayBaseOffset(array.getClass()), buffer.getBackingArray(), Unsafe.ARRAY_BYTE_BASE_OFFSET + elementIndex, length * elementTypeSize);
    }

    private Object maybeReplace(Object object, Object reason) {
        try {
            return this.heap.aUniverse.replaceObject(object);
        }
        catch (AnalysisError.TypeNotFoundError ex) {
            throw NativeImageHeap.reportIllegalType(ex.getType(), reason);
        }
    }

    private SnippetReflectionProvider snippetReflection() {
        return this.heap.hUniverse.getSnippetReflection();
    }
}

