/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.image;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.core.util.json.JsonWriter;
import com.oracle.svm.hosted.ByteFormattingUtil;
import com.oracle.svm.hosted.image.AbstractImage;
import com.oracle.svm.hosted.image.HeapHistogram;
import com.oracle.svm.hosted.image.NativeImageHeap;
import com.oracle.svm.hosted.image.ObjectInfoGraph;
import com.oracle.svm.hosted.meta.HostedField;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;

public class ImageHeapConnectedComponentsPrinter {
    private final NativeImageHeap heap;
    private final long totalHeapSizeInBytes;
    private final List<ConnectedComponent> connectedComponents;
    private final BigBang bb;
    private final String imageName;
    private final EnumMap<NativeImageHeap.ObjectReachabilityGroup, GroupEntry> groups;
    private static final int HEADING_WIDTH = 140;

    public ImageHeapConnectedComponentsPrinter(NativeImageHeap heap, BigBang bigBang, AbstractImage image, String imageName) {
        this.heap = heap;
        this.imageName = imageName;
        this.totalHeapSizeInBytes = image.getImageHeapSize();
        this.bb = bigBang;
        this.groups = ImageHeapConnectedComponentsPrinter.groupObjectsByReachability(heap);
        ObjectInfoGraph objectInfoGraph = this.constructGraph(this.groups.get((Object)((Object)NativeImageHeap.ObjectReachabilityGroup.MethodOrStaticField)).objects);
        this.connectedComponents = ImageHeapConnectedComponentsPrinter.computeConnectedComponents(objectInfoGraph);
    }

    private static boolean shouldIncludeObjectInTheReport(NativeImageHeap.ObjectInfo objectInfo) {
        return !objectInfo.getMainReason().equals((Object)NativeImageHeap.HeapInclusionReason.FillerObject);
    }

    private static EnumMap<NativeImageHeap.ObjectReachabilityGroup, GroupEntry> groupObjectsByReachability(NativeImageHeap heap) {
        NativeImageHeap.ObjectReachabilityGroup[] objectReachabilityGroupOrder = new NativeImageHeap.ObjectReachabilityGroup[]{NativeImageHeap.ObjectReachabilityGroup.Resources, NativeImageHeap.ObjectReachabilityGroup.DynamicHubs, NativeImageHeap.ObjectReachabilityGroup.ImageCodeInfo, NativeImageHeap.ObjectReachabilityGroup.MethodOrStaticField};
        EnumMap<NativeImageHeap.ObjectReachabilityGroup, GroupEntry> groups = new EnumMap<NativeImageHeap.ObjectReachabilityGroup, GroupEntry>(NativeImageHeap.ObjectReachabilityGroup.class);
        for (NativeImageHeap.ObjectReachabilityGroup group : objectReachabilityGroupOrder) {
            groups.put(group, new GroupEntry());
        }
        Set<NativeImageHeap.ObjectInfo> objects = Collections.newSetFromMap(new IdentityHashMap());
        heap.getObjects().stream().filter(ImageHeapConnectedComponentsPrinter::shouldIncludeObjectInTheReport).forEach(objects::add);
        Optional<NativeImageHeap.ObjectInfo> internedStringsTable = objects.stream().filter(o -> o.getMainReason().equals((Object)NativeImageHeap.HeapInclusionReason.InternedStringsTable)).findFirst();
        if (internedStringsTable.isPresent()) {
            GroupEntry entry = new GroupEntry();
            entry.addObject(internedStringsTable.get());
            groups.put(NativeImageHeap.ObjectReachabilityGroup.InternedStringsTable, entry);
            objects.remove(internedStringsTable.get());
        }
        for (NativeImageHeap.ObjectReachabilityGroup group : objectReachabilityGroupOrder) {
            for (NativeImageHeap.ObjectInfo object : objects) {
                NativeImageHeap.ObjectReachabilityInfo reachabilityInfo = heap.objectReachabilityInfo.get(object);
                if (!reachabilityInfo.objectReachableFrom(group)) continue;
                groups.get((Object)group).addObject(object);
            }
            objects.removeAll(groups.get((Object)((Object)group)).objects);
        }
        return groups;
    }

    private ObjectInfoGraph constructGraph(Set<NativeImageHeap.ObjectInfo> objects) {
        ObjectInfoGraph objectInfoGraph = new ObjectInfoGraph();
        for (NativeImageHeap.ObjectInfo objectInfo : objects) {
            objectInfoGraph.addNode(objectInfo);
            NativeImageHeap.ObjectReachabilityInfo reachabilityInfo = this.heap.objectReachabilityInfo.get(objectInfo);
            for (Object referencesToThisObject : reachabilityInfo.getAllReasons()) {
                if (!(referencesToThisObject instanceof NativeImageHeap.ObjectInfo) || !objects.contains(referencesToThisObject)) continue;
                objectInfoGraph.connect((NativeImageHeap.ObjectInfo)referencesToThisObject, objectInfo);
            }
        }
        return objectInfoGraph;
    }

    public void printAccessPointsForConnectedComponents(PrintWriter out) {
        try (JsonWriter writer = new JsonWriter(new BufferedWriter(out));){
            writer.append('[').newline();
            Iterator<ConnectedComponent> connectedComponentIterator = this.connectedComponents.iterator();
            while (connectedComponentIterator.hasNext()) {
                ConnectedComponent connectedComponent = connectedComponentIterator.next();
                writer.append('{').newline();
                writer.quote("componentId").append(':').append(String.valueOf(connectedComponent.getId())).append(',').newline();
                writer.quote("methods").append(":[").newline();
                Iterator<String> methodIterator = this.getMethodAccesses(connectedComponent.getObjects()).iterator();
                while (methodIterator.hasNext()) {
                    String methodAccess = methodIterator.next();
                    writer.quote(methodAccess);
                    if (!methodIterator.hasNext()) continue;
                    writer.append(',').newline();
                }
                writer.append("],").newline();
                writer.quote("staticFields").append(":[");
                Iterator<String> staticFieldIterator = this.getHostedFieldsAccess(connectedComponent.getObjects()).iterator();
                while (staticFieldIterator.hasNext()) {
                    String hostedFieldsAccess = staticFieldIterator.next();
                    writer.quote(hostedFieldsAccess);
                    if (!staticFieldIterator.hasNext()) continue;
                    writer.append(',').newline();
                }
                writer.append(']').newline();
                writer.append('}');
                if (!connectedComponentIterator.hasNext()) continue;
                writer.append(',').newline();
            }
            writer.append(']').newline();
        }
        catch (IOException e) {
            out.write("{\"Error\":\"Failed to generate the report\"");
        }
    }

    public void printSummaryInfoForEveryObjectInConnectedComponents(PrintWriter out) {
        try (JsonWriter writer = new JsonWriter(new BufferedWriter(out));){
            writer.append('{').newline();
            writer.quote("connectedComponents").append(":[").newline();
            Iterator<ConnectedComponent> iterator = this.connectedComponents.iterator();
            while (iterator.hasNext()) {
                ConnectedComponent connectedComponent = iterator.next();
                writer.append('{').newline();
                writer.quote("componentId").append(':').printValue(connectedComponent.getId()).append(',').newline();
                writer.quote("sizeInBytes").append(':').append(String.valueOf(connectedComponent.getSizeInBytes())).append(',').newline();
                writer.quote("objects").append(":[");
                List<NativeImageHeap.ObjectInfo> objects = connectedComponent.getObjects();
                this.printObjectsToJson(writer, objects);
                writer.append(']').newline();
                writer.append('}');
                if (!iterator.hasNext()) continue;
                writer.append(',').newline();
            }
            writer.newline().append("],").newline();
            NativeImageHeap.ObjectReachabilityGroup[] groupsToPrint = new NativeImageHeap.ObjectReachabilityGroup[]{NativeImageHeap.ObjectReachabilityGroup.DynamicHubs, NativeImageHeap.ObjectReachabilityGroup.ImageCodeInfo, NativeImageHeap.ObjectReachabilityGroup.InternedStringsTable, NativeImageHeap.ObjectReachabilityGroup.Resources};
            for (int i = 0; i < groupsToPrint.length; ++i) {
                NativeImageHeap.ObjectReachabilityGroup group = groupsToPrint[i];
                writer.quote(group.name).append(":{").newline();
                writer.quote("sizeInBytes").append(':').append(String.valueOf(this.groups.get((Object)((Object)group)).sizeInBytes)).append(',').newline();
                writer.quote("objects").append(":[").newline();
                this.printObjectsToJson(writer, this.groups.get((Object)((Object)group)).objects);
                writer.append(']').newline().append('}');
                if (i == groupsToPrint.length - 1) continue;
                writer.append(',').newline();
            }
            writer.newline().append('}').newline();
        }
        catch (IOException e) {
            out.write("{\"Error\":\"Failed to generate the report\"");
        }
    }

    public void printConnectedComponentsObjectHistogramReport(PrintWriter out) {
        String title = "Native image heap connected components report";
        out.println(ImageHeapConnectedComponentsPrinter.fillHeading(title));
        out.println(ImageHeapConnectedComponentsPrinter.fillHeading(this.imageName));
        out.printf("Total Heap Size: %s%n", ByteFormattingUtil.bytesToHuman(this.totalHeapSizeInBytes));
        NativeImageHeap.ObjectReachabilityGroup[] headerGroups = new NativeImageHeap.ObjectReachabilityGroup[]{NativeImageHeap.ObjectReachabilityGroup.ImageCodeInfo, NativeImageHeap.ObjectReachabilityGroup.DynamicHubs, NativeImageHeap.ObjectReachabilityGroup.InternedStringsTable, NativeImageHeap.ObjectReachabilityGroup.Resources};
        long totalHeaderGroupSize = 0L;
        for (NativeImageHeap.ObjectReachabilityGroup headerGroup : headerGroups) {
            long groupSize = this.groups.get((Object)((Object)headerGroup)).sizeInBytes;
            out.printf("\t%s size: %s%n", headerGroup.description, ByteFormattingUtil.bytesToHuman(groupSize));
            totalHeaderGroupSize += groupSize;
        }
        out.printf("\tIn connected components report: %s%n", ByteFormattingUtil.bytesToHuman(this.totalHeapSizeInBytes - totalHeaderGroupSize));
        out.printf("Total number of objects in the heap: %d%n", this.heap.getObjects().size());
        out.printf("Number of connected components in the report %d", this.connectedComponents.size());
        for (int i = 0; i < this.connectedComponents.size(); ++i) {
            ConnectedComponent connectedComponent = this.connectedComponents.get(i);
            float percentageOfTotalHeapSize = 100.0f * (float)connectedComponent.getSizeInBytes() / (float)this.totalHeapSizeInBytes;
            HeapHistogram objectHistogram = new HeapHistogram(out);
            connectedComponent.getObjects().forEach(o -> objectHistogram.add((NativeImageHeap.ObjectInfo)o, o.getSize()));
            String headingInfo = String.format("ComponentId=%d | Size=%s | Percentage of total image heap size=%.4f%%", i, ByteFormattingUtil.bytesToHuman(connectedComponent.getSizeInBytes()), Float.valueOf(percentageOfTotalHeapSize));
            out.println();
            String fullHeading = ImageHeapConnectedComponentsPrinter.fillHeading(headingInfo);
            objectHistogram.printHeadings(String.format("%s%n%s", "=".repeat(fullHeading.length()), fullHeading));
            objectHistogram.print();
            List<NativeImageHeap.ObjectInfo> roots = connectedComponent.getObjects();
            Collection<String> methods = this.getMethodAccesses(roots);
            Collection<String> staticFields = this.getHostedFieldsAccess(roots);
            int entryPointLimit = 10;
            if (!staticFields.isEmpty()) {
                out.printf("%nStatic fields accessing component %d:%n", i);
                for (String field : staticFields.stream().limit(entryPointLimit).collect(Collectors.toList())) {
                    out.printf("\t%s%n", field);
                }
                if (staticFields.size() > entryPointLimit) {
                    out.printf("\t... %d more in the access_points report%n", staticFields.size() - entryPointLimit);
                }
            }
            if (methods.isEmpty()) continue;
            out.printf("%nMethods accessing connected component %d:%n", i);
            for (String methodName : methods.stream().limit(entryPointLimit).collect(Collectors.toList())) {
                out.printf("\t%s%n", ImageHeapConnectedComponentsPrinter.formatMethodAsLink(methodName));
            }
            if (methods.size() <= entryPointLimit) continue;
            out.printf("\t... %d more in the access_points report%n", methods.size() - entryPointLimit);
        }
        for (NativeImageHeap.ObjectReachabilityGroup groupType : headerGroups) {
            HeapHistogram objectHistogram = new HeapHistogram(out);
            GroupEntry groupEntry = this.groups.get((Object)groupType);
            groupEntry.objects.forEach(o -> objectHistogram.add((NativeImageHeap.ObjectInfo)o, o.getSize()));
            float percentageOfTotalHeapSize = 100.0f * (float)groupEntry.sizeInBytes / (float)this.totalHeapSizeInBytes;
            String headingInfo = String.format("Group=%s | Size=%s | Percentage of total image heap size=%.4f%%", new Object[]{groupType, ByteFormattingUtil.bytesToHuman(this.groups.get((Object)((Object)groupType)).sizeInBytes), Float.valueOf(percentageOfTotalHeapSize)});
            out.println();
            String fullHeading = ImageHeapConnectedComponentsPrinter.fillHeading(headingInfo);
            objectHistogram.printHeadings(String.format("%s%n%s", "=".repeat(fullHeading.length()), fullHeading));
            objectHistogram.print();
        }
    }

    private static String fillHeading(String title) {
        String fill = "=".repeat(Math.max(140 - title.length(), 8) / 2);
        return String.format("%s %s %s%s", fill, title, fill, title.length() % 2 == 0 ? "" : "=");
    }

    private Collection<String> getMethodAccesses(Collection<NativeImageHeap.ObjectInfo> objects) {
        ArrayList<String> methods = new ArrayList<String>();
        for (NativeImageHeap.ObjectInfo object : objects) {
            NativeImageHeap.ObjectReachabilityInfo reachabilityInfo = this.heap.objectReachabilityInfo.get(object);
            for (Object reason : reachabilityInfo.getAllReasons()) {
                if (!(reason instanceof String)) continue;
                methods.add((String)reason);
            }
        }
        return methods;
    }

    private static String formatMethodAsLink(String method) {
        int lastDot = method.lastIndexOf(".");
        if (lastDot != -1) {
            return method.substring(0, lastDot) + "#" + method.substring(lastDot + 1);
        }
        return method;
    }

    private Collection<String> getHostedFieldsAccess(Collection<NativeImageHeap.ObjectInfo> objects) {
        ArrayList<String> hostedFields = new ArrayList<String>();
        for (NativeImageHeap.ObjectInfo object : objects) {
            NativeImageHeap.ObjectReachabilityInfo reachabilityInfo = this.heap.objectReachabilityInfo.get(object);
            for (Object reason : reachabilityInfo.getAllReasons()) {
                if (!(reason instanceof HostedField)) continue;
                HostedField field = (HostedField)reason;
                hostedFields.add(field.format("%H#%n"));
            }
        }
        return hostedFields;
    }

    private void printObjectsToJson(JsonWriter writer, Collection<NativeImageHeap.ObjectInfo> objects) throws IOException {
        Iterator<NativeImageHeap.ObjectInfo> iterator = objects.iterator();
        while (iterator.hasNext()) {
            NativeImageHeap.ObjectInfo objectInfo = iterator.next();
            writer.append('{');
            writer.quote("className").append(':').quote(objectInfo.getObjectClass().getName()).append(',');
            writer.quote("identityHashCode").append(':').quote(String.valueOf(objectInfo.getIdentityHashCode())).append(',');
            writer.quote("constantValue").append(':').quote(ImageHeapConnectedComponentsPrinter.constantAsRawString(this.bb, objectInfo.getConstant())).append(',');
            ImageHeapConnectedComponentsPrinter.printReasonToJson(objectInfo.getMainReason(), writer);
            writer.append('}');
            if (!iterator.hasNext()) continue;
            writer.append(',').newline();
        }
    }

    private static void printReasonToJson(Object reason, JsonWriter writer) throws IOException {
        String kind = null;
        String value = null;
        if (reason instanceof String) {
            kind = "method";
            value = reason.toString();
        } else if (reason instanceof NativeImageHeap.ObjectInfo) {
            NativeImageHeap.ObjectInfo r = (NativeImageHeap.ObjectInfo)reason;
            kind = "object";
            value = String.valueOf(r.getIdentityHashCode());
        } else if (reason instanceof HostedField) {
            HostedField r = (HostedField)reason;
            kind = "staticField";
            value = r.format("%H#%n");
        } else if (reason instanceof NativeImageHeap.HeapInclusionReason) {
            kind = "svmInternal";
            value = reason.toString();
        } else {
            VMError.shouldNotReachHere("Unhandled type");
        }
        writer.quote("reason").append(":{");
        writer.quote("kind").append(':').quote(kind).append(',');
        writer.quote("value").append(':').quote(value);
        writer.append('}');
    }

    private static Object constantAsObject(BigBang bb, JavaConstant constant) {
        return bb.getSnippetReflectionProvider().asObject(Object.class, constant);
    }

    private static String constantAsRawString(BigBang bb, JavaConstant constant) {
        Object object = ImageHeapConnectedComponentsPrinter.constantAsObject(bb, constant);
        if (object instanceof String) {
            return (String)object;
        }
        return JavaKind.Object.format(object);
    }

    private static List<ConnectedComponent> computeConnectedComponents(ObjectInfoGraph objectInfoGraph) {
        ArrayList<ConnectedComponent> result = new ArrayList<ConnectedComponent>();
        boolean[] visited = new boolean[objectInfoGraph.getNumberOfNodes()];
        ArrayList<NativeImageHeap.ObjectInfo> stack = new ArrayList<NativeImageHeap.ObjectInfo>();
        for (NativeImageHeap.ObjectInfo start : objectInfoGraph.getNodesSet()) {
            if (visited[objectInfoGraph.getNodeId(start)]) continue;
            ConnectedComponent currentConnectedComponent = new ConnectedComponent();
            stack.add(start);
            while (!stack.isEmpty()) {
                NativeImageHeap.ObjectInfo currentObject = (NativeImageHeap.ObjectInfo)stack.remove(stack.size() - 1);
                int currentNodeId = objectInfoGraph.getNodeId(currentObject);
                if (visited[currentNodeId]) continue;
                visited[currentNodeId] = true;
                currentConnectedComponent.addObject(currentObject);
                for (NativeImageHeap.ObjectInfo neighbour : objectInfoGraph.getNeighbours(currentObject)) {
                    if (visited[objectInfoGraph.getNodeId(neighbour)]) continue;
                    stack.add(neighbour);
                }
            }
            result.add(currentConnectedComponent);
        }
        result.sort(Comparator.comparing(ConnectedComponent::getSizeInBytes).reversed());
        int id = 0;
        for (ConnectedComponent connectedComponent : result) {
            connectedComponent.setId(id++);
        }
        return result;
    }

    private static class GroupEntry {
        final Set<NativeImageHeap.ObjectInfo> objects = Collections.newSetFromMap(new IdentityHashMap());
        long sizeInBytes;

        GroupEntry() {
        }

        void addObject(NativeImageHeap.ObjectInfo object) {
            this.objects.add(object);
            this.sizeInBytes += object.getSize();
        }
    }

    static final class ConnectedComponent {
        int id = -1;
        private final List<NativeImageHeap.ObjectInfo> objects = new ArrayList<NativeImageHeap.ObjectInfo>();
        private long sizeInBytes = 0L;

        ConnectedComponent() {
        }

        public void addObject(NativeImageHeap.ObjectInfo object) {
            this.objects.add(object);
            this.sizeInBytes += object.getSize();
        }

        public long getSizeInBytes() {
            return this.sizeInBytes;
        }

        public List<NativeImageHeap.ObjectInfo> getObjects() {
            return this.objects;
        }

        void setId(int id) {
            this.id = id;
        }

        int getId() {
            return this.id;
        }
    }
}

