/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.heap;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.ObjectScanner;
import com.oracle.graal.pointsto.ObjectScanningObserver;
import com.oracle.graal.pointsto.heap.HeapSnapshotVerifier;
import com.oracle.graal.pointsto.heap.ImageHeap;
import com.oracle.graal.pointsto.heap.ImageHeapConstant;
import com.oracle.graal.pointsto.heap.ImageHeapScanner;
import com.oracle.graal.pointsto.infrastructure.UniverseMetaAccess;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.util.CompletionExecutor;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.SVMHost;
import com.oracle.svm.hosted.ameta.AnalysisConstantReflectionProvider;
import com.oracle.svm.hosted.heap.ImageHeapMapFeature;
import java.util.Map;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.nativeimage.ImageSingletons;

public class SVMImageHeapVerifier
extends HeapSnapshotVerifier {
    public SVMImageHeapVerifier(BigBang bb, ImageHeap imageHeap, ImageHeapScanner scanner) {
        super(bb, imageHeap, scanner);
    }

    public boolean checkHeapSnapshot(UniverseMetaAccess metaAccess, CompletionExecutor executor, String phase, boolean forAnalysis, Map<Constant, Object> embeddedConstants) {
        return super.checkHeapSnapshot(metaAccess, executor, phase, forAnalysis, embeddedConstants) || SVMImageHeapVerifier.imageStateModified();
    }

    private static boolean imageStateModified() {
        return ((ImageHeapMapFeature)ImageSingletons.lookup(ImageHeapMapFeature.class)).imageHeapMapNeedsUpdate();
    }

    protected void scanTypes(ObjectScanner objectScanner) {
        SVMHost svmHost = this.svmHost();
        this.bb.getUniverse().getTypes().stream().filter(AnalysisType::isReachable).forEach(t -> this.verifyHub(svmHost, objectScanner, (AnalysisType)t));
    }

    private void verifyHub(SVMHost svmHost, ObjectScanner objectScanner, AnalysisType type) {
        JavaConstant hubConstant = this.bb.getSnippetReflectionProvider().forObject((Object)svmHost.dynamicHub((ResolvedJavaType)type));
        objectScanner.scanConstant(hubConstant, ObjectScanner.OtherReason.HUB);
    }

    protected ObjectScanner installObjectScanner(UniverseMetaAccess metaAccess, CompletionExecutor executor) {
        return new VerifierObjectScanner(this.bb, metaAccess, executor, this.scannedObjects, (ObjectScanningObserver)new HeapSnapshotVerifier.ScanningObserver((HeapSnapshotVerifier)this));
    }

    private SVMHost svmHost() {
        return (SVMHost)this.bb.getHostVM();
    }

    private static final class VerifierObjectScanner
    extends ObjectScanner {
        private final UniverseMetaAccess metaAccess;

        VerifierObjectScanner(BigBang bb, UniverseMetaAccess metaAccess, CompletionExecutor executor, ObjectScanner.ReusableSet scannedObjects, ObjectScanningObserver scanningObserver) {
            super(bb, executor, scannedObjects, scanningObserver);
            this.metaAccess = metaAccess;
        }

        protected JavaConstant readFieldValue(AnalysisField field, JavaConstant receiver) {
            AnalysisConstantReflectionProvider constantReflectionProvider = (AnalysisConstantReflectionProvider)this.bb.getConstantReflectionProvider();
            VMError.guarantee(!(receiver instanceof ImageHeapConstant));
            return constantReflectionProvider.readHostedFieldValue(this.metaAccess, field, receiver);
        }
    }
}

