/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.heap;

import com.oracle.graal.pointsto.infrastructure.GraphProvider;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.HostedProviders;
import com.oracle.svm.common.meta.MultiMethod;
import com.oracle.svm.core.deopt.DeoptTest;
import com.oracle.svm.core.graal.nodes.DeoptEntryBeginNode;
import com.oracle.svm.core.graal.nodes.DeoptEntryNode;
import com.oracle.svm.core.graal.nodes.DeoptProxyAnchorNode;
import com.oracle.svm.core.graal.nodes.LoweredDeadEndNode;
import com.oracle.svm.core.graal.nodes.NewPodInstanceNode;
import com.oracle.svm.core.graal.nodes.TestDeoptimizeNode;
import com.oracle.svm.core.heap.Pod;
import com.oracle.svm.hosted.annotation.CustomSubstitutionMethod;
import com.oracle.svm.hosted.code.SubstrateCompilationDirectives;
import com.oracle.svm.hosted.nodes.DeoptProxyNode;
import com.oracle.svm.hosted.phases.HostedGraphKit;
import java.util.Arrays;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeSourcePosition;
import jdk.graal.compiler.java.FrameStateBuilder;
import jdk.graal.compiler.nodes.AbstractBeginNode;
import jdk.graal.compiler.nodes.CallTargetNode;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.FixedNode;
import jdk.graal.compiler.nodes.FixedWithNextNode;
import jdk.graal.compiler.nodes.FrameState;
import jdk.graal.compiler.nodes.InvokeWithExceptionNode;
import jdk.graal.compiler.nodes.PiNode;
import jdk.graal.compiler.nodes.StateSplit;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.UnreachableBeginNode;
import jdk.graal.compiler.nodes.UnwindNode;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.java.ExceptionObjectNode;
import jdk.graal.compiler.nodes.java.LoadFieldNode;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;

final class PodFactorySubstitutionMethod
extends CustomSubstitutionMethod {
    PodFactorySubstitutionMethod(ResolvedJavaMethod original) {
        super(original);
    }

    @Override
    public boolean allowRuntimeCompilation() {
        return true;
    }

    @Override
    public int getModifiers() {
        return super.getModifiers() & 0xFFFFFEFF;
    }

    public StructuredGraph buildGraph(DebugContext debug, AnalysisMethod method, HostedProviders providers, GraphProvider.Purpose purpose) {
        HostedGraphKit kit = new HostedGraphKit(debug, providers, (ResolvedJavaMethod)method);
        DeoptInfoProvider deoptInfo = null;
        if (MultiMethod.isDeoptTarget((ResolvedJavaMethod)method)) {
            deoptInfo = new DeoptInfoProvider((MultiMethod)method);
        }
        AnalysisType factoryType = method.getDeclaringClass();
        Pod.RuntimeSupport.PodFactory annotation = (Pod.RuntimeSupport.PodFactory)factoryType.getAnnotation(Pod.RuntimeSupport.PodFactory.class);
        AnalysisType podConcreteType = kit.getMetaAccess().lookupJavaType(annotation.podClass());
        AnalysisMethod targetCtor = this.findMatchingConstructor(method, podConcreteType.getSuperclass());
        int instanceLocal = kit.getFrameState().localsSize() - 1;
        int nextDeoptIndex = PodFactorySubstitutionMethod.startMethod(kit, deoptInfo, 0);
        PodFactorySubstitutionMethod.instantiatePod(kit, factoryType, podConcreteType, instanceLocal);
        if (this.isAnnotationPresent(DeoptTest.class)) {
            kit.append((Node)new TestDeoptimizeNode());
        }
        nextDeoptIndex = PodFactorySubstitutionMethod.invokeConstructor(kit, deoptInfo, nextDeoptIndex, targetCtor, instanceLocal);
        kit.createReturn(kit.loadLocal(instanceLocal, JavaKind.Object), JavaKind.Object);
        return kit.finalizeGraph();
    }

    private AnalysisMethod findMatchingConstructor(AnalysisMethod method, AnalysisType typeToSearch) {
        for (AnalysisMethod ctor : typeToSearch.getDeclaredConstructors(false)) {
            if (!PodFactorySubstitutionMethod.parameterTypesMatch(method, ctor)) continue;
            return ctor;
        }
        throw new GraalError("Matching constructor not found: %s", new Object[]{this.getSignature()});
    }

    private static boolean shouldInsertDeoptEntry(DeoptInfoProvider deoptInfo, int bci, FrameState.StackState stackState) {
        if (deoptInfo != null) {
            return deoptInfo.isDeoptEntry(bci, stackState);
        }
        return false;
    }

    private static int startMethod(HostedGraphKit kit, DeoptInfoProvider deoptInfo, int nextDeoptIndex) {
        if (deoptInfo != null) {
            FrameState initialState = kit.getGraph().start().stateAfter();
            if (PodFactorySubstitutionMethod.shouldInsertDeoptEntry(deoptInfo, initialState.bci, FrameState.StackState.BeforePop)) {
                return PodFactorySubstitutionMethod.appendDeoptWithExceptionUnwind(kit, initialState, initialState.bci, nextDeoptIndex, DeoptEntryNode.create());
            }
        }
        return nextDeoptIndex;
    }

    private static void instantiatePod(HostedGraphKit kit, AnalysisType factoryType, AnalysisType podConcreteType, int instanceLocal) {
        AnalysisType podType = kit.getMetaAccess().lookupJavaType(Pod.class);
        ValueNode receiver = kit.loadLocal(0, JavaKind.Object);
        ValueNode pod = PodFactorySubstitutionMethod.loadNonNullField(kit, receiver, PodFactorySubstitutionMethod.findField(factoryType, "pod"));
        LoadFieldNode arrayLength = kit.createLoadField(pod, (ResolvedJavaField)PodFactorySubstitutionMethod.findField(podType, "arrayLength"));
        ValueNode refMap = PodFactorySubstitutionMethod.loadNonNullField(kit, pod, PodFactorySubstitutionMethod.findField(podType, "referenceMap"));
        ConstantNode hub = kit.createConstant(kit.getConstantReflection().asObjectHub((ResolvedJavaType)podConcreteType), JavaKind.Object);
        ValueNode instance = (ValueNode)kit.append((Node)new NewPodInstanceNode((ResolvedJavaType)podConcreteType, (ValueNode)hub, (ValueNode)arrayLength, refMap));
        kit.storeLocal(instanceLocal, JavaKind.Object, instance);
    }

    private static ValueNode loadNonNullField(HostedGraphKit kit, ValueNode object, AnalysisField field) {
        return (ValueNode)kit.append((Node)PiNode.create((ValueNode)kit.createLoadField(object, (ResolvedJavaField)field), (Stamp)StampFactory.objectNonNull()));
    }

    private static int invokeConstructor(HostedGraphKit kit, DeoptInfoProvider deoptInfo, int nextDeoptIndex, AnalysisMethod targetCtor, int instanceLocal) {
        ValueNode instance = kit.loadLocal(instanceLocal, JavaKind.Object);
        ValueNode[] originalArgs = kit.getInitialArguments().toArray(ValueNode.EMPTY_ARRAY);
        ValueNode[] invokeArgs = Arrays.copyOf(originalArgs, originalArgs.length);
        invokeArgs[0] = instance;
        return PodFactorySubstitutionMethod.invokeWithDeoptAndExceptionUnwind(kit, deoptInfo, nextDeoptIndex, targetCtor, CallTargetNode.InvokeKind.Special, invokeArgs);
    }

    private static int invokeWithDeoptAndExceptionUnwind(HostedGraphKit kit, DeoptInfoProvider deoptInfo, int initialNextDeoptIndex, AnalysisMethod target, CallTargetNode.InvokeKind invokeKind, ValueNode ... args) {
        int bci = kit.bci();
        InvokeWithExceptionNode invoke = kit.startInvokeWithException((ResolvedJavaMethod)target, invokeKind, kit.getFrameState(), bci, args);
        invoke.setNodeSourcePosition(NodeSourcePosition.placeholder((ResolvedJavaMethod)kit.getGraph().method(), (int)bci));
        kit.exceptionPart();
        ExceptionObjectNode exception = kit.exceptionObject();
        if (deoptInfo == null) {
            kit.append((Node)new UnwindNode((ValueNode)exception));
            kit.endInvokeWithException();
            return initialNextDeoptIndex;
        }
        int nextDeoptIndex = initialNextDeoptIndex;
        if (PodFactorySubstitutionMethod.shouldInsertDeoptEntry(deoptInfo, bci, FrameState.StackState.Rethrow)) {
            DeoptEntryNode exceptionDeopt = (DeoptEntryNode)kit.add((ValueNode)DeoptEntryNode.create(invoke.bci()));
            exceptionDeopt.setStateAfter(exception.stateAfter().duplicate());
            DeoptEntryBeginNode exceptionDeoptBegin = (DeoptEntryBeginNode)kit.add((ValueNode)new DeoptEntryBeginNode());
            int exceptionDeoptIndex = nextDeoptIndex++;
            ValueNode exceptionProxy = PodFactorySubstitutionMethod.createDeoptProxy(kit, exceptionDeoptIndex, (FixedNode)exceptionDeopt, (ValueNode)exception);
            UnwindNode unwind = (UnwindNode)kit.append((Node)new UnwindNode(exceptionProxy));
            exception.setNext((FixedNode)exceptionDeopt);
            exceptionDeopt.setNext(exceptionDeoptBegin);
            exceptionDeoptBegin.setNext((FixedNode)unwind);
            UnreachableBeginNode exceptionDeoptExceptionEdge = (UnreachableBeginNode)kit.add((ValueNode)new UnreachableBeginNode());
            exceptionDeoptExceptionEdge.setNext((FixedNode)kit.add((ValueNode)new LoweredDeadEndNode()));
            exceptionDeopt.setExceptionEdge((AbstractBeginNode)exceptionDeoptExceptionEdge);
        } else {
            kit.append((Node)new UnwindNode((ValueNode)exception));
        }
        boolean needDeoptEntry = PodFactorySubstitutionMethod.shouldInsertDeoptEntry(deoptInfo, invoke.stateAfter().bci, FrameState.StackState.BeforePop);
        boolean needDeoptProxy = PodFactorySubstitutionMethod.shouldInsertDeoptEntry(deoptInfo, bci, FrameState.StackState.AfterPop);
        if (needDeoptEntry || needDeoptProxy) {
            kit.noExceptionPart();
            nextDeoptIndex = needDeoptEntry ? PodFactorySubstitutionMethod.appendDeoptWithExceptionUnwind(kit, invoke.stateAfter(), invoke.stateAfter().bci, nextDeoptIndex, DeoptEntryNode.create(invoke.bci())) : PodFactorySubstitutionMethod.appendDeoptProxyAnchorNode(kit, invoke.stateAfter(), nextDeoptIndex, invoke.bci());
        }
        kit.endInvokeWithException();
        return nextDeoptIndex;
    }

    private static int appendDeoptWithExceptionUnwind(HostedGraphKit kit, FrameState state, int exceptionBci, int nextDeoptIndex, DeoptEntryNode deoptEntryNode) {
        DeoptEntryNode entry = (DeoptEntryNode)kit.add((ValueNode)deoptEntryNode);
        entry.setStateAfter(state.duplicate());
        DeoptEntryBeginNode begin = (DeoptEntryBeginNode)kit.append((Node)new DeoptEntryBeginNode());
        ((FixedWithNextNode)begin.predecessor()).setNext((FixedNode)entry);
        entry.setNext(begin);
        ExceptionObjectNode exception = (ExceptionObjectNode)kit.add((ValueNode)new ExceptionObjectNode((MetaAccessProvider)kit.getMetaAccess()));
        entry.setExceptionEdge((AbstractBeginNode)exception);
        FrameStateBuilder exState = kit.getFrameState().copy();
        exState.clearStack();
        exState.push(JavaKind.Object, (ValueNode)exception);
        exState.setRethrowException(true);
        exception.setStateAfter(exState.create(exceptionBci, (StateSplit)exception));
        exception.setNext((FixedNode)kit.add((ValueNode)new UnwindNode((ValueNode)exception)));
        kit.getFrameState().insertProxies(value -> PodFactorySubstitutionMethod.createDeoptProxy(kit, nextDeoptIndex, (FixedNode)entry, value));
        return nextDeoptIndex + 1;
    }

    private static int appendDeoptProxyAnchorNode(HostedGraphKit kit, FrameState state, int nextDeoptIndex, int invokeBci) {
        DeoptProxyAnchorNode anchor = (DeoptProxyAnchorNode)kit.append((Node)new DeoptProxyAnchorNode(invokeBci));
        anchor.setStateAfter(state.duplicate());
        kit.getFrameState().insertProxies(value -> PodFactorySubstitutionMethod.createDeoptProxy(kit, nextDeoptIndex, (FixedNode)anchor, value));
        return nextDeoptIndex + 1;
    }

    private static ValueNode createDeoptProxy(HostedGraphKit kit, int nextDeoptIndex, FixedNode deoptTarget, ValueNode value) {
        return (ValueNode)kit.getGraph().addOrUniqueWithInputs((Node)DeoptProxyNode.create(value, (ValueNode)deoptTarget, nextDeoptIndex));
    }

    private static boolean parameterTypesMatch(AnalysisMethod method, AnalysisMethod ctor) {
        int paramsCount = method.getSignature().getParameterCount(false);
        if (paramsCount != ctor.getSignature().getParameterCount(false)) {
            return false;
        }
        for (int i = 0; i < paramsCount; ++i) {
            if (((AnalysisType)ctor.getSignature().getParameterType(i)).equals((Object)method.getSignature().getParameterType(i))) continue;
            return false;
        }
        return true;
    }

    private static AnalysisField findField(AnalysisType type, String name) {
        for (ResolvedJavaField f : type.getInstanceFields(false)) {
            AnalysisField field = (AnalysisField)f;
            if (!field.getName().equals(name)) continue;
            return field;
        }
        throw GraalError.shouldNotReachHere((String)("Required field " + name + " not found in " + String.valueOf(type)));
    }

    private static class DeoptInfoProvider {
        final MultiMethod method;

        DeoptInfoProvider(MultiMethod method) {
            this.method = method;
        }

        boolean isDeoptEntry(int bci, FrameState.StackState stackState) {
            return SubstrateCompilationDirectives.singleton().isDeoptEntry(this.method, bci, stackState);
        }
    }
}

