/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.config;

import com.oracle.svm.core.MissingRegistrationUtils;
import com.oracle.svm.core.TypeResult;
import com.oracle.svm.core.configure.ConditionalElement;
import com.oracle.svm.hosted.ImageClassLoader;
import com.oracle.svm.hosted.config.RegistryAdapter;
import java.util.List;
import org.graalvm.nativeimage.impl.ConfigurationCondition;
import org.graalvm.nativeimage.impl.ReflectionRegistry;
import org.graalvm.nativeimage.impl.RuntimeReflectionSupport;

public class ReflectionRegistryAdapter
extends RegistryAdapter {
    private final RuntimeReflectionSupport reflectionSupport;

    ReflectionRegistryAdapter(RuntimeReflectionSupport reflectionSupport, ImageClassLoader classLoader) {
        super((ReflectionRegistry)reflectionSupport, classLoader);
        this.reflectionSupport = reflectionSupport;
    }

    @Override
    public TypeResult<ConditionalElement<Class<?>>> resolveType(ConfigurationCondition condition, String typeName, boolean allowPrimitives) {
        TypeResult<ConditionalElement<Class<?>>> result = super.resolveType(condition, typeName, allowPrimitives);
        if (!result.isPresent()) {
            Throwable classLookupException = result.getException();
            if (classLookupException instanceof LinkageError) {
                this.reflectionSupport.registerClassLookupException(condition, typeName, classLookupException);
            } else if (MissingRegistrationUtils.throwMissingRegistrationErrors() && classLookupException instanceof ClassNotFoundException) {
                this.reflectionSupport.registerClassLookup(condition, typeName);
            }
        }
        return result;
    }

    @Override
    public void registerPublicClasses(ConditionalElement<Class<?>> type) {
        this.reflectionSupport.registerAllClassesQuery(type.getCondition(), type.getElement());
    }

    @Override
    public void registerDeclaredClasses(ConditionalElement<Class<?>> type) {
        this.reflectionSupport.registerAllDeclaredClassesQuery(type.getCondition(), type.getElement());
    }

    @Override
    public void registerRecordComponents(ConditionalElement<Class<?>> type) {
        this.reflectionSupport.registerAllRecordComponentsQuery(type.getCondition(), type.getElement());
    }

    @Override
    public void registerPermittedSubclasses(ConditionalElement<Class<?>> type) {
        this.reflectionSupport.registerAllPermittedSubclassesQuery(type.getCondition(), type.getElement());
    }

    @Override
    public void registerNestMembers(ConditionalElement<Class<?>> type) {
        this.reflectionSupport.registerAllNestMembersQuery(type.getCondition(), type.getElement());
    }

    @Override
    public void registerSigners(ConditionalElement<Class<?>> type) {
        this.reflectionSupport.registerAllSignersQuery(type.getCondition(), type.getElement());
    }

    @Override
    public void registerPublicFields(ConditionalElement<Class<?>> type) {
        this.reflectionSupport.registerAllFieldsQuery(type.getCondition(), type.getElement());
    }

    @Override
    public void registerDeclaredFields(ConditionalElement<Class<?>> type) {
        this.reflectionSupport.registerAllDeclaredFieldsQuery(type.getCondition(), type.getElement());
    }

    @Override
    public void registerPublicMethods(boolean queriedOnly, ConditionalElement<Class<?>> type) {
        this.reflectionSupport.registerAllMethodsQuery(type.getCondition(), queriedOnly, type.getElement());
    }

    @Override
    public void registerDeclaredMethods(boolean queriedOnly, ConditionalElement<Class<?>> type) {
        this.reflectionSupport.registerAllDeclaredMethodsQuery(type.getCondition(), queriedOnly, type.getElement());
    }

    @Override
    public void registerPublicConstructors(boolean queriedOnly, ConditionalElement<Class<?>> type) {
        this.reflectionSupport.registerAllConstructorsQuery(type.getCondition(), queriedOnly, type.getElement());
    }

    @Override
    public void registerDeclaredConstructors(boolean queriedOnly, ConditionalElement<Class<?>> type) {
        this.reflectionSupport.registerAllDeclaredConstructorsQuery(type.getCondition(), queriedOnly, type.getElement());
    }

    @Override
    public void registerField(ConditionalElement<Class<?>> type, String fieldName, boolean allowWrite) throws NoSuchFieldException {
        try {
            super.registerField(type, fieldName, allowWrite);
        }
        catch (NoSuchFieldException e) {
            if (MissingRegistrationUtils.throwMissingRegistrationErrors()) {
                this.reflectionSupport.registerFieldLookup(type.getCondition(), type.getElement(), fieldName);
            }
            throw e;
        }
    }

    @Override
    public void registerMethod(boolean queriedOnly, ConditionalElement<Class<?>> type, String methodName, List<ConditionalElement<Class<?>>> methodParameterTypes) throws NoSuchMethodException {
        try {
            super.registerMethod(queriedOnly, type, methodName, methodParameterTypes);
        }
        catch (NoSuchMethodException e) {
            if (MissingRegistrationUtils.throwMissingRegistrationErrors()) {
                this.reflectionSupport.registerMethodLookup(type.getCondition(), type.getElement(), methodName, (Class[])ReflectionRegistryAdapter.getParameterTypes(methodParameterTypes));
            }
            throw e;
        }
    }

    @Override
    public void registerConstructor(boolean queriedOnly, ConditionalElement<Class<?>> type, List<ConditionalElement<Class<?>>> methodParameterTypes) throws NoSuchMethodException {
        try {
            super.registerConstructor(queriedOnly, type, methodParameterTypes);
        }
        catch (NoSuchMethodException e) {
            if (MissingRegistrationUtils.throwMissingRegistrationErrors()) {
                this.reflectionSupport.registerConstructorLookup(type.getCondition(), type.getElement(), (Class[])ReflectionRegistryAdapter.getParameterTypes(methodParameterTypes));
            }
            throw e;
        }
    }
}

