/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.code;

import com.oracle.graal.pointsto.infrastructure.GraphProvider;
import com.oracle.graal.pointsto.infrastructure.ResolvedSignature;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.HostedProviders;
import com.oracle.svm.common.meta.MultiMethod;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.hosted.annotation.CustomSubstitutionMethod;
import com.oracle.svm.hosted.c.NativeLibraries;
import com.oracle.svm.hosted.c.info.ElementInfo;
import com.oracle.svm.hosted.c.info.EnumInfo;
import com.oracle.svm.hosted.c.info.EnumLookupInfo;
import com.oracle.svm.hosted.code.CEntryPointCallStubSupport;
import com.oracle.svm.hosted.phases.CInterfaceEnumTool;
import com.oracle.svm.hosted.phases.HostedGraphKit;
import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import java.util.List;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.java.FrameStateBuilder;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.Signature;
import org.graalvm.nativeimage.c.constant.CEnum;
import org.graalvm.nativeimage.c.constant.CEnumLookup;

public abstract class CCallStubMethod
extends CustomSubstitutionMethod {
    private static final JavaKind cEnumKind = JavaKind.Int;
    protected final int newThreadStatus;

    CCallStubMethod(ResolvedJavaMethod original, int newThreadStatus) {
        super(original);
        this.newThreadStatus = newThreadStatus;
    }

    protected abstract String getCorrespondingAnnotationName();

    public StructuredGraph buildGraph(DebugContext debug, AnalysisMethod method, HostedProviders providers, GraphProvider.Purpose purpose) {
        NativeLibraries nativeLibraries = CEntryPointCallStubSupport.singleton().getNativeLibraries();
        boolean deoptimizationTarget = MultiMethod.isDeoptTarget((ResolvedJavaMethod)method);
        HostedGraphKit kit = new HostedGraphKit(debug, providers, (ResolvedJavaMethod)method);
        FrameStateBuilder state = kit.getFrameState();
        ArrayList<ValueNode> arguments = new ArrayList<ValueNode>(kit.getInitialArguments());
        ValueNode callAddress = this.createTargetAddressNode(kit, arguments);
        AnalysisType[] paramTypes = (AnalysisType[])method.toParameterList().toArray(AnalysisType[]::new);
        ResolvedSignature<AnalysisType> signature = this.adaptSignatureAndConvertArguments(nativeLibraries, kit, method, (AnalysisType)method.getSignature().getReturnType(), paramTypes, arguments);
        state.clearLocals();
        ValueNode returnValue = kit.createCFunctionCall(callAddress, (List<ValueNode>)arguments, (Signature)signature, this.newThreadStatus, deoptimizationTarget);
        returnValue = this.adaptReturnValue(method, nativeLibraries, kit, returnValue);
        kit.createReturn(returnValue, signature.getReturnKind());
        return kit.finalizeGraph();
    }

    protected abstract ValueNode createTargetAddressNode(HostedGraphKit var1, List<ValueNode> var2);

    protected static boolean isPrimitiveOrWord(HostedGraphKit kit, JavaType type) {
        return type.getJavaKind().isPrimitive() || kit.getWordTypes().isWord(type);
    }

    protected ResolvedSignature<AnalysisType> adaptSignatureAndConvertArguments(NativeLibraries nativeLibraries, HostedGraphKit kit, AnalysisMethod method, AnalysisType returnType, AnalysisType[] parameterTypes, List<ValueNode> arguments) {
        for (int i = 0; i < parameterTypes.length; ++i) {
            if (CCallStubMethod.isPrimitiveOrWord(kit, (JavaType)parameterTypes[i])) continue;
            ElementInfo typeInfo = nativeLibraries.findElementInfo((AnnotatedElement)parameterTypes[i]);
            if (typeInfo instanceof EnumInfo) {
                ValueNode argumentValue = kit.maybeCreateExplicitNullCheck(arguments.get(i));
                CInterfaceEnumTool tool = new CInterfaceEnumTool(kit.getMetaAccess(), kit.getSnippetReflection());
                argumentValue = tool.createEnumValueInvoke(kit, (EnumInfo)typeInfo, cEnumKind, argumentValue);
                arguments.set(i, argumentValue);
                parameterTypes[i] = kit.getMetaAccess().lookupJavaType(cEnumKind.toJavaClass());
                continue;
            }
            throw UserError.abort("@%s parameter types are restricted to primitive types, word types and enumerations (@%s): %s", this.getCorrespondingAnnotationName(), CEnum.class.getSimpleName(), this.getOriginal());
        }
        AnalysisType actualReturnType = CCallStubMethod.isPrimitiveOrWord(kit, (JavaType)returnType) ? returnType : (AnalysisType)kit.getWordTypes().getWordImplType();
        return ResolvedSignature.fromArray((ResolvedJavaType[])parameterTypes, (ResolvedJavaType)actualReturnType);
    }

    private ValueNode adaptReturnValue(AnalysisMethod method, NativeLibraries nativeLibraries, HostedGraphKit kit, ValueNode invokeValue) {
        ValueNode returnValue = invokeValue;
        AnalysisType declaredReturnType = (AnalysisType)method.getSignature().getReturnType();
        if (CCallStubMethod.isPrimitiveOrWord(kit, (JavaType)declaredReturnType)) {
            return returnValue;
        }
        ElementInfo typeInfo = nativeLibraries.findElementInfo((AnnotatedElement)declaredReturnType);
        if (!(typeInfo instanceof EnumInfo)) {
            throw UserError.abort("Return types of methods annotated with @%s are restricted to primitive types, word types and enumerations (@%s): %s", this.getCorrespondingAnnotationName(), CEnum.class.getSimpleName(), this.getOriginal());
        }
        UserError.guarantee(typeInfo.getChildren().stream().anyMatch(EnumLookupInfo.class::isInstance), "Enum class %s needs a method that is annotated with @%s because it is used as the return type of a method annotated with @%s: %s", declaredReturnType, CEnumLookup.class.getSimpleName(), this.getCorrespondingAnnotationName(), this.getOriginal());
        CInterfaceEnumTool tool = new CInterfaceEnumTool(kit.getMetaAccess(), kit.getSnippetReflection());
        returnValue = tool.createEnumLookupInvoke(kit, declaredReturnType, (EnumInfo)typeInfo, cEnumKind, returnValue);
        return returnValue;
    }
}

