/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.classinitialization;

import com.oracle.graal.pointsto.infrastructure.OriginalClassProvider;
import com.oracle.graal.pointsto.phases.NoClassInitializationPlugin;
import com.oracle.graal.pointsto.util.GraalAccess;
import com.oracle.svm.core.ParsingReason;
import com.oracle.svm.core.classinitialization.EnsureClassInitializedNode;
import com.oracle.svm.core.option.HostedOptionValues;
import com.oracle.svm.hosted.FallbackFeature;
import com.oracle.svm.hosted.classinitialization.AbortOnDisallowedNode;
import com.oracle.svm.hosted.classinitialization.AbortOnRecursiveInliningPlugin;
import com.oracle.svm.hosted.classinitialization.ClassInitializerGraphBuilderPhase;
import com.oracle.svm.hosted.classinitialization.ClassInitializerHasSideEffectsException;
import com.oracle.svm.hosted.classinitialization.InitKind;
import com.oracle.svm.hosted.classinitialization.ProvenSafeClassInitializationSupport;
import com.oracle.svm.hosted.phases.EarlyConstantFoldLoadFieldPlugin;
import com.oracle.svm.hosted.snippets.ReflectionPlugins;
import com.oracle.svm.hosted.snippets.SubstrateGraphBuilderPlugins;
import java.lang.reflect.Proxy;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.graph.Graph;
import jdk.graal.compiler.java.BytecodeParser;
import jdk.graal.compiler.nodes.FrameState;
import jdk.graal.compiler.nodes.GraphState;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.graphbuilderconf.ClassInitializationPlugin;
import jdk.graal.compiler.nodes.graphbuilderconf.GraphBuilderConfiguration;
import jdk.graal.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import jdk.graal.compiler.nodes.graphbuilderconf.InlineInvokePlugin;
import jdk.graal.compiler.nodes.graphbuilderconf.InvocationPlugins;
import jdk.graal.compiler.nodes.graphbuilderconf.NodePlugin;
import jdk.graal.compiler.nodes.spi.CoreProviders;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.phases.OptimisticOptimizations;
import jdk.graal.compiler.phases.tiers.HighTierContext;
import jdk.graal.compiler.phases.util.Providers;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.nativeimage.ImageSingletons;

final class EarlyClassInitializerAnalysis {
    private final ProvenSafeClassInitializationSupport classInitializationSupport;
    private final Providers originalProviders;
    private final HighTierContext context;

    EarlyClassInitializerAnalysis(ProvenSafeClassInitializationSupport classInitializationSupport) {
        this.classInitializationSupport = classInitializationSupport;
        this.originalProviders = GraalAccess.getOriginalProviders();
        this.context = new HighTierContext(this.originalProviders, null, OptimisticOptimizations.NONE);
    }

    boolean canInitializeWithoutSideEffects(Class<?> clazz, Set<Class<?>> existingAnalyzedClasses) {
        boolean bl;
        block15: {
            if (Proxy.isProxyClass(clazz)) {
                return true;
            }
            ResolvedJavaType type = this.originalProviders.getMetaAccess().lookupJavaType(clazz);
            assert (type.getSuperclass() == null || type.getSuperclass().isInitialized()) : "This analysis assumes that the superclass was successfully analyzed and initialized beforehand: " + type.toJavaName(true);
            ResolvedJavaMethod clinit = type.getClassInitializer();
            if (clinit == null) {
                return true;
            }
            if (clinit.getCode() == null) {
                return false;
            }
            Set<Class<?>> analyzedClasses = existingAnalyzedClasses;
            if (analyzedClasses == null) {
                analyzedClasses = new HashSet();
            } else if (analyzedClasses.contains(clazz)) {
                return false;
            }
            analyzedClasses.add(clazz);
            OptionValues options = HostedOptionValues.singleton();
            DebugContext debug = new DebugContext.Builder(options).build();
            DebugContext.Scope s = debug.scope((Object)"EarlyClassInitializerAnalysis", (Object)clinit);
            try {
                bl = this.canInitializeWithoutSideEffects(clinit, analyzedClasses, options, debug);
                if (s == null) break block15;
            }
            catch (Throwable throwable) {
                try {
                    if (s != null) {
                        try {
                            s.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable ex) {
                    throw debug.handle(ex);
                }
            }
            s.close();
        }
        return bl;
    }

    private boolean canInitializeWithoutSideEffects(ResolvedJavaMethod clinit, Set<Class<?>> analyzedClasses, OptionValues options, DebugContext debug) {
        boolean bl;
        block10: {
            InvocationPlugins invocationPlugins = new InvocationPlugins();
            GraphBuilderConfiguration.Plugins plugins = new GraphBuilderConfiguration.Plugins(invocationPlugins);
            plugins.appendInlineInvokePlugin((InlineInvokePlugin)new AbortOnRecursiveInliningPlugin());
            AbortOnUnitializedClassPlugin classInitializationPlugin = new AbortOnUnitializedClassPlugin(analyzedClasses);
            plugins.setClassInitializationPlugin((ClassInitializationPlugin)classInitializationPlugin);
            plugins.appendNodePlugin((NodePlugin)new EarlyConstantFoldLoadFieldPlugin(this.originalProviders.getMetaAccess()));
            SubstrateGraphBuilderPlugins.registerClassDesiredAssertionStatusPlugin(invocationPlugins, this.originalProviders.getSnippetReflection());
            FallbackFeature fallbackFeature = ImageSingletons.contains(FallbackFeature.class) ? (FallbackFeature)ImageSingletons.lookup(FallbackFeature.class) : null;
            ReflectionPlugins.registerInvocationPlugins(this.classInitializationSupport.loader, this.originalProviders.getSnippetReflection(), null, (ClassInitializationPlugin)classInitializationPlugin, invocationPlugins, null, ParsingReason.EarlyClassInitializerAnalysis, fallbackFeature);
            GraphBuilderConfiguration graphBuilderConfig = GraphBuilderConfiguration.getDefault((GraphBuilderConfiguration.Plugins)plugins).withEagerResolving(true);
            StructuredGraph graph = new StructuredGraph.Builder(options, debug).method(clinit).recordInlinedMethods(false).build();
            graph.getGraphState().setGuardsStage(GraphState.GuardsStage.FIXED_DEOPTS);
            graph.getGraphState().setAfterStage(GraphState.StageFlag.GUARD_LOWERING);
            ClassInitializerGraphBuilderPhase builderPhase = new ClassInitializerGraphBuilderPhase((CoreProviders)this.context, graphBuilderConfig, this.context.getOptimisticOptimizations());
            Graph.NodeEventScope nes = graph.trackNodeEvents((Graph.NodeEventListener)new AbortOnDisallowedNode());
            try {
                builderPhase.apply(graph, this.context);
                bl = true;
                if (nes == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (nes != null) {
                        try {
                            nes.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ClassInitializerHasSideEffectsException ex) {
                    return false;
                }
                catch (BytecodeParser.BytecodeParserError ex) {
                    if (ex.getCause() instanceof ClassInitializerHasSideEffectsException) {
                        return false;
                    }
                    throw ex;
                }
            }
            nes.close();
        }
        return bl;
    }

    final class AbortOnUnitializedClassPlugin
    extends NoClassInitializationPlugin {
        private final Set<Class<?>> analyzedClasses;

        AbortOnUnitializedClassPlugin(Set<Class<?>> analyzedClasses) {
            this.analyzedClasses = analyzedClasses;
        }

        public boolean apply(GraphBuilderContext b, ResolvedJavaType type, Supplier<FrameState> frameState) {
            ResolvedJavaMethod clinitMethod = b.getGraph().method();
            if (!EnsureClassInitializedNode.needsRuntimeInitialization(clinitMethod.getDeclaringClass(), type)) {
                return false;
            }
            if (EarlyClassInitializerAnalysis.this.classInitializationSupport.computeInitKindAndMaybeInitializeClass(OriginalClassProvider.getJavaClass((JavaType)type), true, this.analyzedClasses) != InitKind.RUN_TIME) {
                assert (type.isInitialized()) : "Type must be initialized now";
                return false;
            }
            throw new ClassInitializerHasSideEffectsException("Reference of class that is not initialized: " + type.toJavaName(true));
        }
    }
}

