/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.classinitialization;

import com.oracle.svm.core.option.LocatableMultiOptionValue;
import com.oracle.svm.hosted.classinitialization.ClassInitializationOptions;
import java.util.Iterator;
import java.util.NoSuchElementException;
import jdk.graal.compiler.options.OptionDescriptor;
import jdk.graal.compiler.options.OptionDescriptors;
import jdk.graal.compiler.options.OptionStability;
import jdk.graal.compiler.options.OptionType;

public class ClassInitializationOptions_OptionDescriptors
implements OptionDescriptors {
    public OptionDescriptor get(String value) {
        switch (value) {
            case "AllowDeprecatedInitializeAllClassesAtBuildTime": {
                return OptionDescriptor.create((String)"AllowDeprecatedInitializeAllClassesAtBuildTime", (OptionType)OptionType.Debug, Boolean.class, (String)"Instead of abort, only warn if --initialize-at-build-time= is used.", ClassInitializationOptions.class, (String)"AllowDeprecatedInitializeAllClassesAtBuildTime", ClassInitializationOptions.AllowDeprecatedInitializeAllClassesAtBuildTime, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)true, (String)"This option was introduced to simplify migration to GraalVM 23.0 and will be removed in a future release");
            }
            case "AssertInitializationSpecifiedForAllClasses": {
                return OptionDescriptor.create((String)"AssertInitializationSpecifiedForAllClasses", (OptionType)OptionType.Debug, Boolean.class, (String)"Assert class initialization is specified for all classes.", ClassInitializationOptions.class, (String)"AssertInitializationSpecifiedForAllClasses", ClassInitializationOptions.AssertInitializationSpecifiedForAllClasses, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "ClassInitialization": {
                return OptionDescriptor.create((String)"ClassInitialization", (OptionType)OptionType.User, LocatableMultiOptionValue.Strings.class, (String)"A comma-separated list of classes appended with their initialization strategy (':build_time', ':rerun', or ':run_time')", ClassInitializationOptions.class, (String)"ClassInitialization", ClassInitializationOptions.ClassInitialization, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "PrintClassInitialization": {
                return OptionDescriptor.create((String)"PrintClassInitialization", (OptionType)OptionType.Debug, Boolean.class, (String)"Prints class initialization info for all classes detected by analysis.", ClassInitializationOptions.class, (String)"PrintClassInitialization", ClassInitializationOptions.PrintClassInitialization, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "SimulateClassInitializer": {
                return OptionDescriptor.create((String)"SimulateClassInitializer", (OptionType)OptionType.Expert, Boolean.class, (String)"Simulate the effects of class initializer at image build time, to avoid class initialization at run time.", ClassInitializationOptions.class, (String)"SimulateClassInitializer", ClassInitializationOptions.SimulateClassInitializer, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "SimulateClassInitializerCollectAllReasons": {
                return OptionDescriptor.create((String)"SimulateClassInitializerCollectAllReasons", (OptionType)OptionType.Expert, Boolean.class, (String)"Configuration for SimulateClassInitializer: Collect all reasons why a class initializer cannot be simulated.", ClassInitializationOptions.class, (String)"SimulateClassInitializerCollectAllReasons", ClassInitializationOptions.SimulateClassInitializerCollectAllReasons, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "SimulateClassInitializerMaxAllocatedBytes": {
                return OptionDescriptor.create((String)"SimulateClassInitializerMaxAllocatedBytes", (OptionType)OptionType.Expert, Integer.class, (String)"Configuration for SimulateClassInitializer: Maximum number of bytes allocated in the image heap for each class initializer.", ClassInitializationOptions.class, (String)"SimulateClassInitializerMaxAllocatedBytes", ClassInitializationOptions.SimulateClassInitializerMaxAllocatedBytes, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "SimulateClassInitializerMaxInlineDepth": {
                return OptionDescriptor.create((String)"SimulateClassInitializerMaxInlineDepth", (OptionType)OptionType.Expert, Integer.class, (String)"Configuration for SimulateClassInitializer: Maximum inlining depth during simulation.", ClassInitializationOptions.class, (String)"SimulateClassInitializerMaxInlineDepth", ClassInitializationOptions.SimulateClassInitializerMaxInlineDepth, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "SimulateClassInitializerMaxLoopIterations": {
                return OptionDescriptor.create((String)"SimulateClassInitializerMaxLoopIterations", (OptionType)OptionType.Expert, Integer.class, (String)"Configuration for SimulateClassInitializer: Maximum number of loop iterations that are unrolled during simulation.", ClassInitializationOptions.class, (String)"SimulateClassInitializerMaxLoopIterations", ClassInitializationOptions.SimulateClassInitializerMaxLoopIterations, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "StrictImageHeap": {
                return OptionDescriptor.create((String)"StrictImageHeap", (OptionType)OptionType.User, Boolean.class, (String)"Enable the strict image heap mode that allows all classes to be used at build-time but also requires types of all objects in the heap to be explicitly marked for build-time initialization.", ClassInitializationOptions.class, (String)"StrictImageHeap", ClassInitializationOptions.StrictImageHeap, (OptionStability)OptionStability.EXPERIMENTAL, (boolean)true, (String)"This option was introduced to simplify migration to GraalVM 24.0 and will be removed in a future release");
            }
        }
        return null;
    }

    public Iterator<OptionDescriptor> iterator() {
        return new Iterator<OptionDescriptor>(){
            int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < 10;
            }

            @Override
            public OptionDescriptor next() {
                switch (this.i++) {
                    case 0: {
                        return ClassInitializationOptions_OptionDescriptors.this.get("AllowDeprecatedInitializeAllClassesAtBuildTime");
                    }
                    case 1: {
                        return ClassInitializationOptions_OptionDescriptors.this.get("AssertInitializationSpecifiedForAllClasses");
                    }
                    case 2: {
                        return ClassInitializationOptions_OptionDescriptors.this.get("ClassInitialization");
                    }
                    case 3: {
                        return ClassInitializationOptions_OptionDescriptors.this.get("PrintClassInitialization");
                    }
                    case 4: {
                        return ClassInitializationOptions_OptionDescriptors.this.get("SimulateClassInitializer");
                    }
                    case 5: {
                        return ClassInitializationOptions_OptionDescriptors.this.get("SimulateClassInitializerCollectAllReasons");
                    }
                    case 6: {
                        return ClassInitializationOptions_OptionDescriptors.this.get("SimulateClassInitializerMaxAllocatedBytes");
                    }
                    case 7: {
                        return ClassInitializationOptions_OptionDescriptors.this.get("SimulateClassInitializerMaxInlineDepth");
                    }
                    case 8: {
                        return ClassInitializationOptions_OptionDescriptors.this.get("SimulateClassInitializerMaxLoopIterations");
                    }
                    case 9: {
                        return ClassInitializationOptions_OptionDescriptors.this.get("StrictImageHeap");
                    }
                }
                throw new NoSuchElementException();
            }
        };
    }
}

