/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.threadlocal;

import com.oracle.svm.core.BuildPhaseProvider;
import com.oracle.svm.core.SubstrateDiagnostics;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.feature.AutomaticallyRegisteredImageSingleton;
import com.oracle.svm.core.heap.ReferenceAccess;
import com.oracle.svm.core.heap.UnknownObjectField;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.threadlocal.FastThreadLocal;
import com.oracle.svm.core.threadlocal.FastThreadLocalBytes;
import com.oracle.svm.core.threadlocal.FastThreadLocalInt;
import com.oracle.svm.core.threadlocal.FastThreadLocalLong;
import com.oracle.svm.core.threadlocal.FastThreadLocalObject;
import com.oracle.svm.core.threadlocal.FastThreadLocalWord;
import com.oracle.svm.core.threadlocal.VMThreadLocalInfo;
import com.oracle.svm.core.threadlocal.VMThreadLocalSTSupport;
import java.util.Collection;
import jdk.graal.compiler.word.ObjectAccess;
import jdk.graal.compiler.word.Word;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

@AutomaticallyRegisteredImageSingleton
public class VMThreadLocalInfos {
    @UnknownObjectField(availability=BuildPhaseProvider.ReadyForCompilation.class)
    private VMThreadLocalInfo[] infos;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static void setInfos(Collection<VMThreadLocalInfo> infos) {
        VMThreadLocalInfos singleton = (VMThreadLocalInfos)ImageSingletons.lookup(VMThreadLocalInfos.class);
        singleton.infos = infos.toArray(new VMThreadLocalInfo[0]);
    }

    public static void dumpToLog(Log log, IsolateThread thread, boolean isJavaHeapAccessAllowed) {
        for (VMThreadLocalInfo info : ((VMThreadLocalInfos)ImageSingletons.lookup(VMThreadLocalInfos.class)).infos) {
            log.signed(info.offset).string(": ").string(info.name).string(" = ");
            if (info.threadLocalClass == FastThreadLocalInt.class) {
                int value = VMThreadLocalInfos.primitiveData(thread).readInt((WordBase)WordFactory.signed((int)info.offset));
                log.string("(int) ").zhex(value).string(" (").signed(value).string(")");
            } else if (info.threadLocalClass == FastThreadLocalLong.class) {
                long value = VMThreadLocalInfos.primitiveData(thread).readLong((WordBase)WordFactory.signed((int)info.offset));
                log.string("(long) ").zhex(value).string(" (").signed(value).string(")");
            } else if (info.threadLocalClass == FastThreadLocalWord.class) {
                WordBase value = VMThreadLocalInfos.primitiveData(thread).readWord((WordBase)WordFactory.signed((int)info.offset));
                log.string("(Word) ").zhex(value).string(" (").signed(value).string(")");
            } else if (info.threadLocalClass == FastThreadLocalObject.class) {
                if (isJavaHeapAccessAllowed) {
                    Object value = ObjectAccess.readObject((Object)VMThreadLocalInfos.objectData(thread), (WordBase)WordFactory.signed((int)info.offset));
                    log.string("(Object) ").zhex((WordBase)Word.objectToUntrackedPointer((Object)value));
                    if (value != null) {
                        log.indent(true);
                        SubstrateDiagnostics.printObjectInfo(log, value);
                        log.redent(false);
                    }
                } else {
                    Word value = ReferenceAccess.singleton().readObjectAsUntrackedPointer((Pointer)Word.objectToUntrackedPointer((Object)VMThreadLocalInfos.objectData(thread)).add(info.offset), true);
                    log.string("(Object) ").zhex((WordBase)value);
                }
            } else if (info.threadLocalClass == FastThreadLocalBytes.class) {
                log.string("(bytes) ");
                Pointer data = VMThreadLocalInfos.primitiveData(thread).add((UnsignedWord)WordFactory.signed((int)info.offset));
                if (info.sizeInBytes == 8) {
                    log.zhex(data.readWord(0));
                } else {
                    log.indent(true);
                    if (info.sizeInBytes % 8 == 0) {
                        log.hexdump((PointerBase)data, 8, info.sizeInBytes / 8);
                    } else {
                        log.hexdump((PointerBase)data, 1, info.sizeInBytes);
                    }
                    log.redent(false);
                }
            } else {
                log.string("unknown class ").string(info.threadLocalClass.getName());
            }
            log.newline();
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static Pointer primitiveData(IsolateThread thread) {
        if (SubstrateOptions.MultiThreaded.getValue().booleanValue()) {
            return (Pointer)thread;
        }
        return Word.objectToUntrackedPointer((Object)((VMThreadLocalSTSupport)ImageSingletons.lookup(VMThreadLocalSTSupport.class)).primitiveThreadLocals);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static Object objectData(IsolateThread thread) {
        if (SubstrateOptions.MultiThreaded.getValue().booleanValue()) {
            return ((Pointer)thread).toObjectNonNull();
        }
        return ((VMThreadLocalSTSupport)ImageSingletons.lookup(VMThreadLocalSTSupport.class)).objectThreadLocals;
    }

    public static int getOffset(FastThreadLocal threadLocal) {
        VMThreadLocalInfos singleton = (VMThreadLocalInfos)ImageSingletons.lookup(VMThreadLocalInfos.class);
        for (VMThreadLocalInfo info : singleton.infos) {
            if (!threadLocal.getLocationIdentity().equals(info.locationIdentity)) continue;
            return info.offset;
        }
        return -1;
    }
}

