/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.riscv64;

import com.oracle.svm.core.FrameAccess;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.feature.AutomaticallyRegisteredImageSingleton;
import jdk.graal.compiler.api.replacements.Fold;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.function.CodePointer;
import org.graalvm.word.Pointer;
import org.graalvm.word.WordBase;

@AutomaticallyRegisteredImageSingleton(value={FrameAccess.class})
@Platforms(value={Platform.RISCV64.class})
public class RISCV64FrameAccess
extends FrameAccess {
    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public CodePointer readReturnAddress(Pointer sourceSp) {
        return (CodePointer)sourceSp.readWord(-RISCV64FrameAccess.returnAddressSize());
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void writeReturnAddress(Pointer sourceSp, CodePointer newReturnAddress) {
        sourceSp.writeWord(-RISCV64FrameAccess.returnAddressSize(), (WordBase)newReturnAddress);
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public Pointer getReturnAddressLocation(Pointer sourceSp) {
        return sourceSp.subtract(RISCV64FrameAccess.returnAddressSize());
    }

    @Override
    @Fold
    public int savedBasePointerSize() {
        return RISCV64FrameAccess.wordSize();
    }

    @Override
    @Fold
    public int stackPointerAdjustmentOnCall() {
        return 0;
    }
}

