/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.reflect.serialize;

import com.oracle.svm.core.MissingRegistrationUtils;
import com.oracle.svm.core.reflect.serialize.MissingSerializationRegistrationError;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public final class MissingSerializationRegistrationUtils {
    private static final Map<String, Set<String>> serializationEntryPoints = Map.of(ObjectOutputStream.class.getTypeName(), Set.of("writeObject", "writeUnshared"), ObjectInputStream.class.getTypeName(), Set.of("readObject", "readUnshared"), ObjectStreamClass.class.getTypeName(), Set.of("lookup"), "sun.reflect.ReflectionFactory", Set.of("newConstructorForSerialization"), "jdk.internal.reflect.ReflectionFactory", Set.of("newConstructorForSerialization"));

    public static void missingSerializationRegistration(Class<?> cl, String ... msg) {
        MissingSerializationRegistrationUtils.report(new MissingSerializationRegistrationError(MissingSerializationRegistrationUtils.errorMessage(msg), cl));
    }

    private static String errorMessage(String ... type) {
        String typeStr = Arrays.stream(type).collect(Collectors.joining(System.lineSeparator(), "   ", ""));
        return "The program tried to serialize or deserialize\n\n%s\n\nwithout it being registered for serialization. Add this class to the serialization metadata to solve this problem.\nSee https://www.graalvm.org/latest/reference-manual/native-image/metadata/#serialization for help\n".replaceAll("\n", System.lineSeparator()).formatted(typeStr);
    }

    private static void report(MissingSerializationRegistrationError exception) {
        StackTraceElement responsibleClass = MissingSerializationRegistrationUtils.getResponsibleClass(exception);
        MissingRegistrationUtils.report(exception, responsibleClass);
    }

    private static StackTraceElement getResponsibleClass(MissingSerializationRegistrationError t) {
        StackTraceElement[] stackTrace = t.getStackTrace();
        boolean previous = false;
        StackTraceElement lastElem = null;
        for (StackTraceElement stackTraceElement : stackTrace) {
            if (previous) {
                previous = false;
                lastElem = stackTraceElement;
            }
            if (!serializationEntryPoints.getOrDefault(stackTraceElement.getClassName(), Set.of()).contains(stackTraceElement.getMethodName())) continue;
            previous = true;
        }
        return lastElem;
    }
}

