/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.reflect.proxy;

import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.hub.PredefinedClassesSupport;
import com.oracle.svm.core.jdk.proxy.DynamicProxyRegistry;
import com.oracle.svm.core.reflect.MissingReflectionRegistrationUtils;
import com.oracle.svm.core.util.ImageHeapMap;
import com.oracle.svm.util.ClassUtil;
import com.oracle.svm.util.LogUtils;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.reflect.Executable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.regex.Pattern;
import jdk.graal.compiler.debug.GraalError;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.EconomicSet;
import org.graalvm.collections.Equivalence;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.hosted.RuntimeClassInitialization;
import org.graalvm.nativeimage.hosted.RuntimeReflection;

public class DynamicProxySupport
implements DynamicProxyRegistry {
    public static final Pattern PROXY_CLASS_NAME_PATTERN = Pattern.compile(".*\\$Proxy[0-9]+");
    private final EconomicSet<Class<?>> hostedProxyClasses = EconomicSet.create((Equivalence)Equivalence.IDENTITY);
    private final EconomicMap<ProxyCacheKey, Object> proxyCache = ImageHeapMap.create();

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public DynamicProxySupport() {
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public synchronized void addProxyClass(Class<?> ... interfaces) {
        Class[] intfs = (Class[])interfaces.clone();
        ProxyCacheKey key = new ProxyCacheKey(intfs);
        if (!this.proxyCache.containsKey((Object)key)) {
            this.proxyCache.put((Object)key, this.createProxyClass(intfs));
        }
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    private Object createProxyClass(Class<?>[] interfaces) {
        try {
            Class<?> clazz = DynamicProxySupport.createProxyClassFromImplementedInterfaces(interfaces);
            boolean isPredefinedProxy = Arrays.stream(interfaces).anyMatch(PredefinedClassesSupport::isPredefined);
            if (isPredefinedProxy) {
                PredefinedClassesSupport.registerClass(clazz);
                RuntimeClassInitialization.initializeAtRunTime((Class[])new Class[]{clazz});
            }
            RuntimeReflection.register((Executable[])new Executable[]{ReflectionUtil.lookupConstructor(clazz, (Class[])new Class[]{InvocationHandler.class})});
            for (Class<?> intf : interfaces) {
                RuntimeReflection.register((Executable[])intf.getMethods());
            }
            this.hostedProxyClasses.add(clazz);
            return clazz;
        }
        catch (Throwable t) {
            LogUtils.warning((String)"Could not create a proxy class from list of interfaces: %s. Reason: %s", (Object[])new Object[]{Arrays.toString(interfaces), t.getMessage()});
            return t;
        }
    }

    @Override
    @Platforms(value={Platform.HOSTED_ONLY.class})
    public Class<?> createProxyClassForSerialization(Class<?> ... interfaces) {
        Class[] intfs = (Class[])interfaces.clone();
        return DynamicProxySupport.createProxyClassFromImplementedInterfaces(intfs);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    private static Class<?> createProxyClassFromImplementedInterfaces(Class<?>[] interfaces) {
        return DynamicProxySupport.getJdkProxyClass(DynamicProxySupport.getCommonClassLoaderOrFail(null, interfaces), interfaces);
    }

    private static ClassLoader getCommonClassLoaderOrFail(ClassLoader loader, Class<?> ... intfs) {
        ClassLoader commonLoader = null;
        for (Class<?> intf : intfs) {
            ClassLoader intfLoader = intf.getClassLoader();
            if (ClassUtil.isSameOrParentLoader(commonLoader, (ClassLoader)intfLoader)) {
                commonLoader = intfLoader;
                continue;
            }
            if (ClassUtil.isSameOrParentLoader((ClassLoader)intfLoader, (ClassLoader)commonLoader)) continue;
            throw DynamicProxySupport.incompatibleClassLoaders(loader, intfs);
        }
        return commonLoader;
    }

    @Override
    public Class<?> getProxyClass(ClassLoader loader, Class<?> ... interfaces) {
        ProxyCacheKey key = new ProxyCacheKey(interfaces);
        Object clazzOrError = this.proxyCache.get((Object)key);
        if (clazzOrError == null) {
            MissingReflectionRegistrationUtils.forProxy(interfaces);
        }
        if (clazzOrError instanceof Throwable) {
            throw new GraalError((Throwable)clazzOrError);
        }
        Class clazz = (Class)clazzOrError;
        if (!DynamicHub.fromClass(clazz).isLoaded()) {
            ClassLoader commonLoader = DynamicProxySupport.getCommonClassLoaderOrFail(loader, interfaces);
            if (!ClassUtil.isSameOrParentLoader((ClassLoader)commonLoader, (ClassLoader)loader)) {
                throw DynamicProxySupport.incompatibleClassLoaders(loader, interfaces);
            }
            boolean loaded = PredefinedClassesSupport.loadClassIfNotLoaded(commonLoader, null, clazz);
            if (!loaded && !ClassUtil.isSameOrParentLoader((ClassLoader)clazz.getClassLoader(), (ClassLoader)loader)) {
                throw DynamicProxySupport.incompatibleClassLoaders(loader, interfaces);
            }
        } else if (!ClassUtil.isSameOrParentLoader((ClassLoader)clazz.getClassLoader(), (ClassLoader)loader)) {
            throw DynamicProxySupport.incompatibleClassLoaders(loader, interfaces);
        }
        return clazz;
    }

    private static RuntimeException incompatibleClassLoaders(ClassLoader provided, Class<?>[] interfaces) {
        StringBuilder b = new StringBuilder("Interface(s) not visible to the provided class loader: ");
        DynamicProxySupport.describeLoaderChain(b, provided);
        for (Class<?> intf : interfaces) {
            b.append("; interface ").append(intf.getName()).append(" loaded by ");
            DynamicProxySupport.describeLoaderChain(b, intf.getClassLoader());
        }
        throw new IllegalArgumentException(b.toString());
    }

    private static void describeLoaderChain(StringBuilder b, ClassLoader loader) {
        ClassLoader l = loader;
        while (true) {
            if (l != loader) {
                b.append(", child of ");
            }
            b.append(l);
            if (l == null) break;
            l = l.getParent();
        }
    }

    @Override
    public boolean isProxyClass(Class<?> clazz) {
        if (SubstrateUtil.HOSTED) {
            return this.isHostedProxyClass(clazz);
        }
        return DynamicHub.fromClass(clazz).isProxyClass();
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    private synchronized boolean isHostedProxyClass(Class<?> clazz) {
        return this.hostedProxyClasses.contains(clazz);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static Class<?> getJdkProxyClass(ClassLoader loader, Class<?> ... interfaces) {
        return Proxy.getProxyClass(loader, interfaces);
    }

    static final class ProxyCacheKey {
        private final Class<?>[] interfaces;

        private ProxyCacheKey(Class<?> ... interfaces) {
            this.interfaces = interfaces;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ProxyCacheKey) {
                ProxyCacheKey that = (ProxyCacheKey)obj;
                return Arrays.equals(this.interfaces, that.interfaces);
            }
            return false;
        }

        public int hashCode() {
            return Arrays.hashCode(this.interfaces);
        }

        public String toString() {
            return Arrays.toString(this.interfaces);
        }
    }
}

