/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.reflect.fieldaccessor;

import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.util.VMError;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import jdk.internal.misc.Unsafe;
import jdk.internal.reflect.FieldAccessor;

abstract class UnsafeFieldAccessorImpl
implements FieldAccessor {
    protected final Field field;
    static final Unsafe unsafe = Unsafe.getUnsafe();
    protected final long fieldOffset;
    protected final boolean isFinal;

    UnsafeFieldAccessorImpl(Field field) {
        VMError.guarantee(!SubstrateUtil.HOSTED, "UnsafeFieldAccessors must only be create at runtime.");
        this.field = field;
        int mods = field.getModifiers();
        this.isFinal = Modifier.isFinal(mods);
        this.fieldOffset = Modifier.isStatic(mods) ? unsafe.staticFieldOffset(field) : unsafe.objectFieldOffset(field);
    }

    @Override
    public abstract Object get(Object var1) throws IllegalArgumentException;

    @Override
    public abstract boolean getBoolean(Object var1) throws IllegalArgumentException;

    @Override
    public abstract byte getByte(Object var1) throws IllegalArgumentException;

    @Override
    public abstract char getChar(Object var1) throws IllegalArgumentException;

    @Override
    public abstract short getShort(Object var1) throws IllegalArgumentException;

    @Override
    public abstract int getInt(Object var1) throws IllegalArgumentException;

    @Override
    public abstract long getLong(Object var1) throws IllegalArgumentException;

    @Override
    public abstract float getFloat(Object var1) throws IllegalArgumentException;

    @Override
    public abstract double getDouble(Object var1) throws IllegalArgumentException;

    @Override
    public abstract void set(Object var1, Object var2) throws IllegalArgumentException, IllegalAccessException;

    @Override
    public abstract void setBoolean(Object var1, boolean var2) throws IllegalArgumentException, IllegalAccessException;

    @Override
    public abstract void setByte(Object var1, byte var2) throws IllegalArgumentException, IllegalAccessException;

    @Override
    public abstract void setChar(Object var1, char var2) throws IllegalArgumentException, IllegalAccessException;

    @Override
    public abstract void setShort(Object var1, short var2) throws IllegalArgumentException, IllegalAccessException;

    @Override
    public abstract void setInt(Object var1, int var2) throws IllegalArgumentException, IllegalAccessException;

    @Override
    public abstract void setLong(Object var1, long var2) throws IllegalArgumentException, IllegalAccessException;

    @Override
    public abstract void setFloat(Object var1, float var2) throws IllegalArgumentException, IllegalAccessException;

    @Override
    public abstract void setDouble(Object var1, double var2) throws IllegalArgumentException, IllegalAccessException;

    protected void ensureObj(Object o) {
        if (!this.field.getDeclaringClass().isAssignableFrom(o.getClass())) {
            this.throwSetIllegalArgumentException(o);
        }
    }

    protected String getQualifiedFieldName() {
        return this.field.getDeclaringClass().getName() + "." + this.field.getName();
    }

    protected IllegalArgumentException newGetIllegalArgumentException(String type) {
        return new IllegalArgumentException("Attempt to get " + this.field.getType().getName() + " field \"" + this.getQualifiedFieldName() + "\" with illegal data type conversion to " + type);
    }

    protected void throwFinalFieldIllegalAccessException(String attemptedType, String attemptedValue) throws IllegalAccessException {
        throw new IllegalAccessException(this.getSetMessage(attemptedType, attemptedValue));
    }

    protected void throwFinalFieldIllegalAccessException(Object o) throws IllegalAccessException {
        this.throwFinalFieldIllegalAccessException(o != null ? o.getClass().getName() : "", "");
    }

    protected void throwFinalFieldIllegalAccessException(boolean z) throws IllegalAccessException {
        this.throwFinalFieldIllegalAccessException("boolean", Boolean.toString(z));
    }

    protected void throwFinalFieldIllegalAccessException(char b) throws IllegalAccessException {
        this.throwFinalFieldIllegalAccessException("char", Character.toString(b));
    }

    protected void throwFinalFieldIllegalAccessException(byte b) throws IllegalAccessException {
        this.throwFinalFieldIllegalAccessException("byte", Byte.toString(b));
    }

    protected void throwFinalFieldIllegalAccessException(short b) throws IllegalAccessException {
        this.throwFinalFieldIllegalAccessException("short", Short.toString(b));
    }

    protected void throwFinalFieldIllegalAccessException(int i) throws IllegalAccessException {
        this.throwFinalFieldIllegalAccessException("int", Integer.toString(i));
    }

    protected void throwFinalFieldIllegalAccessException(long i) throws IllegalAccessException {
        this.throwFinalFieldIllegalAccessException("long", Long.toString(i));
    }

    protected void throwFinalFieldIllegalAccessException(float f) throws IllegalAccessException {
        this.throwFinalFieldIllegalAccessException("float", Float.toString(f));
    }

    protected void throwFinalFieldIllegalAccessException(double f) throws IllegalAccessException {
        this.throwFinalFieldIllegalAccessException("double", Double.toString(f));
    }

    protected IllegalArgumentException newGetBooleanIllegalArgumentException() {
        return this.newGetIllegalArgumentException("boolean");
    }

    protected IllegalArgumentException newGetByteIllegalArgumentException() {
        return this.newGetIllegalArgumentException("byte");
    }

    protected IllegalArgumentException newGetCharIllegalArgumentException() {
        return this.newGetIllegalArgumentException("char");
    }

    protected IllegalArgumentException newGetShortIllegalArgumentException() {
        return this.newGetIllegalArgumentException("short");
    }

    protected IllegalArgumentException newGetIntIllegalArgumentException() {
        return this.newGetIllegalArgumentException("int");
    }

    protected IllegalArgumentException newGetLongIllegalArgumentException() {
        return this.newGetIllegalArgumentException("long");
    }

    protected IllegalArgumentException newGetFloatIllegalArgumentException() {
        return this.newGetIllegalArgumentException("float");
    }

    protected IllegalArgumentException newGetDoubleIllegalArgumentException() {
        return this.newGetIllegalArgumentException("double");
    }

    protected String getSetMessage(String attemptedType, String attemptedValue) {
        Object err = "Can not set";
        if (Modifier.isStatic(this.field.getModifiers())) {
            err = (String)err + " static";
        }
        if (Modifier.isFinal(this.field.getModifiers())) {
            err = (String)err + " final";
        }
        err = (String)err + " " + this.field.getType().getName() + " field " + this.getQualifiedFieldName() + " to ";
        err = !attemptedValue.isEmpty() ? (String)err + "(" + attemptedType + ")" + attemptedValue : (!attemptedType.isEmpty() ? (String)err + attemptedType : (String)err + "null value");
        return err;
    }

    protected void throwSetIllegalArgumentException(String attemptedType, String attemptedValue) {
        throw new IllegalArgumentException(this.getSetMessage(attemptedType, attemptedValue));
    }

    protected void throwSetIllegalArgumentException(Object o) {
        this.throwSetIllegalArgumentException(o != null ? o.getClass().getName() : "", "");
    }

    protected void throwSetIllegalArgumentException(boolean b) {
        this.throwSetIllegalArgumentException("boolean", Boolean.toString(b));
    }

    protected void throwSetIllegalArgumentException(byte b) {
        this.throwSetIllegalArgumentException("byte", Byte.toString(b));
    }

    protected void throwSetIllegalArgumentException(char c) {
        this.throwSetIllegalArgumentException("char", Character.toString(c));
    }

    protected void throwSetIllegalArgumentException(short s) {
        this.throwSetIllegalArgumentException("short", Short.toString(s));
    }

    protected void throwSetIllegalArgumentException(int i) {
        this.throwSetIllegalArgumentException("int", Integer.toString(i));
    }

    protected void throwSetIllegalArgumentException(long l) {
        this.throwSetIllegalArgumentException("long", Long.toString(l));
    }

    protected void throwSetIllegalArgumentException(float f) {
        this.throwSetIllegalArgumentException("float", Float.toString(f));
    }

    protected void throwSetIllegalArgumentException(double d) {
        this.throwSetIllegalArgumentException("double", Double.toString(d));
    }
}

