/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix.linux;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.posix.PosixUtils;
import com.oracle.svm.core.posix.headers.Time;
import com.oracle.svm.core.posix.headers.linux.LinuxTime;
import java.util.Objects;
import org.graalvm.nativeimage.StackValue;

@TargetClass(value=System.class)
final class Target_java_lang_System_Linux {
    Target_java_lang_System_Linux() {
    }

    @Substitute
    @Uninterruptible(reason="Does basic math after a simple system call")
    private static long nanoTime() {
        Time.timespec tp = (Time.timespec)StackValue.get(Time.timespec.class);
        int status = LinuxTime.NoTransitions.clock_gettime(LinuxTime.CLOCK_MONOTONIC(), tp);
        PosixUtils.checkStatusIs0(status, "System.nanoTime(): clock_gettime(CLOCK_MONOTONIC) failed.");
        return tp.tv_sec() * 1000000000L + tp.tv_nsec();
    }

    @Substitute
    public static String mapLibraryName(String libname) {
        Objects.requireNonNull(libname);
        return "lib" + libname + ".so";
    }
}

