/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.nodes;

import com.oracle.svm.core.nodes.CFunctionEpilogueMarker;
import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.nodeinfo.InputType;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.AbstractStateSplit;
import jdk.graal.compiler.nodes.DeoptimizingNode;
import jdk.graal.compiler.nodes.FrameState;
import jdk.graal.compiler.nodes.debug.ControlFlowAnchored;
import jdk.graal.compiler.nodes.memory.SingleMemoryKill;
import jdk.graal.compiler.nodes.spi.Lowerable;
import org.graalvm.word.LocationIdentity;

@NodeInfo(cycles=NodeCycles.CYCLES_8, size=NodeSize.SIZE_8, allowedUsageTypes={InputType.Memory})
public final class CFunctionEpilogueNode
extends AbstractStateSplit
implements Lowerable,
SingleMemoryKill,
ControlFlowAnchored,
DeoptimizingNode.DeoptBefore {
    public static final NodeClass<CFunctionEpilogueNode> TYPE = NodeClass.create(CFunctionEpilogueNode.class);
    private final int oldThreadStatus;
    private CFunctionEpilogueMarker marker;
    @Node.OptionalInput(value=InputType.State)
    protected FrameState stateBefore;

    public CFunctionEpilogueNode(int oldThreadStatus) {
        super(TYPE, StampFactory.forVoid());
        this.oldThreadStatus = oldThreadStatus;
    }

    protected void afterClone(Node other) {
        super.afterClone(other);
        assert (this.marker == null) : "Marker must be unique";
    }

    public CFunctionEpilogueMarker getMarker() {
        if (this.marker == null) {
            this.marker = new CFunctionEpilogueMarker();
        }
        return this.marker;
    }

    public LocationIdentity getKilledLocationIdentity() {
        return LocationIdentity.any();
    }

    public int getOldThreadStatus() {
        return this.oldThreadStatus;
    }

    @Node.NodeIntrinsic
    public static native void cFunctionEpilogue(@Node.ConstantNodeParameter int var0);

    public boolean canDeoptimize() {
        return true;
    }

    public void setStateBefore(FrameState state) {
        this.updateUsages((Node)this.stateBefore, (Node)state);
        this.stateBefore = state;
    }

    public FrameState stateBefore() {
        return this.stateBefore;
    }

    public boolean canUseAsStateDuring() {
        return true;
    }
}

