/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.meta;

import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.meta.CompressedNullConstant;
import com.oracle.svm.core.meta.DirectSubstrateObjectConstant;
import com.oracle.svm.core.meta.ObjectConstantEquality;
import com.oracle.svm.util.ClassUtil;
import jdk.graal.compiler.core.common.type.CompressibleConstant;
import jdk.graal.compiler.core.common.type.TypedConstant;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.VMConstant;

public abstract class SubstrateObjectConstant
implements JavaConstant,
TypedConstant,
CompressibleConstant,
VMConstant {
    protected final boolean compressed;

    public static JavaConstant forObject(Object object) {
        return SubstrateObjectConstant.forObject(object, false);
    }

    public static JavaConstant forObject(Object object, boolean compressed) {
        if (object == null) {
            return compressed ? CompressedNullConstant.COMPRESSED_NULL : JavaConstant.NULL_POINTER;
        }
        return new DirectSubstrateObjectConstant(object, compressed);
    }

    public static JavaConstant forBoxedValue(JavaKind kind, Object value) {
        if (kind == JavaKind.Object) {
            return SubstrateObjectConstant.forObject(value);
        }
        return JavaConstant.forBoxedPrimitive((Object)value);
    }

    public static Object asObject(Constant constant) {
        if (JavaConstant.isNull((Constant)constant)) {
            return null;
        }
        return ((DirectSubstrateObjectConstant)constant).getObject();
    }

    public static <T> T asObject(Class<T> type, JavaConstant constant) {
        Object object;
        if (constant.isNonNull() && type.isInstance(object = ((DirectSubstrateObjectConstant)constant).getObject())) {
            return type.cast(object);
        }
        return null;
    }

    public static Object asObject(ResolvedJavaType type, JavaConstant constant) {
        if (constant.isNonNull() && constant instanceof DirectSubstrateObjectConstant) {
            Object object = ((DirectSubstrateObjectConstant)constant).getObject();
            if (type.isInstance(constant)) {
                return object;
            }
        }
        return null;
    }

    public static boolean isCompressed(JavaConstant constant) {
        return constant instanceof CompressibleConstant && ((CompressibleConstant)constant).isCompressed();
    }

    protected SubstrateObjectConstant(boolean compressed) {
        this.compressed = compressed;
    }

    public boolean isCompressed() {
        return this.compressed;
    }

    public boolean isNull() {
        return false;
    }

    public boolean isDefaultForKind() {
        return false;
    }

    public Object asBoxedPrimitive() {
        throw new IllegalArgumentException();
    }

    public int asInt() {
        throw new IllegalArgumentException();
    }

    public boolean asBoolean() {
        throw new IllegalArgumentException();
    }

    public long asLong() {
        throw new IllegalArgumentException();
    }

    public float asFloat() {
        throw new IllegalArgumentException();
    }

    public double asDouble() {
        throw new IllegalArgumentException();
    }

    public JavaKind getJavaKind() {
        return JavaKind.Object;
    }

    public final boolean equals(Object obj) {
        if (obj != this && obj instanceof SubstrateObjectConstant) {
            SubstrateObjectConstant other = (SubstrateObjectConstant)obj;
            return this.isCompressed() == other.isCompressed() && ObjectConstantEquality.get().test(this, other);
        }
        return obj == this;
    }

    public final int hashCode() {
        return this.getIdentityHashCode();
    }

    public static int computeIdentityHashCode(Object object) {
        if (SubstrateUtil.HOSTED && object instanceof DynamicHub) {
            return System.identityHashCode(((DynamicHub)object).getHostedJavaClass());
        }
        return System.identityHashCode(object);
    }

    public String toString() {
        return ClassUtil.getUnqualifiedName(this.getClass()) + "[" + this.getJavaKind().getJavaName() + "]";
    }

    public abstract SubstrateObjectConstant compress();

    public abstract SubstrateObjectConstant uncompress();
}

