/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.locks;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.locks.VMMutex;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

final class SingleThreadedVMMutex
extends VMMutex {
    @Platforms(value={Platform.HOSTED_ONLY.class})
    SingleThreadedVMMutex(String name) {
        super(name);
    }

    @Override
    @Uninterruptible(reason="Too early for safepoints.")
    public int initialize() {
        return 0;
    }

    @Override
    @Uninterruptible(reason="The isolate teardown is in progress.")
    public int destroy() {
        return 0;
    }

    @Override
    public VMMutex lock() {
        assert (!this.isOwner()) : "Recursive locking is not supported";
        this.setOwnerToCurrentThread();
        return this;
    }

    @Override
    @Uninterruptible(reason="Whole critical section needs to be uninterruptible.", callerMustBe=true)
    public void lockNoTransition() {
        assert (!this.isOwner()) : "Recursive locking is not supported";
        this.setOwnerToCurrentThread();
    }

    @Override
    @Uninterruptible(reason="Whole critical section needs to be uninterruptible.", callerMustBe=true)
    public void lockNoTransitionUnspecifiedOwner() {
        this.setOwnerToUnspecified();
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void unlock() {
        this.clearCurrentThreadOwner();
    }

    @Override
    @Uninterruptible(reason="Whole critical section needs to be uninterruptible.")
    public void unlockNoTransitionUnspecifiedOwner() {
        this.clearUnspecifiedOwner();
    }
}

