/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jfr;

import com.oracle.svm.core.os.VirtualMemoryProvider;
import jdk.graal.compiler.core.common.NumUtil;
import jdk.jfr.internal.Options;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public class JfrOptionSet {
    private static final int MEMORY_SIZE = 1;
    private static final int GLOBAL_BUFFER_SIZE = 2;
    private static final int GLOBAL_BUFFER_COUNT = 4;
    private static final int THREAD_BUFFER_SIZE = 8;
    private static final long MAX_ADJUSTED_GLOBAL_BUFFER_SIZE = 0x100000L;
    private static final long MIN_ADJUSTED_GLOBAL_BUFFER_SIZE_CUTOFF = 524288L;
    private static final long MIN_GLOBAL_BUFFER_SIZE = 65536L;
    private static final long MIN_GLOBAL_BUFFER_COUNT = 2L;
    private static final long MIN_THREAD_BUFFER_SIZE = 4096L;
    private static final long MIN_MEMORY_SIZE = 0x100000L;
    public final JfrOptionLong threadBufferSize = new JfrOptionLong(Options.getThreadBufferSize());
    public final JfrOptionLong globalBufferSize = new JfrOptionLong(Options.getGlobalBufferSize());
    public final JfrOptionLong globalBufferCount = new JfrOptionLong(Options.getGlobalBufferCount());
    public final JfrOptionLong memorySize = new JfrOptionLong(Options.getMemorySize());
    public final JfrOptionLong maxChunkSize = new JfrOptionLong(Options.getMaxChunkSize());

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public JfrOptionSet() {
    }

    public void validateAndAdjustMemoryOptions() {
        this.ensureValidMinimumSizes();
        this.ensureValidMemoryRelations();
        this.adjustMemoryOptions();
        assert (this.checkPostCondition());
    }

    private void ensureValidMinimumSizes() {
        if (this.memorySize.isUserValue() && this.memorySize.getValue() < 0x100000L) {
            throw new IllegalStateException("The value specified for the JFR option 'memorysize' is too low. Please use at least 1048576 bytes.");
        }
        if (this.globalBufferSize.isUserValue() && this.globalBufferSize.getValue() < 65536L) {
            throw new IllegalStateException("The value specified for the JFR option 'globalbuffersize' is too low. Please use at least 65536 bytes.");
        }
        if (this.globalBufferCount.isUserValue() && this.globalBufferCount.getValue() < 2L) {
            throw new IllegalStateException("The value specified for the JFR option 'globalbuffercount' is too low. Please use at least a value of 2.");
        }
        if (this.threadBufferSize.isUserValue() && this.threadBufferSize.getValue() < 4096L) {
            throw new IllegalStateException("The value specified for the JFR option 'thread_buffer_size' is too low. Please use at least 4096 bytes.");
        }
    }

    private void ensureValidMemoryRelations() {
        if (this.globalBufferSize.isUserValue()) {
            if (this.memorySize.isUserValue() && this.memorySize.getValue() < this.globalBufferSize.getValue()) {
                throw new IllegalStateException("The value of the JFR option 'memorySize' must not be smaller than value of the option 'globalbuffersize'.");
            }
            if (this.threadBufferSize.isUserValue() && this.globalBufferSize.getValue() < this.threadBufferSize.getValue()) {
                throw new IllegalStateException("The value of the JFR option 'globalbuffersize' must not be smaller than the value of the option 'thread_buffer_size'.");
            }
            if (this.globalBufferCount.isUserValue() && this.globalBufferCount.getValue() * this.globalBufferSize.getValue() < 0x100000L) {
                throw new IllegalStateException("The total size of all global JFR buffers must not be lower than 1048576 bytes.");
            }
        }
    }

    private void adjustMemoryOptions() {
        this.checkForAmbiguity();
        JfrOptionSet.pageSizeAlignUp(this.memorySize);
        JfrOptionSet.pageSizeAlignUp(this.globalBufferSize);
        JfrOptionSet.pageSizeAlignUp(this.threadBufferSize);
        int setOfOptions = 0;
        if (this.memorySize.isUserValue()) {
            setOfOptions |= 1;
        }
        if (this.globalBufferSize.isUserValue()) {
            setOfOptions |= 2;
        }
        if (this.globalBufferCount.isUserValue()) {
            setOfOptions |= 4;
        }
        if (this.threadBufferSize.isUserValue()) {
            setOfOptions |= 8;
        }
        switch (setOfOptions) {
            case 1: 
            case 9: {
                this.memoryAndThreadBufferSize();
                break;
            }
            case 5: {
                this.memorySizeAndBufferCount();
                break;
            }
            case 11: {
                assert (this.threadBufferSize.isUserValue());
            }
            case 3: {
                this.memorySizeAndGlobalBufferSize();
                break;
            }
            case 7: 
            case 15: {
                this.allOptionsSet();
                break;
            }
            case 14: {
                assert (this.globalBufferCount.isUserValue());
                assert (this.threadBufferSize.isUserValue());
            }
            case 6: {
                assert (this.globalBufferSize.isUserValue());
            }
            case 2: 
            case 4: 
            case 10: {
                this.globalBufferSize();
                break;
            }
            case 13: {
                assert (this.memorySize.isUserValue());
            }
            case 12: {
                assert (this.globalBufferCount.isUserValue());
            }
            case 8: {
                this.threadBufferSize();
                break;
            }
            default: {
                this.defaultSize();
            }
        }
    }

    private void memoryAndThreadBufferSize() {
        assert (this.memorySize.isUserValue());
        assert (!this.globalBufferCount.isUserValue());
        assert (!this.globalBufferSize.isUserValue());
        long pageSize = JfrOptionSet.getPageSize();
        long totalPages = this.memorySize.getValue() / pageSize;
        long perUnitPages = totalPages / this.globalBufferCount.getValue();
        long threadBufferPages = this.threadBufferSize.getValue() / pageSize;
        long maxBufferSizePages = 0x100000L / pageSize;
        long minBufferSizePages = totalPages * pageSize < this.memorySize.getDefaultValue() ? 65536L / pageSize : 524288L / pageSize;
        perUnitPages = JfrOptionSet.alignBufferSize(perUnitPages, maxBufferSizePages, minBufferSizePages);
        assert (perUnitPages % minBufferSizePages == 0L);
        long remainder = totalPages % perUnitPages;
        while (remainder >= perUnitPages >> 1 && perUnitPages > minBufferSizePages) {
            remainder = totalPages % (perUnitPages >>= 1);
        }
        assert (perUnitPages * pageSize >= 65536L);
        assert (perUnitPages * pageSize % 65536L == 0L);
        if (this.threadBufferSize.isUserValue() && threadBufferPages > perUnitPages) {
            perUnitPages = threadBufferPages;
        }
        long units = totalPages / perUnitPages;
        long rem = totalPages % perUnitPages;
        if (rem > 0L) {
            totalPages -= rem % units;
            perUnitPages += rem / units;
        }
        this.globalBufferCount.setValue(units);
        this.globalBufferSize.setValue(perUnitPages * pageSize);
        this.memorySize.setValue(totalPages * pageSize);
        this.threadBufferSize.setValue(threadBufferPages * pageSize);
    }

    private static long alignBufferSize(long bufferSizeInPages, long maxSizePages, long minSizePages) {
        long result = bufferSizeInPages;
        result = Math.min(result, maxSizePages);
        result = Math.max(result, minSizePages);
        long multiples = 0L;
        if (result < maxSizePages) {
            while (result >= minSizePages << (int)multiples) {
                ++multiples;
            }
            result = minSizePages << (int)multiples;
        }
        assert (result >= minSizePages && result <= maxSizePages);
        return result;
    }

    private void memorySizeAndBufferCount() {
        assert (this.memorySize.isUserValue());
        assert (!this.globalBufferSize.isUserValue());
        assert (!this.threadBufferSize.isUserValue());
        assert (this.globalBufferCount.isUserValue());
        this.setValuesUsingDivTotalByUnits();
    }

    private void memorySizeAndGlobalBufferSize() {
        assert (this.memorySize.isUserValue());
        assert (this.globalBufferSize.isUserValue());
        assert (!this.globalBufferCount.isUserValue());
        this.setValuesUsingDivTotalByPerUnit();
        if (this.threadBufferSize.getValue() > this.globalBufferSize.getValue()) {
            this.globalBufferSize.setValue(this.threadBufferSize.getValue());
            this.setValuesUsingDivTotalByPerUnit();
        }
    }

    private void allOptionsSet() {
        this.setValuesUsingDivTotalByPerUnit();
        if (this.threadBufferSize.getValue() > this.globalBufferSize.getValue()) {
            this.globalBufferSize.setValue(this.threadBufferSize.getValue());
            this.setValuesUsingDivTotalByPerUnit();
        }
    }

    private void globalBufferSize() {
        assert (!this.memorySize.isUserValue());
        if (this.threadBufferSize.getValue() > this.globalBufferSize.getValue()) {
            this.globalBufferSize.setValue(this.threadBufferSize.getValue());
        }
        this.memorySize.setValue(this.globalBufferSize.getValue() * this.globalBufferCount.getValue());
    }

    private void threadBufferSize() {
        assert (!this.globalBufferSize.isUserValue());
        assert (this.threadBufferSize.isUserValue());
        this.setValuesUsingDivTotalByUnits();
        if (this.threadBufferSize.getValue() > this.globalBufferSize.getValue()) {
            this.globalBufferSize.setValue(this.threadBufferSize.getValue());
            this.setValuesUsingDivTotalByPerUnit();
        }
    }

    private void defaultSize() {
        assert (!this.threadBufferSize.isUserValue());
        assert (!this.memorySize.isUserValue());
        assert (!this.globalBufferCount.isUserValue());
        assert (!this.globalBufferSize.isUserValue());
    }

    private void setValuesUsingDivTotalByUnits() {
        long pageSize = JfrOptionSet.getPageSize();
        long totalPages = this.memorySize.getValue() / pageSize;
        long perUnitPages = totalPages <= this.globalBufferCount.getValue() ? 1L : totalPages / this.globalBufferCount.getValue();
        long units = totalPages / perUnitPages;
        long rem = totalPages % perUnitPages;
        if (rem > 0L) {
            totalPages -= rem % units;
            perUnitPages += rem / units;
        }
        this.memorySize.setValue(totalPages * pageSize);
        this.globalBufferCount.setValue(units);
        this.globalBufferSize.setValue(perUnitPages * pageSize);
    }

    private void setValuesUsingDivTotalByPerUnit() {
        long pageSize = JfrOptionSet.getPageSize();
        long totalPages = this.memorySize.getValue() / pageSize;
        long perUnitPages = this.globalBufferSize.getValue() / pageSize;
        long units = totalPages / perUnitPages;
        long rem = totalPages % perUnitPages;
        if (rem > 0L) {
            totalPages -= rem % units;
            perUnitPages += rem / units;
        }
        this.memorySize.setValue(totalPages * pageSize);
        this.globalBufferCount.setValue(units);
        this.globalBufferSize.setValue(perUnitPages * pageSize);
    }

    private void checkForAmbiguity() {
        if (this.memorySize.isUserValue() && this.globalBufferSize.isUserValue() && this.globalBufferCount.isUserValue() && this.globalBufferSize.getValue() * this.globalBufferCount.getValue() != this.memorySize.getValue()) {
            throw new IllegalStateException("The values specified for the JFR options 'memorySize', 'globalbuffersize', and 'globalbuffercount' are causing an ambiguity when trying to determine how much memory to use. Try to remove one of the involved options or make sure they are unambiguous.");
        }
    }

    private boolean checkPostCondition() {
        long pageSize = JfrOptionSet.getPageSize();
        assert (this.memorySize.getValue() >= 0x100000L);
        assert (this.memorySize.getValue() % pageSize == 0L);
        assert (this.memorySize.getValue() % this.globalBufferCount.getValue() == 0L);
        assert (this.memorySize.getValue() / this.globalBufferCount.getValue() == this.globalBufferSize.getValue());
        assert (this.globalBufferSize.getValue() >= 65536L);
        assert (this.globalBufferSize.getValue() % pageSize == 0L);
        assert (this.globalBufferSize.getValue() >= this.threadBufferSize.getValue());
        assert (this.globalBufferCount.getValue() >= 2L);
        assert (this.globalBufferCount.getValue() * this.globalBufferSize.getValue() == this.memorySize.getValue());
        assert (this.threadBufferSize.getValue() >= 4096L);
        assert (this.threadBufferSize.getValue() % pageSize == 0L);
        return true;
    }

    private static long getPageSize() {
        return VirtualMemoryProvider.get().getGranularity().rawValue();
    }

    private static void pageSizeAlignUp(JfrOptionLong option) {
        option.setValue(NumUtil.roundUp((long)option.getValue(), (long)JfrOptionSet.getPageSize()));
    }

    public static class JfrOptionLong {
        private final long defaultValue;
        private boolean setByUser;
        private long value;

        @Platforms(value={Platform.HOSTED_ONLY.class})
        JfrOptionLong(long defaultValue) {
            this.defaultValue = defaultValue;
            this.value = defaultValue;
            this.setByUser = false;
        }

        public long getDefaultValue() {
            return this.defaultValue;
        }

        public long getValue() {
            return this.value;
        }

        private void setValue(long v) {
            this.value = v;
        }

        public void setUserValue(long v) {
            this.value = v;
            this.setByUser = true;
        }

        public boolean isUserValue() {
            return this.setByUser;
        }
    }
}

