/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jfr;

import com.oracle.svm.core.jfr.Target_jdk_jfr_internal_JVMSupport;
import com.oracle.svm.core.jfr.Target_jdk_jfr_internal_Utils;
import com.oracle.svm.core.jfr.Target_jdk_jfr_internal_util_ValueFormatter;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.time.Duration;
import jdk.graal.compiler.serviceprovider.JavaVersionUtil;
import jdk.jfr.Recording;
import jdk.jfr.internal.JVM;
import jdk.jfr.internal.JVMSupport;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public final class JfrJdkCompatibility {
    private JfrJdkCompatibility() {
    }

    public static String makeFilename(Recording recording) {
        if (JavaVersionUtil.JAVA_SPEC >= 22) {
            return Target_jdk_jfr_internal_JVMSupport.makeFilename(recording);
        }
        return Target_jdk_jfr_internal_Utils.makeFilename(recording);
    }

    public static String formatTimespan(Duration dValue, String separation) {
        if (JavaVersionUtil.JAVA_SPEC >= 22) {
            return Target_jdk_jfr_internal_util_ValueFormatter.formatTimespan(dValue, separation);
        }
        return Target_jdk_jfr_internal_Utils.formatTimespan(dValue, separation);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static void createNativeJFR() {
        try {
            if (JavaVersionUtil.JAVA_SPEC >= 22) {
                Method createJFR = ReflectionUtil.lookupMethod(JVMSupport.class, (String)"createJFR", (Class[])new Class[0]);
                createJFR.invoke(null, new Object[0]);
            } else {
                Method createNativeJFR = ReflectionUtil.lookupMethod(JVM.class, (String)"createNativeJFR", (Class[])new Class[0]);
                createNativeJFR.invoke((Object)JfrJdkCompatibility.getJVMOrNull(), new Object[0]);
            }
        }
        catch (ClassCastException | ReflectiveOperationException e) {
            throw VMError.shouldNotReachHere(e);
        }
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static void retransformClasses(Class<?>[] classes) {
        try {
            Method retransformClasses = ReflectionUtil.lookupMethod(JVM.class, (String)"retransformClasses", (Class[])new Class[]{Class[].class});
            retransformClasses.invoke((Object)JfrJdkCompatibility.getJVMOrNull(), new Object[]{classes});
        }
        catch (ClassCastException | ReflectiveOperationException e) {
            throw VMError.shouldNotReachHere(e);
        }
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static JVM getJVMOrNull() throws IllegalAccessException, InvocationTargetException {
        if (JavaVersionUtil.JAVA_SPEC >= 22) {
            return null;
        }
        Method getJVM = ReflectionUtil.lookupMethod(JVM.class, (String)"getJVM", (Class[])new Class[0]);
        return (JVM)getJVM.invoke(null, new Object[0]);
    }
}

