/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk.management;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.jdk.UninterruptibleUtils;
import com.oracle.svm.core.thread.PlatformThreads;
import com.oracle.svm.core.thread.ThreadCpuTimeSupport;
import com.sun.management.ThreadMXBean;
import java.lang.management.ThreadInfo;
import java.util.Arrays;
import java.util.Objects;
import javax.management.ObjectName;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import sun.management.Util;

public final class SubstrateThreadMXBean
implements ThreadMXBean {
    private final UninterruptibleUtils.AtomicLong totalStartedThreadCount = new UninterruptibleUtils.AtomicLong(0L);
    private final UninterruptibleUtils.AtomicInteger peakThreadCount = new UninterruptibleUtils.AtomicInteger(0);
    private final UninterruptibleUtils.AtomicInteger threadCount = new UninterruptibleUtils.AtomicInteger(0);
    private final UninterruptibleUtils.AtomicInteger daemonThreadCount = new UninterruptibleUtils.AtomicInteger(0);
    private boolean allocatedMemoryEnabled = true;
    private boolean cpuTimeEnabled = true;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    SubstrateThreadMXBean() {
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    void noteThreadStart(Thread thread) {
        this.totalStartedThreadCount.incrementAndGet();
        int curThreadCount = this.threadCount.incrementAndGet();
        this.updatePeakThreadCount(curThreadCount);
        if (thread.isDaemon()) {
            this.daemonThreadCount.incrementAndGet();
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private void updatePeakThreadCount(int curThreadCount) {
        int oldPeak;
        while (curThreadCount > (oldPeak = this.peakThreadCount.get()) && !this.peakThreadCount.compareAndSet(oldPeak, curThreadCount)) {
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    void noteThreadFinish(Thread thread) {
        this.threadCount.decrementAndGet();
        if (thread.isDaemon()) {
            this.daemonThreadCount.decrementAndGet();
        }
    }

    @Override
    public ObjectName getObjectName() {
        return Util.newObjectName("java.lang:type=Threading");
    }

    @Override
    public boolean isThreadAllocatedMemoryEnabled() {
        return this.allocatedMemoryEnabled;
    }

    @Override
    public boolean isThreadAllocatedMemorySupported() {
        return true;
    }

    @Override
    public boolean isThreadCpuTimeSupported() {
        return ImageSingletons.contains(ThreadCpuTimeSupport.class);
    }

    @Override
    public boolean isCurrentThreadCpuTimeSupported() {
        return ImageSingletons.contains(ThreadCpuTimeSupport.class);
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public int getThreadCount() {
        return this.threadCount.get();
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public int getPeakThreadCount() {
        return this.peakThreadCount.get();
    }

    @Override
    public void resetPeakThreadCount() {
        this.peakThreadCount.set(this.threadCount.get());
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public long getTotalStartedThreadCount() {
        return this.totalStartedThreadCount.get();
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public int getDaemonThreadCount() {
        return this.daemonThreadCount.get();
    }

    @Override
    public long[] getAllThreadIds() {
        return new long[0];
    }

    @Override
    public ThreadInfo getThreadInfo(long id) {
        return null;
    }

    @Override
    public ThreadInfo[] getThreadInfo(long[] ids) {
        return new ThreadInfo[0];
    }

    @Override
    public ThreadInfo getThreadInfo(long id, int maxDepth) {
        return null;
    }

    @Override
    public ThreadInfo[] getThreadInfo(long[] ids, int maxDepth) {
        return new ThreadInfo[0];
    }

    @Override
    public boolean isThreadContentionMonitoringSupported() {
        return false;
    }

    @Override
    public boolean isThreadContentionMonitoringEnabled() {
        return false;
    }

    @Override
    public void setThreadContentionMonitoringEnabled(boolean enable) {
    }

    @Override
    public long getCurrentThreadCpuTime() {
        if (this.verifyCurrentThreadCpuTime()) {
            return ThreadCpuTimeSupport.getInstance().getCurrentThreadCpuTime(true);
        }
        return -1L;
    }

    @Override
    public long getCurrentThreadUserTime() {
        if (this.verifyCurrentThreadCpuTime()) {
            return ThreadCpuTimeSupport.getInstance().getCurrentThreadCpuTime(false);
        }
        return -1L;
    }

    private boolean verifyCurrentThreadCpuTime() {
        if (!this.isCurrentThreadCpuTimeSupported()) {
            throw new UnsupportedOperationException("Current thread CPU time measurement is not supported.");
        }
        return this.isThreadCpuTimeEnabled();
    }

    @Override
    public long getThreadCpuTime(long id) {
        if (this.verifyThreadCpuTime(id)) {
            return PlatformThreads.getThreadCpuTime(id, true);
        }
        return -1L;
    }

    @Override
    public long getThreadUserTime(long id) {
        if (this.verifyThreadCpuTime(id)) {
            return PlatformThreads.getThreadCpuTime(id, false);
        }
        return -1L;
    }

    private boolean verifyThreadCpuTime(long id) {
        SubstrateThreadMXBean.verifyThreadId(id);
        if (!this.isThreadCpuTimeSupported()) {
            throw new UnsupportedOperationException("Thread CPU time measurement is not supported.");
        }
        return this.isThreadCpuTimeEnabled();
    }

    @Override
    public boolean isThreadCpuTimeEnabled() {
        if (!this.isThreadCpuTimeSupported() && !this.isCurrentThreadCpuTimeSupported()) {
            throw new UnsupportedOperationException("Thread CPU time measurement is not supported");
        }
        return this.cpuTimeEnabled;
    }

    @Override
    public void setThreadCpuTimeEnabled(boolean enable) {
        if (!this.isThreadCpuTimeSupported() && !this.isCurrentThreadCpuTimeSupported()) {
            throw new UnsupportedOperationException("Thread CPU time measurement is not supported");
        }
        this.cpuTimeEnabled = enable;
    }

    @Override
    public long[] findMonitorDeadlockedThreads() {
        return new long[0];
    }

    @Override
    public long[] findDeadlockedThreads() {
        return new long[0];
    }

    @Override
    public boolean isObjectMonitorUsageSupported() {
        return false;
    }

    @Override
    public boolean isSynchronizerUsageSupported() {
        return false;
    }

    @Override
    public ThreadInfo[] getThreadInfo(long[] ids, boolean lockedMonitors, boolean lockedSynchronizers) {
        return new ThreadInfo[0];
    }

    @Override
    public ThreadInfo[] dumpAllThreads(boolean lockedMonitors, boolean lockedSynchronizers) {
        return new ThreadInfo[0];
    }

    @Override
    public long getThreadAllocatedBytes(long id) {
        boolean valid = this.verifyThreadAllocatedMemory(id);
        if (!valid) {
            return -1L;
        }
        return PlatformThreads.getThreadAllocatedBytes(id);
    }

    @Override
    public long[] getThreadAllocatedBytes(long[] ids) {
        Objects.requireNonNull(ids);
        boolean valid = this.verifyThreadAllocatedMemory(ids);
        long[] sizes = new long[ids.length];
        Arrays.fill(sizes, -1L);
        if (valid) {
            PlatformThreads.getThreadAllocatedBytes(ids, sizes);
        }
        return sizes;
    }

    private boolean verifyThreadAllocatedMemory(long id) {
        SubstrateThreadMXBean.verifyThreadId(id);
        return this.isThreadAllocatedMemoryEnabled();
    }

    private boolean verifyThreadAllocatedMemory(long[] ids) {
        SubstrateThreadMXBean.verifyThreadIds(ids);
        return this.isThreadAllocatedMemoryEnabled();
    }

    private static void verifyThreadId(long id) {
        if (id <= 0L) {
            throw new IllegalArgumentException("Invalid thread ID parameter: " + id);
        }
    }

    private static void verifyThreadIds(long[] ids) {
        for (int i = 0; i < ids.length; ++i) {
            SubstrateThreadMXBean.verifyThreadId(ids[i]);
        }
    }

    @Override
    public long[] getThreadCpuTime(long[] ids) {
        return this.getThreadCpuTimeImpl(ids, true);
    }

    @Override
    public long[] getThreadUserTime(long[] ids) {
        return this.getThreadCpuTimeImpl(ids, false);
    }

    private long[] getThreadCpuTimeImpl(long[] ids, boolean includeSystemTime) {
        boolean verified = this.verifyThreadCpuTime(ids);
        long[] times = new long[ids.length];
        Arrays.fill(times, -1L);
        if (verified) {
            for (int i = 0; i < ids.length; ++i) {
                times[i] = PlatformThreads.getThreadCpuTime(ids[i], includeSystemTime);
            }
        }
        return times;
    }

    private boolean verifyThreadCpuTime(long[] ids) {
        SubstrateThreadMXBean.verifyThreadIds(ids);
        if (!this.isThreadCpuTimeSupported()) {
            throw new UnsupportedOperationException("Thread CPU time measurement is not supported.");
        }
        return this.isThreadCpuTimeEnabled();
    }

    @Override
    public void setThreadAllocatedMemoryEnabled(boolean value) {
        this.allocatedMemoryEnabled = value;
    }
}

