/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.VM;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.util.VMError;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.function.Supplier;
import jdk.graal.compiler.api.replacements.Fold;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.impl.RuntimeSystemPropertiesSupport;

public abstract class SystemPropertiesSupport
implements RuntimeSystemPropertiesSupport {
    private static final String[] HOSTED_PROPERTIES = new String[]{"java.version", "java.version.date", "org.graalvm.nativeimage.kind", "line.separator", "path.separator", "file.separator", "file.encoding", "sun.jnu.encoding", "native.encoding", "stdout.encoding", "stderr.encoding", "java.class.version", "java.runtime.version", "java.specification.name", "java.specification.vendor", "java.specification.version", "java.vm.specification.name", "java.vm.specification.vendor", "java.vm.specification.version"};
    private final Map<String, Supplier<String>> lazyRuntimeValues;
    private Properties properties;
    final Map<String, String> savedProperties;
    private final Map<String, String> readOnlySavedProperties;
    private final String hostOS = System.getProperty("os.name");
    private volatile boolean fullyInitialized;
    private String cachedUserName;
    private String cachedUserHome;
    private String cachedUserDir;
    private String cachedJavaIoTmpdir;
    private String cachedJavaLibraryPath;

    @Fold
    public static SystemPropertiesSupport singleton() {
        return (SystemPropertiesSupport)ImageSingletons.lookup(SystemPropertiesSupport.class);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    protected SystemPropertiesSupport() {
        this.properties = new Properties();
        this.savedProperties = new HashMap<String, String>();
        this.readOnlySavedProperties = Collections.unmodifiableMap(this.savedProperties);
        for (String key : HOSTED_PROPERTIES) {
            String value = System.getProperty(key);
            if (value == null) continue;
            this.properties.put(key, value);
            this.savedProperties.put(key, value);
        }
        this.initializeProperty("java.runtime.name", "GraalVM Runtime Environment");
        VM vm = (VM)ImageSingletons.lookup(VM.class);
        this.initializeProperty("java.vendor", vm.vendor);
        this.initializeProperty("java.vendor.url", vm.vendorUrl);
        this.initializeProperty("java.vendor.version", vm.vendorVersion);
        assert (vm.info.equals(vm.info.toLowerCase())) : "java.vm.info should not contain uppercase characters";
        this.initializeProperty("java.vm.info", vm.info);
        this.initializeProperty("java.vm.name", "Substrate VM");
        this.initializeProperty("java.vm.vendor", vm.vendor);
        this.initializeProperty("java.vm.version", vm.version);
        this.initializeProperty("java.class.path", "");
        this.initializeProperty("java.endorsed.dirs", "");
        this.initializeProperty("java.ext.dirs", "");
        this.initializeProperty("sun.arch.data.model", Integer.toString(ConfigurationValues.getTarget().wordJavaKind.getBitCount()));
        this.initializeProperty("org.graalvm.nativeimage.imagecode", "runtime");
        this.lazyRuntimeValues = new HashMap<String, Supplier<String>>();
        this.lazyRuntimeValues.put("user.name", this::userName);
        this.lazyRuntimeValues.put("user.home", this::userHome);
        this.lazyRuntimeValues.put("user.dir", this::userDir);
        this.lazyRuntimeValues.put("java.io.tmpdir", this::javaIoTmpDir);
        this.lazyRuntimeValues.put("java.library.path", this::javaLibraryPath);
        this.lazyRuntimeValues.put("os.version", this::osVersionValue);
        String targetName = System.getProperty("svm.targetName");
        if (targetName != null) {
            this.initializeProperty("os.name", targetName);
        } else {
            this.lazyRuntimeValues.put("os.name", this::osNameValue);
        }
        String targetArch = System.getProperty("svm.targetArch");
        if (targetArch != null) {
            this.initializeProperty("os.arch", targetArch);
        } else {
            this.initializeProperty("os.arch", ((Platform)ImageSingletons.lookup(Platform.class)).getArchitecture());
        }
    }

    private void ensureFullyInitialized() {
        if (!this.fullyInitialized) {
            for (String key : this.lazyRuntimeValues.keySet()) {
                this.initializeLazyValue(key);
            }
            this.fullyInitialized = true;
        }
    }

    public Map<String, String> getSavedProperties() {
        this.ensureFullyInitialized();
        return this.readOnlySavedProperties;
    }

    public Properties getProperties() {
        this.ensureFullyInitialized();
        return this.properties;
    }

    protected String getProperty(String key) {
        this.initializeLazyValue(key);
        return this.properties.getProperty(key);
    }

    public void setProperties(Properties props) {
        this.ensureFullyInitialized();
        if (props == null) {
            Properties newProps = new Properties();
            for (Map.Entry<String, String> e : this.savedProperties.entrySet()) {
                newProps.setProperty(e.getKey(), e.getValue());
            }
            this.properties = newProps;
        } else {
            this.properties = props;
        }
    }

    public void initializeProperty(String key, String value) {
        this.initializeProperty(key, value, true);
    }

    public void initializeProperty(String key, String value, boolean strict) {
        String prevValue = this.savedProperties.put(key, value);
        if (strict && prevValue != null && !prevValue.equals(value)) {
            VMError.shouldNotReachHere("System property " + key + " is initialized to " + value + " but was previously initialized to " + prevValue + ".");
        }
        this.properties.setProperty(key, value);
    }

    public String setProperty(String key, String value) {
        this.initializeLazyValue(key);
        return (String)this.properties.setProperty(key, value);
    }

    public String clearProperty(String key) {
        this.initializeLazyValue(key);
        return (String)this.properties.remove(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeLazyValue(String key) {
        String value;
        if (!this.fullyInitialized && this.lazyRuntimeValues.containsKey(key) && this.properties.get(key) == null && this.properties.putIfAbsent(key, value = this.lazyRuntimeValues.get(key).get()) == null) {
            Map<String, String> map = this.savedProperties;
            synchronized (map) {
                this.savedProperties.put(key, value);
            }
        }
    }

    String userName() {
        if (this.cachedUserName == null) {
            this.cachedUserName = this.userNameValue();
        }
        return this.cachedUserName;
    }

    String userHome() {
        if (this.cachedUserHome == null) {
            this.cachedUserHome = this.userHomeValue();
        }
        return this.cachedUserHome;
    }

    String userDir() {
        if (this.cachedUserDir == null) {
            this.cachedUserDir = this.userDirValue();
        }
        return this.cachedUserDir;
    }

    String javaIoTmpDir() {
        if (this.cachedJavaIoTmpdir == null) {
            this.cachedJavaIoTmpdir = this.javaIoTmpdirValue();
        }
        return this.cachedJavaIoTmpdir;
    }

    String javaLibraryPath() {
        if (this.cachedJavaLibraryPath == null) {
            this.cachedJavaLibraryPath = this.javaLibraryPathValue();
        }
        return this.cachedJavaLibraryPath;
    }

    protected abstract String userNameValue();

    protected abstract String userHomeValue();

    protected abstract String userDirValue();

    protected String javaIoTmpdirValue() {
        return this.tmpdirValue();
    }

    protected String tmpdirValue() {
        throw VMError.intentionallyUnimplemented();
    }

    protected String javaLibraryPathValue() {
        return "";
    }

    protected String osNameValue() {
        return this.hostOS;
    }

    protected abstract String osVersionValue();
}

