/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.jdk.Resources;
import com.oracle.svm.core.util.VMError;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import jdk.internal.loader.Resource;
import org.graalvm.nativeimage.ImageInfo;

public class ResourcesHelper {
    private static Resource urlToResource(String resourceName, URL url) {
        try {
            if (url == null) {
                return null;
            }
            URLConnection urlConnection = url.openConnection();
            return ResourcesHelper.buildResource(resourceName, url, urlConnection);
        }
        catch (IOException e) {
            return null;
        }
        catch (ClassCastException classCastException) {
            throw VMError.shouldNotReachHere(classCastException);
        }
    }

    private static Resource buildResource(final String name, final URL url, final URLConnection urlConnection) {
        return new Resource(){

            @Override
            public String getName() {
                return name;
            }

            @Override
            public URL getURL() {
                return url;
            }

            @Override
            public URL getCodeSourceURL() {
                return null;
            }

            @Override
            public InputStream getInputStream() throws IOException {
                return urlConnection.getInputStream();
            }

            @Override
            public int getContentLength() throws IOException {
                return urlConnection.getContentLength();
            }
        };
    }

    public static Resource nameToResource(String resourceName) {
        return ResourcesHelper.urlToResource(resourceName, ResourcesHelper.nameToResourceURL(resourceName));
    }

    public static Enumeration<Resource> nameToResources(String resourceName) {
        Enumeration<URL> urls = Resources.singleton().createURLs(resourceName);
        ArrayList<Resource> resourceURLs = new ArrayList<Resource>();
        while (urls.hasMoreElements()) {
            resourceURLs.add(ResourcesHelper.urlToResource(resourceName, urls.nextElement()));
        }
        return Collections.enumeration(resourceURLs);
    }

    public static URL nameToResourceURL(String resourceName) {
        return Resources.singleton().createURL(resourceName);
    }

    public static URL nameToResourceURL(Module module, String resourceName) {
        return Resources.singleton().createURL(module, resourceName);
    }

    public static InputStream nameToResourceInputStream(String mn, String resourceName) throws IOException {
        VMError.guarantee(ImageInfo.inImageRuntimeCode(), "ResourcesHelper code should only be used at runtime");
        Module module = mn == null ? null : (Module)ModuleLayer.boot().findModule(mn).orElse(null);
        URL url = ResourcesHelper.nameToResourceURL(module, resourceName);
        return url != null ? url.openStream() : null;
    }

    public static List<URL> nameToResourceListURLs(String resourcesName) {
        Enumeration<URL> urls = Resources.singleton().createURLs(resourcesName);
        ArrayList<URL> resourceURLs = new ArrayList<URL>();
        while (urls.hasMoreElements()) {
            resourceURLs.add(urls.nextElement());
        }
        return resourceURLs;
    }

    public static Enumeration<URL> nameToResourceEnumerationURLs(String resourcesName) {
        return Collections.enumeration(ResourcesHelper.nameToResourceListURLs(resourcesName));
    }
}

