/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.jdk.Resources;
import com.oracle.svm.core.jdk.resources.ResourceStorageEntryBase;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticallyRegisteredFeature
final class ResourcesFeature
implements InternalFeature {
    ResourcesFeature() {
    }

    public void afterRegistration(Feature.AfterRegistrationAccess access) {
        ImageSingletons.add(Resources.class, (Object)new Resources());
    }

    public void afterCompilation(Feature.AfterCompilationAccess access) {
        for (ResourceStorageEntryBase entry : Resources.singleton().resources()) {
            if (!entry.hasData()) continue;
            for (byte[] resource : entry.getData()) {
                access.registerAsImmutable((Object)resource);
            }
        }
    }
}

