/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.phases;

import com.oracle.svm.core.graal.nodes.ThrowBytecodeExceptionNode;
import com.oracle.svm.core.meta.SharedMethod;
import java.util.ArrayList;
import java.util.List;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.nodes.AbstractBeginNode;
import jdk.graal.compiler.nodes.AbstractEndNode;
import jdk.graal.compiler.nodes.EndNode;
import jdk.graal.compiler.nodes.FixedNode;
import jdk.graal.compiler.nodes.FixedWithNextNode;
import jdk.graal.compiler.nodes.MergeNode;
import jdk.graal.compiler.nodes.PhiNode;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.UnwindNode;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.WithExceptionNode;
import jdk.graal.compiler.nodes.extended.BytecodeExceptionNode;
import jdk.graal.compiler.nodes.java.ExceptionObjectNode;
import jdk.graal.compiler.nodes.util.GraphUtil;
import jdk.graal.compiler.phases.Phase;

public class RemoveUnwindPhase
extends Phase {
    protected void run(StructuredGraph graph) {
        SharedMethod method = (SharedMethod)graph.method();
        if (method.isDeoptTarget()) {
            return;
        }
        ArrayList<WithExceptionNode> withExceptionNodes = new ArrayList<WithExceptionNode>();
        ArrayList<BytecodeExceptionNode> bytecodeExceptionNodes = new ArrayList<BytecodeExceptionNode>();
        for (UnwindNode unwindNode : graph.getNodes(UnwindNode.TYPE)) {
            RemoveUnwindPhase.walkBack(unwindNode.predecessor(), (Node)unwindNode, withExceptionNodes, bytecodeExceptionNodes, GraphUtil.unproxify((ValueNode)unwindNode.exception()), graph);
        }
        for (WithExceptionNode withExceptionNode : withExceptionNodes) {
            if (!withExceptionNode.isAlive()) continue;
            graph.getDebug().log(4, "Removing exception edge for: %s", (Object)withExceptionNode);
            withExceptionNode.replaceWithNonThrowing();
        }
        for (BytecodeExceptionNode bytecodeExceptionNode : bytecodeExceptionNodes) {
            if (!bytecodeExceptionNode.isAlive()) continue;
            graph.getDebug().log(4, "Converting a BytecodeException node to a ThrowBytecodeException node for: %s", (Object)bytecodeExceptionNode);
            RemoveUnwindPhase.convertToThrow(bytecodeExceptionNode);
        }
    }

    protected static void walkBack(Node n, Node successor, List<WithExceptionNode> withExceptionNodes, List<BytecodeExceptionNode> bytecodeExceptionNodes, ValueNode expectedExceptionNode, StructuredGraph graph) {
        if (n instanceof WithExceptionNode) {
            WithExceptionNode node = (WithExceptionNode)n;
            if (node.exceptionEdge() == successor) {
                withExceptionNodes.add(node);
            }
        } else if (n instanceof BytecodeExceptionNode || n instanceof ExceptionObjectNode) {
            if (n == expectedExceptionNode) {
                if (n instanceof BytecodeExceptionNode) {
                    BytecodeExceptionNode node = (BytecodeExceptionNode)n;
                    bytecodeExceptionNodes.add(node);
                } else {
                    RemoveUnwindPhase.walkBack(n.predecessor(), n, withExceptionNodes, bytecodeExceptionNodes, expectedExceptionNode, graph);
                }
            } else {
                graph.getDebug().log(5, "Node %s does not flow to the corresponding Unwind. Bailing out.", (Object)n);
            }
        } else if (n instanceof MergeNode) {
            MergeNode merge = (MergeNode)n;
            if (merge.isPhiAtMerge((Node)expectedExceptionNode)) {
                PhiNode expectedExceptionForInput = (PhiNode)expectedExceptionNode;
                for (int input = 0; input < merge.forwardEndCount(); ++input) {
                    EndNode predecessor = merge.forwardEndAt(input);
                    RemoveUnwindPhase.walkBack((Node)predecessor, (Node)merge, withExceptionNodes, bytecodeExceptionNodes, GraphUtil.unproxify((ValueNode)expectedExceptionForInput.valueAt(input)), graph);
                }
            } else {
                for (ValueNode predecessor : merge.cfgPredecessors()) {
                    RemoveUnwindPhase.walkBack((Node)predecessor, (Node)merge, withExceptionNodes, bytecodeExceptionNodes, expectedExceptionNode, graph);
                }
            }
        } else if (n instanceof AbstractBeginNode || n instanceof AbstractEndNode) {
            RemoveUnwindPhase.walkBack(n.predecessor(), n, withExceptionNodes, bytecodeExceptionNodes, expectedExceptionNode, graph);
        }
    }

    private static void convertToThrow(BytecodeExceptionNode bytecodeExceptionNode) {
        StructuredGraph graph = bytecodeExceptionNode.graph();
        ThrowBytecodeExceptionNode throwNode = (ThrowBytecodeExceptionNode)graph.add((Node)new ThrowBytecodeExceptionNode(bytecodeExceptionNode.getExceptionKind(), (List<ValueNode>)bytecodeExceptionNode.getArguments()));
        throwNode.setStateBefore(bytecodeExceptionNode.createStateDuring());
        throwNode.setNodeSourcePosition(bytecodeExceptionNode.getNodeSourcePosition());
        FixedWithNextNode predecessor = (FixedWithNextNode)bytecodeExceptionNode.predecessor();
        GraphUtil.killCFG((FixedNode)bytecodeExceptionNode);
        assert (predecessor.next() == null) : "must be killed now";
        predecessor.setNext((FixedNode)throwNode);
    }
}

