/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge.graal;

import com.oracle.svm.core.genscavenge.ObjectHeaderImpl;
import com.oracle.svm.core.genscavenge.graal.nodes.FormatArrayNode;
import com.oracle.svm.core.genscavenge.graal.nodes.FormatObjectNode;
import com.oracle.svm.core.genscavenge.graal.nodes.FormatPodNode;
import com.oracle.svm.core.genscavenge.graal.nodes.FormatStoredContinuationNode;
import com.oracle.svm.core.graal.snippets.NodeLoweringProvider;
import com.oracle.svm.core.graal.snippets.SubstrateAllocationSnippets;
import com.oracle.svm.core.graal.snippets.SubstrateTemplates;
import com.oracle.svm.core.heap.Pod;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.hub.LayoutEncoding;
import com.oracle.svm.core.thread.ContinuationSupport;
import java.util.Map;
import jdk.graal.compiler.api.replacements.Fold;
import jdk.graal.compiler.api.replacements.Snippet;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.nodes.FixedNode;
import jdk.graal.compiler.nodes.GraphState;
import jdk.graal.compiler.nodes.NamedLocationIdentity;
import jdk.graal.compiler.nodes.PiNode;
import jdk.graal.compiler.nodes.SnippetAnchorNode;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.extended.GuardingNode;
import jdk.graal.compiler.nodes.spi.CoreProviders;
import jdk.graal.compiler.nodes.spi.LoweringTool;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.phases.util.Providers;
import jdk.graal.compiler.replacements.AllocationSnippets;
import jdk.graal.compiler.replacements.SnippetTemplate;
import jdk.graal.compiler.replacements.Snippets;
import jdk.graal.compiler.word.Word;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.word.LocationIdentity;
import org.graalvm.word.UnsignedWord;

public final class GenScavengeAllocationSnippets
implements Snippets {
    @Snippet
    public static Object formatObjectSnippet(Word memory, DynamicHub hub, boolean rememberedSet, AllocationSnippets.FillContent fillContents, boolean emitMemoryBarrier, @Snippet.ConstantParameter AllocationSnippets.AllocationSnippetCounters snippetCounters) {
        DynamicHub hubNonNull = (DynamicHub)PiNode.piCastNonNull((Object)hub, (GuardingNode)SnippetAnchorNode.anchor());
        int layoutEncoding = hubNonNull.getLayoutEncoding();
        UnsignedWord size = LayoutEncoding.getPureInstanceAllocationSize(layoutEncoding);
        Word objectHeader = GenScavengeAllocationSnippets.encodeAsObjectHeader(hubNonNull, rememberedSet, false);
        return GenScavengeAllocationSnippets.alloc().formatObject(objectHeader, size, memory, fillContents, emitMemoryBarrier, false, snippetCounters);
    }

    @Snippet
    public static Object formatArraySnippet(Word memory, DynamicHub hub, int length, boolean rememberedSet, boolean unaligned, AllocationSnippets.FillContent fillContents, boolean emitMemoryBarrier, @Snippet.ConstantParameter boolean supportsBulkZeroing, @Snippet.ConstantParameter boolean supportsOptimizedFilling, @Snippet.ConstantParameter AllocationSnippets.AllocationSnippetCounters snippetCounters) {
        DynamicHub hubNonNull = (DynamicHub)PiNode.piCastNonNull((Object)hub, (GuardingNode)SnippetAnchorNode.anchor());
        int layoutEncoding = hubNonNull.getLayoutEncoding();
        UnsignedWord size = LayoutEncoding.getArrayAllocationSize(layoutEncoding, length);
        Word objectHeader = GenScavengeAllocationSnippets.encodeAsObjectHeader(hubNonNull, rememberedSet, unaligned);
        return GenScavengeAllocationSnippets.alloc().formatArray(objectHeader, size, length, memory, fillContents, emitMemoryBarrier, false, supportsBulkZeroing, supportsOptimizedFilling, snippetCounters);
    }

    @Snippet
    public static Object formatStoredContinuation(Word memory, DynamicHub hub, int length, boolean rememberedSet, boolean unaligned, @Snippet.ConstantParameter long ipOffset, @Snippet.ConstantParameter boolean emitMemoryBarrier, @Snippet.ConstantParameter AllocationSnippets.AllocationSnippetCounters snippetCounters) {
        DynamicHub hubNonNull = (DynamicHub)PiNode.piCastNonNull((Object)hub, (GuardingNode)SnippetAnchorNode.anchor());
        int layoutEncoding = hubNonNull.getLayoutEncoding();
        UnsignedWord size = LayoutEncoding.getArrayAllocationSize(layoutEncoding, length);
        Word objectHeader = GenScavengeAllocationSnippets.encodeAsObjectHeader(hubNonNull, rememberedSet, unaligned);
        return GenScavengeAllocationSnippets.alloc().formatStoredContinuation(objectHeader, size, length, memory, emitMemoryBarrier, ipOffset, snippetCounters);
    }

    @Snippet
    public static Object formatPodSnippet(Word memory, DynamicHub hub, int arrayLength, byte[] referenceMap, boolean rememberedSet, boolean unaligned, AllocationSnippets.FillContent fillContents, @Snippet.ConstantParameter boolean emitMemoryBarrier, @Snippet.ConstantParameter boolean supportsBulkZeroing, @Snippet.ConstantParameter boolean supportsOptimizedFilling, @Snippet.ConstantParameter AllocationSnippets.AllocationSnippetCounters snippetCounters) {
        DynamicHub hubNonNull = (DynamicHub)PiNode.piCastNonNull((Object)hub, (GuardingNode)SnippetAnchorNode.anchor());
        byte[] refMapNonNull = (byte[])PiNode.piCastNonNull((Object)referenceMap, (GuardingNode)SnippetAnchorNode.anchor());
        Word objectHeader = GenScavengeAllocationSnippets.encodeAsObjectHeader(hubNonNull, rememberedSet, unaligned);
        int layoutEncoding = hubNonNull.getLayoutEncoding();
        UnsignedWord allocationSize = LayoutEncoding.getArrayAllocationSize(layoutEncoding, arrayLength);
        return GenScavengeAllocationSnippets.alloc().formatPod(objectHeader, hubNonNull, allocationSize, arrayLength, refMapNonNull, memory, fillContents, emitMemoryBarrier, false, supportsBulkZeroing, supportsOptimizedFilling, snippetCounters);
    }

    private static Word encodeAsObjectHeader(DynamicHub hub, boolean rememberedSet, boolean unaligned) {
        return ObjectHeaderImpl.getObjectHeaderImpl().encodeAsObjectHeader(hub, rememberedSet, unaligned);
    }

    @Fold
    static SubstrateAllocationSnippets alloc() {
        return (SubstrateAllocationSnippets)((Object)ImageSingletons.lookup(SubstrateAllocationSnippets.class));
    }

    public static class Templates
    extends SubstrateTemplates {
        private final SubstrateAllocationSnippets.Templates baseTemplates;
        private final SnippetTemplate.SnippetInfo formatObject;
        private final SnippetTemplate.SnippetInfo formatArray;
        private final SnippetTemplate.SnippetInfo formatStoredContinuation;
        private final SnippetTemplate.SnippetInfo formatPod;

        public Templates(OptionValues options, Providers providers, SubstrateAllocationSnippets.Templates baseTemplates) {
            super(options, providers);
            this.baseTemplates = baseTemplates;
            this.formatObject = this.snippet(providers, GenScavengeAllocationSnippets.class, "formatObjectSnippet", new LocationIdentity[0]);
            this.formatArray = this.snippet(providers, GenScavengeAllocationSnippets.class, "formatArraySnippet", new LocationIdentity[0]);
            this.formatStoredContinuation = ContinuationSupport.isSupported() ? this.snippet(providers, GenScavengeAllocationSnippets.class, "formatStoredContinuation", new LocationIdentity[0]) : null;
            this.formatPod = Pod.RuntimeSupport.isPresent() ? this.snippet(providers, GenScavengeAllocationSnippets.class, "formatPodSnippet", new LocationIdentity[]{NamedLocationIdentity.getArrayLocation((JavaKind)JavaKind.Byte)}) : null;
        }

        public void registerLowering(Map<Class<? extends Node>, NodeLoweringProvider<?>> lowerings) {
            lowerings.put(FormatObjectNode.class, new FormatObjectLowering());
            lowerings.put(FormatArrayNode.class, new FormatArrayLowering());
            if (ContinuationSupport.isSupported()) {
                lowerings.put(FormatStoredContinuationNode.class, new FormatStoredContinuationLowering());
            }
            if (Pod.RuntimeSupport.isPresent()) {
                lowerings.put(FormatPodNode.class, new FormatPodLowering());
            }
        }

        private class FormatObjectLowering
        implements NodeLoweringProvider<FormatObjectNode> {
            private FormatObjectLowering() {
            }

            @Override
            public void lower(FormatObjectNode node, LoweringTool tool) {
                StructuredGraph graph = node.graph();
                if (graph.getGuardsStage() != GraphState.GuardsStage.AFTER_FSA) {
                    return;
                }
                SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(Templates.this.formatObject, graph.getGuardsStage(), tool.getLoweringStage());
                args.add("memory", (Object)node.getMemory());
                args.add("hub", (Object)node.getHub());
                args.add("rememberedSet", (Object)node.getRememberedSet());
                args.add("fillContents", (Object)node.getFillContents());
                args.add("emitMemoryBarrier", (Object)node.getEmitMemoryBarrier());
                args.addConst("snippetCounters", (Object)Templates.this.baseTemplates.getSnippetCounters());
                Templates.this.template((CoreProviders)tool, (ValueNode)node, args).instantiate(tool.getMetaAccess(), (FixedNode)node, SnippetTemplate.DEFAULT_REPLACER, args);
            }
        }

        private class FormatArrayLowering
        implements NodeLoweringProvider<FormatArrayNode> {
            private FormatArrayLowering() {
            }

            @Override
            public void lower(FormatArrayNode node, LoweringTool tool) {
                StructuredGraph graph = node.graph();
                if (graph.getGuardsStage() != GraphState.GuardsStage.AFTER_FSA) {
                    return;
                }
                SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(Templates.this.formatArray, graph.getGuardsStage(), tool.getLoweringStage());
                args.add("memory", (Object)node.getMemory());
                args.add("hub", (Object)node.getHub());
                args.add("length", (Object)node.getLength());
                args.add("rememberedSet", (Object)node.getRememberedSet());
                args.add("unaligned", (Object)node.getUnaligned());
                args.add("fillContents", (Object)node.getFillContents());
                args.add("emitMemoryBarrier", (Object)node.getEmitMemoryBarrier());
                args.addConst("supportsBulkZeroing", (Object)tool.getLowerer().supportsBulkZeroing());
                args.addConst("supportsOptimizedFilling", (Object)tool.getLowerer().supportsOptimizedFilling(graph.getOptions()));
                args.addConst("snippetCounters", (Object)Templates.this.baseTemplates.getSnippetCounters());
                Templates.this.template((CoreProviders)tool, (ValueNode)node, args).instantiate(tool.getMetaAccess(), (FixedNode)node, SnippetTemplate.DEFAULT_REPLACER, args);
            }
        }

        private class FormatStoredContinuationLowering
        implements NodeLoweringProvider<FormatStoredContinuationNode> {
            private FormatStoredContinuationLowering() {
            }

            @Override
            public void lower(FormatStoredContinuationNode node, LoweringTool tool) {
                StructuredGraph graph = node.graph();
                if (graph.getGuardsStage() != GraphState.GuardsStage.AFTER_FSA) {
                    return;
                }
                SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(Templates.this.formatStoredContinuation, graph.getGuardsStage(), tool.getLoweringStage());
                args.add("memory", (Object)node.getMemory());
                args.add("hub", (Object)node.getHub());
                args.add("length", (Object)node.getLength());
                args.add("rememberedSet", (Object)node.getRememberedSet());
                args.add("unaligned", (Object)node.getUnaligned());
                args.addConst("ipOffset", (Object)ContinuationSupport.singleton().getIPOffset());
                args.addConst("emitMemoryBarrier", (Object)node.getEmitMemoryBarrier());
                args.addConst("snippetCounters", (Object)Templates.this.baseTemplates.getSnippetCounters());
                Templates.this.template((CoreProviders)tool, (ValueNode)node, args).instantiate(tool.getMetaAccess(), (FixedNode)node, SnippetTemplate.DEFAULT_REPLACER, args);
            }
        }

        private class FormatPodLowering
        implements NodeLoweringProvider<FormatPodNode> {
            private FormatPodLowering() {
            }

            @Override
            public void lower(FormatPodNode node, LoweringTool tool) {
                StructuredGraph graph = node.graph();
                if (graph.getGuardsStage() != GraphState.GuardsStage.AFTER_FSA) {
                    return;
                }
                SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(Templates.this.formatPod, graph.getGuardsStage(), tool.getLoweringStage());
                args.add("memory", (Object)node.getMemory());
                args.add("hub", (Object)node.getHub());
                args.add("arrayLength", (Object)node.getArrayLength());
                args.add("referenceMap", (Object)node.getReferenceMap());
                args.add("rememberedSet", (Object)node.getRememberedSet());
                args.add("unaligned", (Object)node.getUnaligned());
                args.add("fillContents", (Object)node.getFillContents());
                args.addConst("emitMemoryBarrier", (Object)node.getEmitMemoryBarrier());
                args.addConst("supportsBulkZeroing", (Object)tool.getLowerer().supportsBulkZeroing());
                args.addConst("supportsOptimizedFilling", (Object)tool.getLowerer().supportsOptimizedFilling(graph.getOptions()));
                args.addConst("snippetCounters", (Object)Templates.this.baseTemplates.getSnippetCounters());
                Templates.this.template((CoreProviders)tool, (ValueNode)node, args).instantiate(tool.getMetaAccess(), (FixedNode)node, SnippetTemplate.DEFAULT_REPLACER, args);
            }
        }
    }
}

