/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.SubstrateGCOptions;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.genscavenge.GCImpl;
import com.oracle.svm.core.genscavenge.HeapImpl;
import com.oracle.svm.core.genscavenge.UseSerialOrEpsilonGC;
import com.oracle.svm.core.heap.GCCause;
import com.oracle.svm.core.heap.PhysicalMemory;
import com.oracle.svm.core.jfr.JfrTicks;
import com.oracle.svm.core.jfr.events.SystemGCEvent;

@TargetClass(value=Runtime.class, onlyWith={UseSerialOrEpsilonGC.class})
final class Target_java_lang_Runtime {
    Target_java_lang_Runtime() {
    }

    @Substitute
    private long freeMemory() {
        return this.maxMemory() - HeapImpl.getAccounting().getUsedBytes().rawValue();
    }

    @Substitute
    private long totalMemory() {
        return this.maxMemory();
    }

    @Substitute
    private long maxMemory() {
        PhysicalMemory.size();
        GCImpl.getPolicy().updateSizeParameters();
        return GCImpl.getPolicy().getMaximumHeapSize().rawValue();
    }

    @Substitute
    private void gc() {
        if (!SubstrateGCOptions.DisableExplicitGC.getValue().booleanValue()) {
            long startTicks = JfrTicks.elapsedTicks();
            GCImpl.getGCImpl().collectCompletely(GCCause.JavaLangSystemGC);
            SystemGCEvent.emit(startTicks, false);
        }
    }
}

