/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.genscavenge.AbstractCollectionPolicy;
import com.oracle.svm.core.genscavenge.AdaptiveCollectionPolicy;
import com.oracle.svm.core.genscavenge.BasicCollectionPolicies;
import com.oracle.svm.core.genscavenge.LibGraalCollectionPolicy;
import com.oracle.svm.core.genscavenge.ProportionateSpacesPolicy;
import com.oracle.svm.core.genscavenge.SerialGCOptions;
import com.oracle.svm.core.heap.GCCause;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.util.ReflectionUtil;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

public interface CollectionPolicy {
    public static final UnsignedWord UNDEFINED = WordFactory.unsigned((int)-1);

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static String getInitialPolicyName() {
        String legacyPrefix;
        if (SubstrateOptions.UseEpsilonGC.getValue().booleanValue()) {
            return "NeverCollect";
        }
        if (!SubstrateOptions.useRememberedSet()) {
            return "OnlyCompletely";
        }
        String name = SerialGCOptions.InitialCollectionPolicy.getValue();
        if (name.startsWith(legacyPrefix = "com.oracle.svm.core.genscavenge.CollectionPolicy$")) {
            return name.substring(legacyPrefix.length());
        }
        return name;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static CollectionPolicy getInitialPolicy() {
        String name = CollectionPolicy.getInitialPolicyName();
        Class<? extends CollectionPolicy> clazz = CollectionPolicy.getPolicyClass(name);
        return (CollectionPolicy)ReflectionUtil.newInstance(clazz);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static Class<? extends CollectionPolicy> getPolicyClass(String name) {
        switch (name) {
            case "Adaptive": {
                return AdaptiveCollectionPolicy.class;
            }
            case "LibGraal": {
                return LibGraalCollectionPolicy.class;
            }
            case "Proportionate": {
                return ProportionateSpacesPolicy.class;
            }
            case "BySpaceAndTime": {
                return BasicCollectionPolicies.BySpaceAndTime.class;
            }
            case "OnlyCompletely": {
                return BasicCollectionPolicies.OnlyCompletely.class;
            }
            case "OnlyIncrementally": {
                return BasicCollectionPolicies.OnlyIncrementally.class;
            }
            case "NeverCollect": {
                return BasicCollectionPolicies.NeverCollect.class;
            }
        }
        throw UserError.abort("Policy %s does not exist.", name);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static int getMaxSurvivorSpaces(Integer userValue) {
        String name = CollectionPolicy.getInitialPolicyName();
        if (BasicCollectionPolicies.BasicPolicy.class.isAssignableFrom(CollectionPolicy.getPolicyClass(name))) {
            return BasicCollectionPolicies.getMaxSurvivorSpaces(userValue);
        }
        return AbstractCollectionPolicy.getMaxSurvivorSpaces(userValue);
    }

    public static boolean shouldCollectYoungGenSeparately(boolean defaultValue) {
        Boolean optionValue = SerialGCOptions.CollectYoungGenerationSeparately.getValue();
        return optionValue != null ? optionValue : defaultValue;
    }

    public String getName();

    public void ensureSizeParametersInitialized();

    public void updateSizeParameters();

    public boolean shouldCollectOnAllocation();

    public boolean shouldCollectOnHint(boolean var1);

    public boolean shouldCollectCompletely(boolean var1);

    public UnsignedWord getCurrentHeapCapacity();

    public UnsignedWord getInitialEdenSize();

    public UnsignedWord getMaximumEdenSize();

    public UnsignedWord getMaximumHeapSize();

    public UnsignedWord getMaximumYoungGenerationSize();

    public UnsignedWord getMinimumHeapSize();

    public UnsignedWord getInitialSurvivorSize();

    public UnsignedWord getMaximumSurvivorSize();

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public UnsignedWord getSurvivorSpacesCapacity();

    public UnsignedWord getYoungGenerationCapacity();

    public UnsignedWord getInitialOldSize();

    public UnsignedWord getOldGenerationCapacity();

    public UnsignedWord getMaximumOldSize();

    public UnsignedWord getMaximumFreeAlignedChunksSize();

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public int getTenuringAge();

    public void onCollectionBegin(boolean var1, long var2);

    public void onCollectionEnd(boolean var1, GCCause var2);
}

