/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.fieldvaluetransformer;

import com.oracle.svm.core.util.VMError;

abstract class BoxingTransformer {
    private final Class<?> returnType;

    BoxingTransformer(Class<?> returnType) {
        this.returnType = returnType;
    }

    Object box(int value) {
        if (this.returnType == Integer.TYPE || this.returnType == Integer.class) {
            return value;
        }
        if (this.returnType == Long.TYPE || this.returnType == Long.class) {
            return (long)value;
        }
        throw VMError.shouldNotReachHere("Unexpected type: " + String.valueOf(this.returnType));
    }
}

