/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.cpufeature;

import com.oracle.svm.core.CPUFeatureAccess;
import com.oracle.svm.core.SubstrateTargetDescription;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.cpufeature.RuntimeCPUFeatureCheck;
import com.oracle.svm.core.feature.AutomaticallyRegisteredImageSingleton;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Set;
import jdk.graal.compiler.api.replacements.Fold;
import jdk.graal.compiler.api.replacements.SnippetReflectionProvider;
import jdk.graal.compiler.core.common.NumUtil;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.LogicNode;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.calc.ConditionalNode;
import jdk.graal.compiler.nodes.calc.IntegerTestNode;
import jdk.graal.compiler.nodes.extended.BranchProbabilityNode;
import jdk.graal.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import jdk.graal.compiler.nodes.java.LoadFieldNode;
import jdk.vm.ci.aarch64.AArch64;
import jdk.vm.ci.amd64.AMD64;
import jdk.vm.ci.code.Architecture;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.riscv64.RISCV64;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

@AutomaticallyRegisteredImageSingleton
@Node.NodeIntrinsicFactory
public final class RuntimeCPUFeatureCheckImpl {
    private int cpuFeatureMask;
    private final byte[] enumToBitIndex;

    public static RuntimeCPUFeatureCheckImpl instance() {
        return (RuntimeCPUFeatureCheckImpl)ImageSingletons.lookup(RuntimeCPUFeatureCheckImpl.class);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    RuntimeCPUFeatureCheckImpl() {
        Architecture arch = ConfigurationValues.getTarget().arch;
        Set<Enum<?>> supportedFeatures = RuntimeCPUFeatureCheck.getSupportedFeatures(arch);
        int size = supportedFeatures.size();
        if (size == 0) {
            this.enumToBitIndex = null;
        } else {
            GraalError.guarantee((size <= 8 ? 1 : 0) != 0, (String)"Cannot encode %s features in 8 bit", (Object)size);
            ArrayList<Byte> enumToBitIndexMap = new ArrayList<Byte>();
            int index = 0;
            Class<?> clazz = null;
            for (Enum<?> feature : supportedFeatures) {
                if (clazz == null) {
                    clazz = feature.getClass();
                } else {
                    GraalError.guarantee((boolean)clazz.equals(feature.getClass()), (String)"Incompatible classes %s vs. %s", clazz, feature.getClass());
                }
                int ordinal = feature.ordinal();
                enumToBitIndexMap.ensureCapacity(ordinal);
                while (enumToBitIndexMap.size() < ordinal) {
                    enumToBitIndexMap.add((byte)-1);
                }
                enumToBitIndexMap.add(ordinal, NumUtil.safeToByte((int)index));
                ++index;
            }
            assert (index == supportedFeatures.size()) : index;
            this.enumToBitIndex = new byte[enumToBitIndexMap.size()];
            for (int i = 0; i < enumToBitIndexMap.size(); ++i) {
                this.enumToBitIndex[i] = (Byte)enumToBitIndexMap.get(i);
            }
        }
        this.reinitialize();
    }

    void reinitialize() {
        this.cpuFeatureMask = this.compute();
    }

    private int compute() {
        if (!SubstrateUtil.HOSTED) {
            CPUFeatureAccess cpuFeatureAccess = (CPUFeatureAccess)ImageSingletons.lookup(CPUFeatureAccess.class);
            GraalError.guarantee((cpuFeatureAccess != null ? 1 : 0) != 0, (String)"No %s singleton", (Object)CPUFeatureAccess.class.getSimpleName());
            EnumSet<?> features = cpuFeatureAccess.determineHostCPUFeatures();
            return ~this.computeFeatureMaskInternal(features);
        }
        return ~this.computeFeatureMask(RuntimeCPUFeatureCheckImpl.getStaticFeatures());
    }

    @Fold
    public <T extends Enum<T>> int computeFeatureMask(EnumSet<T> features) {
        return this.computeFeatureMaskInternal(features);
    }

    private <T extends Enum<T>> int computeFeatureMaskInternal(EnumSet<T> features) {
        int mask = 0;
        for (Enum feature : features) {
            if (!this.enabledForRuntimeFeatureCheck(feature)) continue;
            mask |= 1 << this.getEncoding(feature);
        }
        return mask;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    private static void putRaw(EnumMap enumToInt, int index, Enum feature) {
        enumToInt.put(feature, index);
    }

    private boolean enabledForRuntimeFeatureCheck(Enum<?> feature) {
        return this.enumToBitIndex != null && this.getEncodingUnchecked(feature) >= 0;
    }

    private byte getEncodingUnchecked(Enum<?> feature) {
        return feature.ordinal() < this.enumToBitIndex.length ? this.enumToBitIndex[feature.ordinal()] : (byte)-1;
    }

    private int getEncoding(Enum<?> feature) {
        if (SubstrateUtil.HOSTED) {
            GraalError.guarantee((this.enumToBitIndex != null ? 1 : 0) != 0, (String)"No features registered for run time feature check for platform %s", (Object)ConfigurationValues.getTarget().arch);
        }
        byte code = this.getEncodingUnchecked(feature);
        if (SubstrateUtil.HOSTED) {
            GraalError.guarantee((code >= 0 ? 1 : 0) != 0, (String)"Feature %s no registered for run time feature check", feature);
        }
        return code;
    }

    private static EnumSet<?> toEnumSet(Enum first, Enum ... rest) {
        return EnumSet.of(first, rest);
    }

    public static boolean intrinsify(GraphBuilderContext b, @Node.InjectedNodeParameter SnippetReflectionProvider snippetReflection, Enum<?> first, Enum<?> ... rest) {
        return RuntimeCPUFeatureCheckImpl.buildRuntimeCPUFeatureCheck(b, snippetReflection, RuntimeCPUFeatureCheckImpl.toEnumSet(first, rest));
    }

    private static boolean buildRuntimeCPUFeatureCheck(GraphBuilderContext b, SnippetReflectionProvider snippetReflection, EnumSet<?> allFeatures) {
        EnumSet<?> features = RuntimeCPUFeatureCheckImpl.removeStaticFeatures(allFeatures);
        if (features.isEmpty()) {
            b.addPush(JavaKind.Boolean, (ValueNode)ConstantNode.forBoolean((boolean)true));
        } else if (!RuntimeCPUFeatureCheckImpl.shouldCreateRuntimeFeatureCheck(features)) {
            b.addPush(JavaKind.Boolean, (ValueNode)ConstantNode.forBoolean((boolean)false));
        } else {
            MetaAccessProvider metaAccess = b.getMetaAccess();
            ResolvedJavaField field = RuntimeCPUFeatureCheckImpl.getMaskField(metaAccess);
            ConstantNode object = (ConstantNode)b.add((Node)ConstantNode.forConstant((JavaConstant)snippetReflection.forObject((Object)RuntimeCPUFeatureCheckImpl.instance()), (MetaAccessProvider)metaAccess));
            ValueNode featureMask = (ValueNode)b.add((Node)LoadFieldNode.create(null, (ValueNode)object, (ResolvedJavaField)field));
            int mask = RuntimeCPUFeatureCheckImpl.instance().computeFeatureMask(features);
            GraalError.guarantee((boolean)JavaKind.Int.equals((Object)field.getType().getJavaKind()), (String)"Expected field to be an int");
            LogicNode featureBitIsZero = (LogicNode)b.add((Node)IntegerTestNode.create((ValueNode)featureMask, (ValueNode)ConstantNode.forInt((int)mask), (NodeView)NodeView.DEFAULT));
            ValueNode condition = (ValueNode)b.add((Node)ConditionalNode.create((LogicNode)featureBitIsZero, (ValueNode)ConstantNode.forBoolean((boolean)true), (ValueNode)ConstantNode.forBoolean((boolean)false), (NodeView)NodeView.DEFAULT));
            b.addPush(JavaKind.Boolean, (ValueNode)new BranchProbabilityNode((ValueNode)ConstantNode.forDouble((double)0.6), condition));
        }
        return true;
    }

    public static Field getMaskField() {
        return ReflectionUtil.lookupField(RuntimeCPUFeatureCheckImpl.class, (String)"cpuFeatureMask");
    }

    public static ResolvedJavaField getMaskField(MetaAccessProvider metaAccess) {
        return metaAccess.lookupJavaField(RuntimeCPUFeatureCheckImpl.getMaskField());
    }

    @Fold
    public static EnumSet<?> removeStaticFeatures(EnumSet<?> features) {
        EnumSet<?> copy = EnumSet.copyOf(features);
        EnumSet<?> featuresToBeRemoved = RuntimeCPUFeatureCheckImpl.getStaticFeatures();
        copy.removeAll(featuresToBeRemoved);
        return copy;
    }

    @Fold
    public static boolean shouldCreateRuntimeFeatureCheck(EnumSet<?> features) {
        SubstrateTargetDescription target = ConfigurationValues.getTarget();
        return RuntimeCPUFeatureCheckImpl.containsAll(target.getRuntimeCheckedCPUFeatures(), features) && RuntimeCPUFeatureCheckImpl.containsAll(RuntimeCPUFeatureCheck.getSupportedFeatures(target.arch), features);
    }

    private static boolean containsAll(Set features, EnumSet feature) {
        return features.containsAll(feature);
    }

    @Fold
    static EnumSet<?> getStaticFeatures() {
        Architecture arch = ConfigurationValues.getTarget().arch;
        if (arch instanceof AMD64) {
            return ((AMD64)arch).getFeatures();
        }
        if (arch instanceof AArch64) {
            return ((AArch64)arch).getFeatures();
        }
        if (arch instanceof RISCV64) {
            return ((RISCV64)arch).getFeatures();
        }
        throw GraalError.shouldNotReachHere((String)"unsupported architecture");
    }
}

