/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.configure;

import com.oracle.svm.core.TypeResult;
import com.oracle.svm.core.configure.ConfigurationParser;
import com.oracle.svm.core.configure.ReflectionConfigurationParserDelegate;
import com.oracle.svm.util.LogUtils;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import jdk.graal.compiler.util.json.JSONParserException;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.MapCursor;
import org.graalvm.nativeimage.impl.ConfigurationCondition;

public final class ReflectionConfigurationParser<T>
extends ConfigurationParser {
    private static final String CONSTRUCTOR_NAME = "<init>";
    private final ReflectionConfigurationParserDelegate<T> delegate;
    private static final List<String> OPTIONAL_REFLECT_CONFIG_OBJECT_ATTRS = Arrays.asList("allDeclaredConstructors", "allPublicConstructors", "allDeclaredMethods", "allPublicMethods", "allDeclaredFields", "allPublicFields", "allDeclaredClasses", "allRecordComponents", "allPermittedSubclasses", "allNestMembers", "allSigners", "allPublicClasses", "methods", "queriedMethods", "fields", "condition", "queryAllDeclaredConstructors", "queryAllPublicConstructors", "queryAllDeclaredMethods", "queryAllPublicMethods", "unsafeAllocated");
    private final boolean printMissingElements;

    public ReflectionConfigurationParser(ReflectionConfigurationParserDelegate<T> delegate) {
        this(delegate, true, false);
    }

    public ReflectionConfigurationParser(ReflectionConfigurationParserDelegate<T> delegate, boolean strictConfiguration, boolean printMissingElements) {
        super(strictConfiguration);
        this.printMissingElements = printMissingElements;
        this.delegate = delegate;
    }

    @Override
    public void parseAndRegister(Object json, URI origin) {
        this.parseClassArray(ReflectionConfigurationParser.asList(json, "first level of document must be an array of class descriptors"));
    }

    private void parseClassArray(List<Object> classes) {
        for (Object clazz : classes) {
            this.parseClass(ReflectionConfigurationParser.asMap(clazz, "second level of document must be class descriptor objects"));
        }
    }

    private void parseClass(EconomicMap<String, Object> data) {
        this.checkAttributes(data, "reflection class descriptor object", Collections.singleton("name"), OPTIONAL_REFLECT_CONFIG_OBJECT_ATTRS);
        Object classObject = data.get((Object)"name");
        String className = ReflectionConfigurationParser.asString(classObject, "name");
        TypeResult<ConfigurationCondition> conditionResult = this.delegate.resolveCondition(this.parseCondition(data).getTypeName());
        if (!conditionResult.isPresent()) {
            return;
        }
        ConfigurationCondition condition = conditionResult.get();
        TypeResult<T> result = this.delegate.resolveType(condition, className, true);
        if (!result.isPresent()) {
            this.handleMissingElement("Could not resolve class " + className + " for reflection configuration.", result.getException());
            return;
        }
        T clazz = result.get();
        this.delegate.registerType(clazz);
        MapCursor cursor = data.getEntries();
        while (cursor.advance()) {
            String name = (String)cursor.getKey();
            Object value = cursor.getValue();
            try {
                switch (name) {
                    case "allDeclaredConstructors": {
                        if (!ReflectionConfigurationParser.asBoolean(value, "allDeclaredConstructors")) break;
                        this.delegate.registerDeclaredConstructors(false, clazz);
                        break;
                    }
                    case "allPublicConstructors": {
                        if (!ReflectionConfigurationParser.asBoolean(value, "allPublicConstructors")) break;
                        this.delegate.registerPublicConstructors(false, clazz);
                        break;
                    }
                    case "allDeclaredMethods": {
                        if (!ReflectionConfigurationParser.asBoolean(value, "allDeclaredMethods")) break;
                        this.delegate.registerDeclaredMethods(false, clazz);
                        break;
                    }
                    case "allPublicMethods": {
                        if (!ReflectionConfigurationParser.asBoolean(value, "allPublicMethods")) break;
                        this.delegate.registerPublicMethods(false, clazz);
                        break;
                    }
                    case "allDeclaredFields": {
                        if (!ReflectionConfigurationParser.asBoolean(value, "allDeclaredFields")) break;
                        this.delegate.registerDeclaredFields(clazz);
                        break;
                    }
                    case "allPublicFields": {
                        if (!ReflectionConfigurationParser.asBoolean(value, "allPublicFields")) break;
                        this.delegate.registerPublicFields(clazz);
                        break;
                    }
                    case "allDeclaredClasses": {
                        if (!ReflectionConfigurationParser.asBoolean(value, "allDeclaredClasses")) break;
                        this.delegate.registerDeclaredClasses(clazz);
                        break;
                    }
                    case "allRecordComponents": {
                        if (!ReflectionConfigurationParser.asBoolean(value, "allRecordComponents")) break;
                        this.delegate.registerRecordComponents(clazz);
                        break;
                    }
                    case "allPermittedSubclasses": {
                        if (!ReflectionConfigurationParser.asBoolean(value, "allPermittedSubclasses")) break;
                        this.delegate.registerPermittedSubclasses(clazz);
                        break;
                    }
                    case "allNestMembers": {
                        if (!ReflectionConfigurationParser.asBoolean(value, "allNestMembers")) break;
                        this.delegate.registerNestMembers(clazz);
                        break;
                    }
                    case "allSigners": {
                        if (!ReflectionConfigurationParser.asBoolean(value, "allSigners")) break;
                        this.delegate.registerSigners(clazz);
                        break;
                    }
                    case "allPublicClasses": {
                        if (!ReflectionConfigurationParser.asBoolean(value, "allPublicClasses")) break;
                        this.delegate.registerPublicClasses(clazz);
                        break;
                    }
                    case "queryAllDeclaredConstructors": {
                        if (!ReflectionConfigurationParser.asBoolean(value, "queryAllDeclaredConstructors")) break;
                        this.delegate.registerDeclaredConstructors(true, clazz);
                        break;
                    }
                    case "queryAllPublicConstructors": {
                        if (!ReflectionConfigurationParser.asBoolean(value, "queryAllPublicConstructors")) break;
                        this.delegate.registerPublicConstructors(true, clazz);
                        break;
                    }
                    case "queryAllDeclaredMethods": {
                        if (!ReflectionConfigurationParser.asBoolean(value, "queryAllDeclaredMethods")) break;
                        this.delegate.registerDeclaredMethods(true, clazz);
                        break;
                    }
                    case "queryAllPublicMethods": {
                        if (!ReflectionConfigurationParser.asBoolean(value, "queryAllPublicMethods")) break;
                        this.delegate.registerPublicMethods(true, clazz);
                        break;
                    }
                    case "unsafeAllocated": {
                        if (!ReflectionConfigurationParser.asBoolean(value, "unsafeAllocated")) break;
                        this.delegate.registerUnsafeAllocated(clazz);
                        break;
                    }
                    case "methods": {
                        this.parseMethods(false, ReflectionConfigurationParser.asList(value, "Attribute 'methods' must be an array of method descriptors"), clazz);
                        break;
                    }
                    case "queriedMethods": {
                        this.parseMethods(true, ReflectionConfigurationParser.asList(value, "Attribute 'queriedMethods' must be an array of method descriptors"), clazz);
                        break;
                    }
                    case "fields": {
                        this.parseFields(ReflectionConfigurationParser.asList(value, "Attribute 'fields' must be an array of field descriptors"), clazz);
                    }
                }
            }
            catch (LinkageError e) {
                this.handleMissingElement("Could not register " + this.delegate.getTypeName(clazz) + ": " + name + " for reflection.", e);
            }
        }
    }

    private void parseFields(List<Object> fields, T clazz) {
        for (Object field : fields) {
            this.parseField(ReflectionConfigurationParser.asMap(field, "Elements of 'fields' array must be field descriptor objects"), clazz);
        }
    }

    private void parseField(EconomicMap<String, Object> data, T clazz) {
        this.checkAttributes(data, "reflection field descriptor object", Collections.singleton("name"), Arrays.asList("allowWrite", "allowUnsafeAccess"));
        String fieldName = ReflectionConfigurationParser.asString(data.get((Object)"name"), "name");
        boolean allowWrite = data.containsKey((Object)"allowWrite") && ReflectionConfigurationParser.asBoolean(data.get((Object)"allowWrite"), "allowWrite");
        try {
            this.delegate.registerField(clazz, fieldName, allowWrite);
        }
        catch (NoSuchFieldException e) {
            this.handleMissingElement("Field " + this.formatField(clazz, fieldName) + " not found.");
        }
        catch (LinkageError e) {
            this.handleMissingElement("Could not register field " + this.formatField(clazz, fieldName) + " for reflection.", e);
        }
    }

    private void parseMethods(boolean queriedOnly, List<Object> methods, T clazz) {
        for (Object method : methods) {
            this.parseMethod(queriedOnly, ReflectionConfigurationParser.asMap(method, "Elements of 'methods' array must be method descriptor objects"), clazz);
        }
    }

    private void parseMethod(boolean queriedOnly, EconomicMap<String, Object> data, T clazz) {
        block10: {
            this.checkAttributes(data, "reflection method descriptor object", Collections.singleton("name"), Collections.singleton("parameterTypes"));
            String methodName = ReflectionConfigurationParser.asString(data.get((Object)"name"), "name");
            List<T> methodParameterTypes = null;
            Object parameterTypes = data.get((Object)"parameterTypes");
            if (parameterTypes != null && (methodParameterTypes = this.parseMethodParameters(clazz, methodName, ReflectionConfigurationParser.asList(parameterTypes, "Attribute 'parameterTypes' must be a list of type names"))) == null) {
                return;
            }
            boolean isConstructor = CONSTRUCTOR_NAME.equals(methodName);
            if (methodParameterTypes != null) {
                try {
                    if (isConstructor) {
                        this.delegate.registerConstructor(queriedOnly, clazz, methodParameterTypes);
                        break block10;
                    }
                    this.delegate.registerMethod(queriedOnly, clazz, methodName, methodParameterTypes);
                }
                catch (NoSuchMethodException e) {
                    this.handleMissingElement("Method " + this.formatMethod(clazz, methodName, methodParameterTypes) + " not found.");
                }
                catch (LinkageError e) {
                    this.handleMissingElement("Could not register method " + this.formatMethod(clazz, methodName, methodParameterTypes) + " for reflection.", e);
                }
            } else {
                try {
                    boolean found = isConstructor ? this.delegate.registerAllConstructors(queriedOnly, clazz) : this.delegate.registerAllMethodsWithName(queriedOnly, clazz, methodName);
                    if (!found) {
                        throw new JSONParserException("Method " + this.formatMethod(clazz, methodName) + " not found");
                    }
                }
                catch (LinkageError e) {
                    this.handleMissingElement("Could not register method " + this.formatMethod(clazz, methodName) + " for reflection.", e);
                }
            }
        }
    }

    private List<T> parseMethodParameters(T clazz, String methodName, List<Object> types) {
        ArrayList<T> result = new ArrayList<T>();
        for (Object type : types) {
            String typeName = ReflectionConfigurationParser.asString(type, "types");
            TypeResult<T> typeResult = this.delegate.resolveType(ConfigurationCondition.alwaysTrue(), typeName, true);
            if (!typeResult.isPresent()) {
                this.handleMissingElement("Could not register method " + this.formatMethod(clazz, methodName) + " for reflection.", typeResult.getException());
                return null;
            }
            result.add(typeResult.get());
        }
        return result;
    }

    private static String formatError(Throwable e) {
        return e.getClass().getTypeName() + ": " + e.getMessage();
    }

    private String formatField(T clazz, String fieldName) {
        return this.delegate.getTypeName(clazz) + "." + fieldName;
    }

    private String formatMethod(T clazz, String methodName) {
        return this.formatMethod(clazz, methodName, Collections.emptyList());
    }

    private String formatMethod(T clazz, String methodName, List<T> paramTypes) {
        String parameterTypeNames = paramTypes.stream().map(this.delegate::getSimpleName).collect(Collectors.joining(", "));
        return this.delegate.getTypeName(clazz) + "." + methodName + "(" + parameterTypeNames + ")";
    }

    private void handleMissingElement(String message) {
        this.handleMissingElement(message, null);
    }

    private void handleMissingElement(String msg, Throwable cause) {
        if (this.printMissingElements) {
            Object message = msg;
            if (cause != null) {
                message = (String)message + " Reason: " + ReflectionConfigurationParser.formatError(cause) + ".";
            }
            LogUtils.warning((String)message);
        }
    }
}

