/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.c.function;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.c.function.CEntryPointCreateIsolateParameters;
import com.oracle.svm.core.c.function.CEntryPointErrors;
import com.oracle.svm.core.c.function.CEntryPointNativeFunctions;
import com.oracle.svm.core.feature.AutomaticallyRegisteredImageSingleton;
import com.oracle.svm.core.graal.stackvalue.UnsafeStackValue;
import com.oracle.svm.core.option.SubstrateOptionsParser;
import com.oracle.svm.core.os.MemoryProtectionProvider;
import java.util.List;
import org.graalvm.nativeimage.Isolate;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.Isolates;
import org.graalvm.nativeimage.UnmanagedMemory;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.CCharPointerPointer;
import org.graalvm.nativeimage.c.type.CTypeConversion;
import org.graalvm.nativeimage.impl.IsolateSupport;
import org.graalvm.word.PointerBase;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

@AutomaticallyRegisteredImageSingleton(value={IsolateSupport.class})
public final class IsolateSupportImpl
implements IsolateSupport {
    private static final String ISOLATES_DISABLED_MESSAGE = "Spawning of multiple isolates is disabled, use " + SubstrateOptionsParser.commandArgument(SubstrateOptions.SpawnIsolates, "+") + " option.";
    private static final String PROTECTION_DOMAIN_UNSUPPORTED_MESSAGE = "Protection domains are unavailable";

    IsolateSupportImpl() {
    }

    public IsolateThread createIsolate(Isolates.CreateIsolateParameters parameters) throws Isolates.IsolateException {
        if (!SubstrateOptions.SpawnIsolates.getValue().booleanValue()) {
            throw new Isolates.IsolateException(ISOLATES_DISABLED_MESSAGE);
        }
        try (CTypeConversion.CCharPointerHolder auxImagePath = CTypeConversion.toCString((CharSequence)parameters.getAuxiliaryImagePath());){
            int pkey = 0;
            if (MemoryProtectionProvider.isAvailable()) {
                try {
                    pkey = MemoryProtectionProvider.singleton().asProtectionKey(parameters.getProtectionDomain());
                }
                catch (MemoryProtectionProvider.UnsupportedDomainException e) {
                    throw new Isolates.IsolateException(e.getMessage());
                }
            } else if (!Isolates.ProtectionDomain.NO_DOMAIN.equals((Object)parameters.getProtectionDomain())) {
                throw new Isolates.IsolateException(PROTECTION_DOMAIN_UNSUPPORTED_MESSAGE);
            }
            int argc = 0;
            CCharPointerPointer argv = (CCharPointerPointer)WordFactory.nullPointer();
            List args = parameters.getArguments();
            IsolateThread pointerHolders = null;
            if (!args.isEmpty()) {
                int isolateArgCount = args.size();
                argc = isolateArgCount + 1;
                argv = (CCharPointerPointer)UnmanagedMemory.malloc((UnsignedWord)SizeOf.unsigned(CCharPointerPointer.class).multiply(argc));
                argv.write(0, (CCharPointer)WordFactory.nullPointer());
                pointerHolders = new CTypeConversion.CCharPointerHolder[isolateArgCount];
                for (int i = 0; i < isolateArgCount; ++i) {
                    CTypeConversion.CCharPointerHolder ph = pointerHolders[i] = CTypeConversion.toCString((CharSequence)((CharSequence)args.get(i)));
                    argv.write(i + 1, ph.get());
                }
            }
            CEntryPointCreateIsolateParameters params = UnsafeStackValue.get(CEntryPointCreateIsolateParameters.class);
            params.setProtectionKey(pkey);
            params.setReservedSpaceSize(parameters.getReservedAddressSpaceSize());
            params.setAuxiliaryImagePath(auxImagePath.get());
            params.setAuxiliaryImageReservedSpaceSize(parameters.getAuxiliaryImageReservedSpaceSize());
            params.setVersion(4);
            params.setIgnoreUnrecognizedArguments(false);
            params.setExitWhenArgumentParsingFails(false);
            params.setArgc(argc);
            params.setArgv(argv);
            CEntryPointNativeFunctions.IsolateThreadPointer isolateThreadPtr = UnsafeStackValue.get(CEntryPointNativeFunctions.IsolateThreadPointer.class);
            int result = CEntryPointNativeFunctions.createIsolate(params, (CEntryPointNativeFunctions.IsolatePointer)WordFactory.nullPointer(), isolateThreadPtr);
            IsolateThread isolateThread = isolateThreadPtr.read();
            if (params.getArgv().isNonNull()) {
                for (IsolateThread ph : pointerHolders) {
                    ph.close();
                }
                UnmanagedMemory.free((PointerBase)params.getArgv());
            }
            IsolateSupportImpl.throwOnError(result);
            IsolateThread isolateThread2 = isolateThread;
            return isolateThread2;
        }
    }

    public IsolateThread attachCurrentThread(Isolate isolate) throws Isolates.IsolateException {
        CEntryPointNativeFunctions.IsolateThreadPointer isolateThread = UnsafeStackValue.get(CEntryPointNativeFunctions.IsolateThreadPointer.class);
        IsolateSupportImpl.throwOnError(CEntryPointNativeFunctions.attachThread(isolate, isolateThread));
        return isolateThread.read();
    }

    public IsolateThread getCurrentThread(Isolate isolate) throws Isolates.IsolateException {
        return CEntryPointNativeFunctions.getCurrentThread(isolate);
    }

    public Isolate getIsolate(IsolateThread thread) throws Isolates.IsolateException {
        return CEntryPointNativeFunctions.getIsolate(thread);
    }

    public void detachThread(IsolateThread thread) throws Isolates.IsolateException {
        IsolateSupportImpl.throwOnError(CEntryPointNativeFunctions.detachThread(thread));
    }

    public void tearDownIsolate(IsolateThread thread) throws Isolates.IsolateException {
        if (!SubstrateOptions.SpawnIsolates.getValue().booleanValue()) {
            throw new Isolates.IsolateException(ISOLATES_DISABLED_MESSAGE);
        }
        IsolateSupportImpl.throwOnError(CEntryPointNativeFunctions.tearDownIsolate(thread));
    }

    private static void throwOnError(int code) {
        if (code != 0) {
            String message = CEntryPointErrors.getDescription(code);
            throw new Isolates.IsolateException(message);
        }
    }
}

