/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core;

import com.oracle.svm.core.Containers;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.feature.AutomaticallyRegisteredImageSingleton;
import com.oracle.svm.core.util.VMError;
import jdk.graal.compiler.api.replacements.Fold;
import org.graalvm.nativeimage.ImageSingletons;

@AutomaticallyRegisteredImageSingleton
public class Processor {
    private int lastQueriedActiveProcessorCount = -1;

    @Fold
    public static Processor singleton() {
        return (Processor)ImageSingletons.lookup(Processor.class);
    }

    public int getActiveProcessorCount() {
        int result;
        VMError.guarantee(!SubstrateUtil.HOSTED, "must not be executed during the image build");
        this.lastQueriedActiveProcessorCount = result = Processor.getActiveProcessorCount0();
        return result;
    }

    private static int getActiveProcessorCount0() {
        int optionValue = SubstrateOptions.ActiveProcessorCount.getValue();
        if (optionValue > 0) {
            return optionValue;
        }
        if (SubstrateOptions.MultiThreaded.getValue().booleanValue()) {
            return Containers.activeProcessorCount();
        }
        return 1;
    }

    public int getLastQueriedActiveProcessorCount() {
        return this.lastQueriedActiveProcessorCount;
    }
}

