/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core;

import com.oracle.svm.core.jdk.Jvm;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.util.VMError;
import jdk.internal.platform.Container;
import jdk.internal.platform.Metrics;
import org.graalvm.nativeimage.Platform;

public class Containers {
    public static int activeProcessorCount() {
        Metrics metrics;
        int cpuCount;
        int limitCount = cpuCount = Jvm.JVM_ActiveProcessorCount();
        if (Options.UseContainerSupport.getValue().booleanValue() && Platform.includedIn(Platform.LINUX.class) && (metrics = Container.metrics()) != null) {
            long quota = metrics.getCpuQuota();
            long period = metrics.getCpuPeriod();
            int quotaCount = 0;
            if (quota > -1L && period > 0L) {
                quotaCount = (int)Math.ceil((double)quota / (double)period);
            }
            if (quotaCount != 0) {
                limitCount = quotaCount;
            }
        }
        return Math.min(cpuCount, limitCount);
    }

    public static boolean isContainerized() {
        if (Options.UseContainerSupport.getValue().booleanValue() && Platform.includedIn(Platform.LINUX.class)) {
            return Container.metrics() != null;
        }
        return false;
    }

    public static long memoryLimitInBytes() {
        if (Options.UseContainerSupport.getValue().booleanValue() && Platform.includedIn(Platform.LINUX.class)) {
            Metrics metrics;
            try {
                metrics = Container.metrics();
            }
            catch (StackOverflowError e) {
                throw VMError.shouldNotReachHere("Could not get container metrics, likely due to using NIO in the container code of the JDK (JDK-8309191).", e);
            }
            if (metrics != null) {
                return metrics.getMemoryLimit();
            }
        }
        return -1L;
    }

    public static class Options {
        public static final HostedOptionKey<Boolean> UseContainerSupport = new HostedOptionKey<Boolean>(true);
    }
}

