/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix;

import com.oracle.svm.core.SubstrateSegfaultHandler;
import com.oracle.svm.core.graal.stackvalue.UnsafeStackValue;
import com.oracle.svm.core.headers.LibC;
import com.oracle.svm.core.jdk.RuntimeSupport;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.posix.PosixUtils;
import com.oracle.svm.core.posix.Target_jdk_internal_misc_Signal;
import com.oracle.svm.core.posix.headers.CSunMiscSignal;
import com.oracle.svm.core.posix.headers.Errno;
import com.oracle.svm.core.posix.headers.Signal;
import com.oracle.svm.core.util.VMError;
import java.util.ArrayList;
import java.util.concurrent.locks.ReentrantLock;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.c.type.CIntPointer;
import org.graalvm.word.ComparableWord;
import org.graalvm.word.WordFactory;

final class Util_jdk_internal_misc_Signal {
    private static Thread dispatchThread = null;
    private static final ReentrantLock initializationLock = new ReentrantLock();
    private static volatile boolean initialized = false;
    private static SignalState[] signalState = null;
    private static final long sunMiscSignalDefaultHandler = 0L;
    private static final long sunMiscSignalIgnoreHandler = 1L;
    private static final long sunMiscSignalDispatchHandler = 2L;
    private static final long sunMiscSignalErrorHandler = -1L;

    private Util_jdk_internal_misc_Signal() {
    }

    static boolean isCurrentDispatcher(int sig, Signal.SignalDispatcher dispatcher) {
        Signal.sigaction handler = UnsafeStackValue.get(Signal.sigaction.class);
        Signal.sigaction(sig, (Signal.sigaction)WordFactory.nullPointer(), handler);
        return handler.sa_handler() == dispatcher;
    }

    static long handle0(int sig, long nativeH) {
        Util_jdk_internal_misc_Signal.ensureInitialized();
        Signal.SignalDispatcher newDispatcher = Util_jdk_internal_misc_Signal.nativeHToDispatcher(nativeH);
        if (newDispatcher == CSunMiscSignal.countingHandlerFunctionPointer() && CSunMiscSignal.signalRangeCheck(sig) != 1) {
            return -1L;
        }
        if (SubstrateSegfaultHandler.isInstalled() && (sig == Signal.SignalEnum.SIGSEGV.getCValue() || sig == Signal.SignalEnum.SIGBUS.getCValue())) {
            return -1L;
        }
        if ((sig == Signal.SignalEnum.SIGHUP.getCValue() || sig == Signal.SignalEnum.SIGINT.getCValue() || sig == Signal.SignalEnum.SIGTERM.getCValue()) && Util_jdk_internal_misc_Signal.isCurrentDispatcher(sig, Signal.SIG_IGN())) {
            return 1L;
        }
        Util_jdk_internal_misc_Signal.updateDispatcher(sig, newDispatcher);
        Signal.SignalDispatcher oldDispatcher = PosixUtils.installSignalHandler(sig, newDispatcher, Signal.SA_RESTART());
        CIntPointer sigset = UnsafeStackValue.get(CIntPointer.class);
        sigset.write(1 << sig - 1);
        Signal.sigprocmask(Signal.SIG_UNBLOCK(), (Signal.sigset_tPointer)sigset, (Signal.sigset_tPointer)WordFactory.nullPointer());
        return Util_jdk_internal_misc_Signal.dispatcherToNativeH(oldDispatcher);
    }

    private static void ensureInitialized() throws IllegalArgumentException {
        if (!initialized) {
            initializationLock.lock();
            try {
                if (!initialized) {
                    int openResult = CSunMiscSignal.open();
                    if (openResult != 0) {
                        int openErrno = LibC.errno();
                        if (openErrno == Errno.EBUSY()) {
                            throw new IllegalArgumentException("C signal handling mechanism is in use.");
                        }
                        Log.log().string("Util_jdk_internal_misc_Signal.ensureInitialized: CSunMiscSignal.create() failed.").string("  errno: ").signed(openErrno).string("  ").string(Errno.strerror(openErrno)).newline();
                        throw VMError.shouldNotReachHere("Util_jdk_internal_misc_Signal.ensureInitialized: CSunMiscSignal.open() failed.");
                    }
                    signalState = Util_jdk_internal_misc_Signal.createSignalStateTable();
                    dispatchThread = new Thread(new DispatchThread());
                    dispatchThread.setName("Signal Dispatcher");
                    dispatchThread.setDaemon(true);
                    dispatchThread.start();
                    RuntimeSupport.getRuntimeSupport().addTearDownHook(isFirstIsolate -> DispatchThread.interrupt(dispatchThread));
                    initialized = true;
                }
            }
            finally {
                initializationLock.unlock();
            }
        }
    }

    private static SignalState[] createSignalStateTable() {
        ArrayList<SignalState> signalStateList = new ArrayList<SignalState>();
        for (Signal.SignalEnum signalEnum : Signal.SignalEnum.values()) {
            signalStateList.add(new SignalState(signalEnum.name(), signalEnum.getCValue()));
        }
        if (Platform.includedIn(Platform.LINUX.class)) {
            for (Enum enum_ : Signal.LinuxSignalEnum.values()) {
                signalStateList.add(new SignalState(enum_.name(), ((Signal.LinuxSignalEnum)enum_).getCValue()));
            }
        } else if (Platform.includedIn(Platform.DARWIN.class)) {
            for (Enum enum_ : Signal.DarwinSignalEnum.values()) {
                signalStateList.add(new SignalState(enum_.name(), ((Signal.DarwinSignalEnum)enum_).getCValue()));
            }
        }
        SignalState[] result = signalStateList.toArray(new SignalState[0]);
        return result;
    }

    protected static int numberFromName(String javaSignalName) {
        Util_jdk_internal_misc_Signal.ensureInitialized();
        String cSignalName = "SIG" + javaSignalName;
        for (int index = 0; index < signalState.length; ++index) {
            SignalState entry = signalState[index];
            if (!entry.getName().equals(cSignalName)) continue;
            return entry.getNumber();
        }
        return -1;
    }

    private static void updateDispatcher(int sig, Signal.SignalDispatcher dispatcher) {
        for (int index = 0; index < signalState.length; ++index) {
            SignalState entry = signalState[index];
            if (entry.getNumber() != sig) continue;
            entry.setDispatcher(dispatcher);
            return;
        }
    }

    private static Signal.SignalDispatcher nativeHToDispatcher(long nativeH) {
        Signal.SignalDispatcher result = nativeH == 0L ? Signal.SIG_DFL() : (nativeH == 1L ? Signal.SIG_IGN() : (nativeH == 2L ? CSunMiscSignal.countingHandlerFunctionPointer() : (nativeH == -1L ? Signal.SIG_ERR() : (Signal.SignalDispatcher)WordFactory.pointer((long)nativeH))));
        return result;
    }

    private static long dispatcherToNativeH(Signal.SignalDispatcher handler) {
        long result = handler == Signal.SIG_DFL() ? 0L : (handler == Signal.SIG_IGN() ? 1L : (handler == CSunMiscSignal.countingHandlerFunctionPointer() ? 2L : (handler == Signal.SIG_ERR() ? -1L : handler.rawValue())));
        return result;
    }

    private static final class SignalState {
        private final String name;
        private final int number;
        private Signal.SignalDispatcher dispatcher;

        protected SignalState(String cName, int cValue) {
            this.name = cName;
            this.number = cValue;
            this.dispatcher = Signal.SIG_DFL();
        }

        protected String getName() {
            return this.name;
        }

        protected int getNumber() {
            return this.number;
        }

        protected Signal.SignalDispatcher getDispatcher() {
            return this.dispatcher;
        }

        protected void setDispatcher(Signal.SignalDispatcher value) {
            this.dispatcher = value;
        }

        protected static void await() {
            int awaitResult = CSunMiscSignal.await();
            PosixUtils.checkStatusIs0(awaitResult, "Util_jdk_internal_misc_Signal.SignalState.await(): CSunMiscSignal.await() failed.");
        }

        protected static void wakeUp() {
            int awaitResult = CSunMiscSignal.post();
            PosixUtils.checkStatusIs0(awaitResult, "Util_jdk_internal_misc_Signal.SignalState.post(): CSunMiscSignal.post() failed.");
        }

        protected long decrementCount() {
            return CSunMiscSignal.decrementCount(this.number);
        }
    }

    protected static final class DispatchThread
    implements Runnable {
        protected DispatchThread() {
        }

        static void interrupt(Thread thread) {
            thread.interrupt();
            SignalState.wakeUp();
        }

        @Override
        public void run() {
            while (!Thread.interrupted()) {
                SignalState.await();
                if (Thread.interrupted()) break;
                for (SignalState entry : signalState) {
                    Signal.SignalDispatcher dispatcher = entry.getDispatcher();
                    if (!dispatcher.equal((ComparableWord)CSunMiscSignal.countingHandlerFunctionPointer()) || entry.decrementCount() <= 0L) continue;
                    Target_jdk_internal_misc_Signal.dispatch(entry.getNumber());
                }
            }
            CSunMiscSignal.close();
        }
    }
}

