/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.NeverInline;
import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.RecomputeFieldValue;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.jdk.BacktraceVisitor;
import com.oracle.svm.core.jdk.ThrowableStackTraceFieldValueTransformer;
import com.oracle.svm.core.monitor.MonitorSupport;
import com.oracle.svm.core.thread.JavaThreads;
import com.oracle.svm.core.thread.VMOperation;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.impl.InternalPlatform;

@TargetClass(value=Throwable.class)
@Platforms(value={InternalPlatform.NATIVE_ONLY.class})
final class Target_java_lang_Throwable {
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Reset)
    Object backtrace;
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Custom, declClass=ThrowableStackTraceFieldValueTransformer.class)
    StackTraceElement[] stackTrace;
    @Alias
    String detailMessage;
    @Alias
    static StackTraceElement[] UNASSIGNED_STACK;

    Target_java_lang_Throwable() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Substitute
    @NeverInline(value="Starting a stack walk in the caller frame")
    public Target_java_lang_Throwable fillInStackTrace() {
        if (VMOperation.isInProgress()) {
            if (!(MonitorSupport.singleton().isLockedByAnyThread(this) || this.stackTrace == null && this.backtrace == null)) {
                this.fillInStackTrace(0);
                this.stackTrace = UNASSIGNED_STACK;
            }
        } else {
            Target_java_lang_Throwable target_java_lang_Throwable = this;
            synchronized (target_java_lang_Throwable) {
                if (this.stackTrace != null || this.backtrace != null) {
                    this.fillInStackTrace(0);
                    this.stackTrace = UNASSIGNED_STACK;
                }
            }
        }
        return this;
    }

    @Substitute
    @NeverInline(value="Starting a stack walk in the caller frame")
    Target_java_lang_Throwable fillInStackTrace(int dummy) {
        this.backtrace = null;
        BacktraceVisitor visitor = new BacktraceVisitor();
        JavaThreads.visitCurrentStackFrames(visitor);
        this.backtrace = visitor.getArray();
        return this;
    }
}

