/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.AnnotateOriginal;
import com.oracle.svm.core.annotate.RecomputeFieldValue;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.jdk.StringHelper;
import com.oracle.svm.core.jdk.StringInternSupport;
import java.util.regex.Pattern;
import org.graalvm.nativeimage.ImageSingletons;

@TargetClass(value=String.class)
final class Target_java_lang_String {
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.None, isFinal=true)
    byte[] value;
    @Alias
    int hash;

    Target_java_lang_String() {
    }

    @Substitute
    public String intern() {
        String thisStr = SubstrateUtil.cast(this, String.class);
        return ((StringInternSupport)ImageSingletons.lookup(StringInternSupport.class)).intern(thisStr);
    }

    @AnnotateOriginal
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    native boolean isLatin1();

    @AnnotateOriginal
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public native boolean isEmpty();

    @AnnotateOriginal
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public native int length();

    @AnnotateOriginal
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    native byte coder();

    @Substitute
    public String[] split(String regex, int limit) {
        char ch = '\u0000';
        if ((regex.length() == 1 && ".$|()[{^?*+\\".indexOf(ch = regex.charAt(0)) == -1 || regex.length() == 2 && regex.charAt(0) == '\\' && ((ch = regex.charAt(1)) - 48 | 57 - ch) < 0 && (ch - 97 | 122 - ch) < 0 && (ch - 65 | 90 - ch) < 0) && (ch < '\ud800' || ch > '\udfff')) {
            return StringHelper.simpleSplit(SubstrateUtil.cast(this, String.class), limit, ch);
        }
        return Pattern.compile(regex).split(SubstrateUtil.cast(this, String.class), limit);
    }
}

