/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jfr.events;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.jfr.JfrEvent;
import com.oracle.svm.core.jfr.JfrNativeEventWriter;
import com.oracle.svm.core.jfr.JfrNativeEventWriterData;
import com.oracle.svm.core.jfr.JfrNativeEventWriterDataAccess;
import com.oracle.svm.core.jfr.JfrTicks;
import org.graalvm.nativeimage.StackValue;

public class ThreadEndEvent {
    @Uninterruptible(reason="Accesses a JFR buffer.")
    public static void emit(Thread thread) {
        if (JfrEvent.ThreadEnd.shouldEmit()) {
            JfrNativeEventWriterData data = (JfrNativeEventWriterData)StackValue.get(JfrNativeEventWriterData.class);
            JfrNativeEventWriterDataAccess.initializeThreadLocalNativeBuffer(data);
            JfrNativeEventWriter.beginSmallEvent(data, JfrEvent.ThreadEnd);
            JfrNativeEventWriter.putLong(data, JfrTicks.elapsedTicks());
            JfrNativeEventWriter.putEventThread(data);
            JfrNativeEventWriter.putThread(data, thread);
            JfrNativeEventWriter.endSmallEvent(data);
        }
    }
}

