/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.truffle.api;

import com.oracle.svm.truffle.api.SubstrateKnownTruffleTypes;
import com.oracle.svm.truffle.api.SubstratePEGraphDecoder;
import com.oracle.svm.truffle.api.SubstrateTruffleGraphBuilderPlugins;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.collections.EconomicMap;
import org.graalvm.compiler.core.common.spi.ConstantFieldProvider;
import org.graalvm.compiler.graph.SourceLanguagePositionProvider;
import org.graalvm.compiler.nodes.EncodedGraph;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderConfiguration;
import org.graalvm.compiler.nodes.graphbuilderconf.InlineInvokePlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugins;
import org.graalvm.compiler.nodes.graphbuilderconf.LoopExplosionPlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.NodePlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.ParameterPlugin;
import org.graalvm.compiler.nodes.spi.CoreProviders;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.compiler.replacements.PEGraphDecoder;
import org.graalvm.compiler.truffle.compiler.PartialEvaluator;
import org.graalvm.compiler.truffle.compiler.PartialEvaluatorConfiguration;
import org.graalvm.compiler.truffle.compiler.TruffleCompilerConfiguration;
import org.graalvm.compiler.truffle.compiler.TruffleTierContext;
import org.graalvm.compiler.truffle.compiler.substitutions.KnownTruffleTypes;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public class SubstratePartialEvaluator
extends PartialEvaluator {
    private final ConcurrentHashMap<ResolvedJavaMethod, Object> invocationPluginsCache = new ConcurrentHashMap();
    private final ConcurrentHashMap<PEGraphDecoder.SpecialCallTargetCacheKey, Object> specialCallTargetCache = new ConcurrentHashMap();

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public SubstratePartialEvaluator(TruffleCompilerConfiguration config, GraphBuilderConfiguration graphBuilderConfigForRoot) {
        super(config, graphBuilderConfigForRoot, (KnownTruffleTypes)new SubstrateKnownTruffleTypes(config.lastTier().providers().getMetaAccess()));
    }

    protected PEGraphDecoder createGraphDecoder(TruffleTierContext context, InvocationPlugins invocationPlugins, InlineInvokePlugin[] inlineInvokePlugins, ParameterPlugin parameterPlugin, NodePlugin[] nodePlugins, SourceLanguagePositionProvider sourceLanguagePositionProvider, EconomicMap<ResolvedJavaMethod, EncodedGraph> graphCache, Supplier<AutoCloseable> createCachedGraphScope) {
        return new SubstratePEGraphDecoder(this.config.architecture(), context.graph, (CoreProviders)this.config.lastTier().providers().copyWith((ConstantFieldProvider)this.compilationLocalConstantProvider), (LoopExplosionPlugin)this.loopExplosionPlugin, invocationPlugins, inlineInvokePlugins, parameterPlugin, nodePlugins, this.callInlined, sourceLanguagePositionProvider, this.specialCallTargetCache, this.invocationPluginsCache);
    }

    protected StructuredGraph.Builder customizeStructuredGraphBuilder(StructuredGraph.Builder builder) {
        return super.customizeStructuredGraphBuilder(builder).recordInlinedMethods(false);
    }

    protected void registerGraphBuilderInvocationPlugins(InvocationPlugins invocationPlugins, boolean canDelayIntrinsification) {
        super.registerGraphBuilderInvocationPlugins(invocationPlugins, canDelayIntrinsification);
        SubstrateTruffleGraphBuilderPlugins.registerInvocationPlugins(invocationPlugins, canDelayIntrinsification, (SubstrateKnownTruffleTypes)this.getKnownTruffleTypes());
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    protected InvocationPlugins createDecodingInvocationPlugins(PartialEvaluatorConfiguration peConfig, GraphBuilderConfiguration.Plugins parent, Providers tierProviders) {
        InvocationPlugins decodingInvocationPlugins = new InvocationPlugins();
        this.registerGraphBuilderInvocationPlugins(decodingInvocationPlugins, false);
        peConfig.registerDecodingInvocationPlugins(decodingInvocationPlugins, false, this.config.lastTier().providers(), this.config.architecture());
        decodingInvocationPlugins.closeRegistration();
        return decodingInvocationPlugins;
    }

    protected NodePlugin[] createNodePlugins(GraphBuilderConfiguration.Plugins plugins) {
        return null;
    }
}

