/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.truffle;

import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.jfr.JfrFeature;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.truffle.TruffleFeature;
import java.util.Iterator;
import org.graalvm.compiler.serviceprovider.JavaVersionUtil;
import org.graalvm.compiler.truffle.jfr.EventFactory;
import org.graalvm.compiler.truffle.runtime.serviceprovider.TruffleRuntimeServices;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticFeature
public class TruffleJFRFeature
implements Feature {
    public void afterRegistration(Feature.AfterRegistrationAccess access) {
        if (TruffleJFRFeature.isEnabled()) {
            Iterator providers = TruffleRuntimeServices.load(EventFactory.Provider.class).iterator();
            if (!providers.hasNext()) {
                throw UserError.abort("No EventFactory.Provider is registered in Truffle runtime services.", new Object[0]);
            }
            EventFactory.Provider provider = (EventFactory.Provider)providers.next();
            EventFactory factory = provider.getEventFactory();
            ImageSingletons.add(EventFactory.class, (Object)factory);
        }
    }

    private static boolean isEnabled() {
        return ImageSingletons.contains(TruffleFeature.class) && ImageSingletons.contains(JfrFeature.class) && JavaVersionUtil.JAVA_SPEC < 17;
    }
}

