/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.truffle;

import com.oracle.svm.hosted.meta.HostedMethod;
import com.oracle.svm.truffle.TruffleFeature;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.core.common.CompilationIdentifier;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.phases.common.CanonicalizerPhase;
import org.graalvm.compiler.phases.tiers.HighTierContext;
import org.graalvm.compiler.truffle.compiler.phases.TruffleHostInliningPhase;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

@Platforms(value={Platform.HOSTED_ONLY.class})
public final class SubstrateTruffleHostInliningPhase
extends TruffleHostInliningPhase {
    private final TruffleFeature truffleFeature = (TruffleFeature)ImageSingletons.lookup(TruffleFeature.class);

    SubstrateTruffleHostInliningPhase(CanonicalizerPhase canonicalizer) {
        super(canonicalizer);
    }

    protected StructuredGraph parseGraph(HighTierContext context, StructuredGraph graph, ResolvedJavaMethod method) {
        return ((HostedMethod)method).compilationInfo.createGraph(graph.getDebug(), (CompilationIdentifier)CompilationIdentifier.INVALID_COMPILATION_ID, true);
    }

    protected boolean isEnabledFor(ResolvedJavaMethod method) {
        HostedMethod hostedMethod = (HostedMethod)method;
        if (hostedMethod.isDeoptTarget()) {
            return false;
        }
        if (super.isEnabledFor(method)) {
            return true;
        }
        return !this.isTruffleBoundary(method);
    }

    protected boolean isTruffleBoundary(ResolvedJavaMethod targetMethod) {
        ResolvedJavaMethod translatedMethod = this.translateMethod(targetMethod);
        if (super.isTruffleBoundary(targetMethod)) {
            return true;
        }
        if (this.truffleFeature.isBlocklisted(translatedMethod)) {
            return true;
        }
        return !this.truffleFeature.runtimeCompiledMethods.contains(translatedMethod);
    }

    protected ResolvedJavaMethod translateMethod(ResolvedJavaMethod method) {
        return ((HostedMethod)method).getWrapped();
    }
}

