/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.methodhandles;

import com.oracle.svm.core.StaticFieldsSupport;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.annotate.AnnotateOriginal;
import com.oracle.svm.core.annotate.Delete;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.annotate.TargetElement;
import com.oracle.svm.core.invoke.Target_java_lang_invoke_MemberName;
import com.oracle.svm.core.jdk.JDK11OrEarlier;
import com.oracle.svm.core.jdk.JDK17OrLater;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.methodhandles.Target_java_lang_invoke_MethodHandleNatives_CallSiteContext;
import com.oracle.svm.methodhandles.Target_java_lang_invoke_MethodHandleNatives_Constants;
import com.oracle.svm.methodhandles.Util_java_lang_invoke_MethodHandleNatives;
import com.oracle.svm.reflect.target.Target_java_lang_reflect_Field;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

@TargetClass(className="java.lang.invoke.MethodHandleNatives")
final class Target_java_lang_invoke_MethodHandleNatives {
    Target_java_lang_invoke_MethodHandleNatives() {
    }

    @Substitute
    private static void init(Target_java_lang_invoke_MemberName self, Object ref) {
        byte refKind;
        int flags;
        Object[] type;
        Member member = (Member)ref;
        if (member instanceof Field) {
            Field field = (Field)member;
            type = field.getType();
            flags = Target_java_lang_invoke_MethodHandleNatives_Constants.MN_IS_FIELD | field.getModifiers();
            refKind = Modifier.isStatic(field.getModifiers()) ? Target_java_lang_invoke_MethodHandleNatives_Constants.REF_getStatic : Target_java_lang_invoke_MethodHandleNatives_Constants.REF_getField;
        } else if (member instanceof Method) {
            Method method = (Method)member;
            Object[] typeInfo = new Object[]{method.getReturnType(), method.getParameterTypes()};
            type = typeInfo;
            int mods = method.getModifiers();
            flags = Target_java_lang_invoke_MethodHandleNatives_Constants.MN_IS_METHOD | mods;
            refKind = Modifier.isStatic(mods) ? Target_java_lang_invoke_MethodHandleNatives_Constants.REF_invokeStatic : (Modifier.isInterface(mods) ? Target_java_lang_invoke_MethodHandleNatives_Constants.REF_invokeInterface : Target_java_lang_invoke_MethodHandleNatives_Constants.REF_invokeVirtual);
        } else if (member instanceof Constructor) {
            Constructor constructor = (Constructor)member;
            Object[] typeInfo = new Object[]{Void.TYPE, constructor.getParameterTypes()};
            type = typeInfo;
            flags = Target_java_lang_invoke_MethodHandleNatives_Constants.MN_IS_CONSTRUCTOR | constructor.getModifiers();
            refKind = Target_java_lang_invoke_MethodHandleNatives_Constants.REF_newInvokeSpecial;
        } else {
            throw new InternalError("unknown member type: " + member.getClass());
        }
        self.init(member.getDeclaringClass(), member.getName(), type, flags |= refKind << Target_java_lang_invoke_MethodHandleNatives_Constants.MN_REFERENCE_KIND_SHIFT);
        self.reflectAccess = (Member)ref;
    }

    @Substitute
    private static void expand(Target_java_lang_invoke_MemberName self) {
        throw VMError.unsupportedFeature("MethodHandleNatives.expand()");
    }

    @Delete
    private static native int getMembers(Class<?> var0, String var1, String var2, int var3, Class<?> var4, int var5, Target_java_lang_invoke_MemberName[] var6);

    @Substitute
    private static long objectFieldOffset(Target_java_lang_invoke_MemberName self) {
        if (self.reflectAccess == null && self.intrinsic == null) {
            throw new InternalError("unresolved field");
        }
        if (!self.isField() || self.isStatic()) {
            throw new InternalError("non-static field required");
        }
        if (self.intrinsic != null) {
            return -1L;
        }
        int offset = SubstrateUtil.cast((Object)self.reflectAccess, Target_java_lang_reflect_Field.class).offset;
        if (offset == -1) {
            throw VMError.unsupportedFeature("Trying to access field " + self.reflectAccess + " without registering it as unsafe accessed.");
        }
        return offset;
    }

    @Substitute
    private static long staticFieldOffset(Target_java_lang_invoke_MemberName self) {
        if (self.reflectAccess == null && self.intrinsic == null) {
            throw new InternalError("unresolved field");
        }
        if (!self.isField() || !self.isStatic()) {
            throw new InternalError("static field required");
        }
        if (self.intrinsic != null) {
            return -1L;
        }
        int offset = SubstrateUtil.cast((Object)self.reflectAccess, Target_java_lang_reflect_Field.class).offset;
        if (offset == -1) {
            throw VMError.unsupportedFeature("Trying to access field " + self.reflectAccess + " without registering it as unsafe accessed.");
        }
        return offset;
    }

    @Substitute
    private static Object staticFieldBase(Target_java_lang_invoke_MemberName self) {
        if (self.reflectAccess == null) {
            throw new InternalError("unresolved field");
        }
        if (!self.isField() || !self.isStatic()) {
            throw new InternalError("static field required");
        }
        return ((Field)self.reflectAccess).getType().isPrimitive() ? StaticFieldsSupport.getStaticPrimitiveFields() : StaticFieldsSupport.getStaticObjectFields();
    }

    @Substitute
    private static Object getMemberVMInfo(Target_java_lang_invoke_MemberName self) {
        throw VMError.unsupportedFeature("MethodHandleNatives.getMemberVMInfo()");
    }

    @Delete
    private static native void setCallSiteTargetNormal(CallSite var0, MethodHandle var1);

    @Delete
    private static native void setCallSiteTargetVolatile(CallSite var0, MethodHandle var1);

    @Delete
    private static native void registerNatives();

    @Delete
    private static native int getNamedCon(int var0, Object[] var1);

    @Substitute
    @TargetElement(onlyWith={JDK11OrEarlier.class})
    static Target_java_lang_invoke_MemberName resolve(Target_java_lang_invoke_MemberName self, Class<?> caller, boolean speculativeResolve) throws LinkageError, ClassNotFoundException {
        return Util_java_lang_invoke_MethodHandleNatives.resolve(self, caller, speculativeResolve);
    }

    @Delete
    private static native void copyOutBootstrapArguments(Class<?> var0, int[] var1, int var2, int var3, Object[] var4, int var5, boolean var6, Object var7);

    @Substitute
    private static void clearCallSiteContext(Target_java_lang_invoke_MethodHandleNatives_CallSiteContext context) {
        throw VMError.unimplemented("CallSiteContext not supported");
    }

    @AnnotateOriginal
    static native boolean refKindIsMethod(byte var0);

    @AnnotateOriginal
    static native String refKindName(byte var0);

    @Substitute
    @TargetElement(onlyWith={JDK17OrLater.class})
    static Target_java_lang_invoke_MemberName resolve(Target_java_lang_invoke_MemberName self, Class<?> caller, int lookupMode, boolean speculativeResolve) throws LinkageError, ClassNotFoundException {
        Class<?> declaringClass = self.getDeclaringClass();
        Target_java_lang_invoke_MemberName resolved = Util_java_lang_invoke_MethodHandleNatives.resolve(self, caller, speculativeResolve);
        assert (resolved == null || resolved.reflectAccess != null || resolved.intrinsic != null);
        if (resolved != null && resolved.reflectAccess != null && !Util_java_lang_invoke_MethodHandleNatives.verifyAccess(declaringClass, resolved.reflectAccess.getDeclaringClass(), resolved.reflectAccess.getModifiers(), caller, lookupMode)) {
            throw new IllegalAccessError(resolved + " is not accessible from " + caller);
        }
        return resolved;
    }
}

