/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.heap;

import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.heapdump.HeapDumpUtils;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.heap.HeapDumpHostedUtils;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticFeature
class HeapDumpFieldsMapFeature
implements Feature {
    HeapDumpFieldsMapFeature() {
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void afterCompilation(Feature.AfterCompilationAccess access) {
        FeatureImpl.AfterCompilationAccessImpl accessImpl = (FeatureImpl.AfterCompilationAccessImpl)access;
        byte[] fieldMap = HeapDumpHostedUtils.dumpFieldsMap(accessImpl.getTypes());
        HeapDumpUtils.getHeapDumpUtils().setFieldsMap(fieldMap);
        access.registerAsImmutable((Object)fieldMap);
    }
}

