/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.annotation;

import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.AnalysisUniverse;
import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.hosted.FeatureImpl;
import jdk.vm.ci.meta.JavaType;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticFeature
public class AnnotationTypeFeature
implements Feature {
    public void duringAnalysis(Feature.DuringAnalysisAccess access) {
        FeatureImpl.DuringAnalysisAccessImpl accessImpl = (FeatureImpl.DuringAnalysisAccessImpl)access;
        AnalysisUniverse universe = accessImpl.getUniverse();
        universe.getTypes().stream().filter(AnalysisType::isAnnotation).filter(AnalysisType::isReachable).map(type -> universe.lookup((JavaType)type.getWrapped()).getArrayClass()).filter(annotationArray -> !annotationArray.isInstantiated()).forEach(annotationArray -> {
            accessImpl.registerAsInHeap((AnalysisType)annotationArray);
            access.requireAnalysisIteration();
        });
    }
}

