/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.thread;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.annotate.NeverInline;
import com.oracle.svm.core.annotate.RestrictHeapAccess;
import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.heap.Heap;
import com.oracle.svm.core.heap.VMOperationInfos;
import com.oracle.svm.core.locks.VMCondition;
import com.oracle.svm.core.locks.VMMutex;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.nodes.CFunctionEpilogueNode;
import com.oracle.svm.core.nodes.CFunctionPrologueNode;
import com.oracle.svm.core.stack.StackOverflowCheck;
import com.oracle.svm.core.thread.JavaVMOperation;
import com.oracle.svm.core.thread.NativeVMOperation;
import com.oracle.svm.core.thread.NativeVMOperationData;
import com.oracle.svm.core.thread.Safepoint;
import com.oracle.svm.core.thread.ThreadingSupportImpl;
import com.oracle.svm.core.thread.VMOperation;
import com.oracle.svm.core.thread.VMThreads;
import com.oracle.svm.core.util.RingBuffer;
import com.oracle.svm.core.util.VMError;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.compiler.word.Word;
import org.graalvm.nativeimage.CurrentIsolate;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

public final class VMOperationControl {
    private final VMOperationThread dedicatedVMOperationThread = new VMOperationThread();
    private final WorkQueues mainQueues = new WorkQueues("main", true);
    private final WorkQueues immediateQueues = new WorkQueues("immediate", false);
    private final OpInProgress inProgress = new OpInProgress();
    private final VMOpHistory history = new VMOpHistory();

    @Platforms(value={Platform.HOSTED_ONLY.class})
    VMOperationControl() {
    }

    @Fold
    static VMOperationControl get() {
        return (VMOperationControl)ImageSingletons.lookup(VMOperationControl.class);
    }

    @Fold
    public static boolean useDedicatedVMOperationThread() {
        return SubstrateOptions.MultiThreaded.getValue() != false && SubstrateOptions.AllowVMInternalThreads.getValue() != false && SubstrateOptions.ConcealedOptions.UseDedicatedVMOperationThread.getValue() != false;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static VMOperationThread getDedicatedVMOperationThread() {
        VMOperationControl control = VMOperationControl.get();
        assert (control.dedicatedVMOperationThread != null);
        return control.dedicatedVMOperationThread;
    }

    public static void startVMOperationThread() {
        assert (VMOperationControl.useDedicatedVMOperationThread());
        VMOperationControl control = VMOperationControl.get();
        assert (control.mainQueues.isEmpty());
        control.dedicatedVMOperationThread.start();
        control.dedicatedVMOperationThread.waitUntilStarted();
    }

    public static void shutdownAndDetachVMOperationThread() {
        assert (VMOperationControl.useDedicatedVMOperationThread());
        StopVMOperationThread vmOp = new StopVMOperationThread();
        vmOp.enqueue();
        VMOperationControl.waitUntilVMOperationThreadDetached();
        assert (VMOperationControl.get().mainQueues.isEmpty());
    }

    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Called during teardown")
    @NeverInline(value="Must not be inlined in a caller that has an exception handler: We only support InvokeNode and not InvokeWithExceptionNode between a CFunctionPrologueNode and CFunctionEpilogueNode.")
    private static void waitUntilVMOperationThreadDetached() {
        CFunctionPrologueNode.cFunctionPrologue(3);
        VMOperationControl.waitUntilVMOperationThreadDetachedInNative();
        CFunctionEpilogueNode.cFunctionEpilogue(3);
    }

    @Uninterruptible(reason="Must not stop while in native.")
    @NeverInline(value="Provide a return address for the Java frame anchor.")
    private static void waitUntilVMOperationThreadDetachedInNative() {
        VMThreads.THREAD_MUTEX.lockNoTransition();
        try {
            while (VMThreads.nextThread(VMThreads.firstThread()).isNonNull()) {
                VMThreads.THREAD_LIST_CONDITION.blockNoTransition();
            }
        }
        finally {
            VMThreads.THREAD_MUTEX.unlock();
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static boolean isDedicatedVMOperationThread() {
        return VMOperationControl.isDedicatedVMOperationThread(CurrentIsolate.getCurrentThread());
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static boolean isDedicatedVMOperationThread(IsolateThread thread) {
        if (VMOperationControl.useDedicatedVMOperationThread()) {
            return thread == VMOperationControl.get().dedicatedVMOperationThread.getIsolateThread();
        }
        return false;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static boolean mayExecuteVmOperations() {
        if (!SubstrateOptions.MultiThreaded.getValue().booleanValue()) {
            return true;
        }
        if (VMOperationControl.useDedicatedVMOperationThread()) {
            return VMOperationControl.isDedicatedVMOperationThread();
        }
        return VMOperationControl.get().mainQueues.mutex.isOwner();
    }

    public static void printCurrentVMOperation(Log log, boolean allowJavaHeapAccess) {
        VMOperationControl control = VMOperationControl.get();
        VMOperation op = control.inProgress.operation;
        if (op == null) {
            log.string("No VMOperation in progress").newline();
        } else if (allowJavaHeapAccess) {
            log.string("VMOperation in progress: ").string(op.getName()).indent(true);
            log.string("Safepoint: ").bool(op.getCausesSafepoint()).newline();
            log.string("QueuingThread: ").zhex(control.inProgress.queueingThread.rawValue()).newline();
            log.string("ExecutingThread: ").zhex(control.inProgress.executingThread.rawValue()).newline();
            log.redent(false);
        } else {
            log.string("VMOperation in progress: ").zhex((WordBase)Word.objectToUntrackedPointer((Object)op)).newline();
        }
    }

    public static void printRecentEvents(Log log, boolean allowJavaHeapAccess) {
        VMOperationControl.get().history.print(log, allowJavaHeapAccess);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    OpInProgress getInProgress() {
        return this.inProgress;
    }

    @Uninterruptible(reason="Set the current VM operation as atomically as possible - this is mainly relevant for deopt test cases")
    void setInProgress(VMOperation operation, IsolateThread queueingThread, IsolateThread executingThread, boolean started) {
        assert (operation != null && executingThread.isNonNull() || operation == null && queueingThread.isNull() && executingThread.isNull() && !started);
        if (started) {
            this.history.add(VMOpStatus.Started, operation, queueingThread, executingThread, this.inProgress.nestingLevel);
            ++this.inProgress.nestingLevel;
        } else if (this.inProgress.operation != null) {
            --this.inProgress.nestingLevel;
            this.history.add(VMOpStatus.Finished, this.inProgress.operation, this.inProgress.queueingThread, this.inProgress.executingThread, this.inProgress.nestingLevel);
        }
        this.inProgress.executingThread = executingThread;
        this.inProgress.operation = operation;
        this.inProgress.queueingThread = queueingThread;
    }

    void enqueue(JavaVMOperation operation) {
        this.enqueue(operation, (NativeVMOperationData)WordFactory.nullPointer());
    }

    void enqueue(NativeVMOperationData data) {
        this.enqueue(data.getNativeVMOperation(), data);
    }

    @Uninterruptible(reason="Called from a non-Java thread.")
    void enqueueFromNonJavaThread(NativeVMOperationData data) {
        this.enqueueFromNonJavaThread(data.getNativeVMOperation(), data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enqueue(VMOperation operation, NativeVMOperationData data) {
        StackOverflowCheck.singleton().makeYellowZoneAvailable();
        try {
            VMError.guarantee(!VMThreads.SafepointBehavior.ignoresSafepoints(), "could cause deadlocks otherwise");
            VMOperationControl.log().string("[VMOperationControl.enqueue:").string("  operation: ").string(operation.getName());
            if (!SubstrateOptions.MultiThreaded.getValue().booleanValue()) {
                assert (!VMOperationControl.useDedicatedVMOperationThread());
                VMOperationControl.markAsQueued(operation, data);
                try {
                    operation.execute(data);
                }
                finally {
                    VMOperationControl.markAsFinished(operation, data, null);
                }
            } else if (VMOperationControl.mayExecuteVmOperations()) {
                this.immediateQueues.enqueueAndExecute(operation, data);
            } else if (VMOperationControl.useDedicatedVMOperationThread()) {
                assert (!VMOperationControl.isDedicatedVMOperationThread()) : "the dedicated VM operation thread must execute and not queue VM operations";
                assert (this.dedicatedVMOperationThread.isRunning()) : "must not queue VM operations before the VM operation thread is started or after it is shut down";
                VMThreads.THREAD_MUTEX.guaranteeNotOwner("could result in deadlocks otherwise");
                this.mainQueues.enqueueAndWait(operation, data);
            } else {
                VMThreads.THREAD_MUTEX.guaranteeNotOwner("could result in deadlocks otherwise");
                this.mainQueues.enqueueAndExecute(operation, data);
            }
            assert (operation.isFinished(data));
            VMOperationControl.log().string("]").newline();
        }
        finally {
            StackOverflowCheck.singleton().protectYellowZone();
        }
    }

    @Uninterruptible(reason="Called from a non-Java thread.")
    public void enqueueFromNonJavaThread(NativeVMOperation operation, NativeVMOperationData data) {
        assert (VMOperationControl.useDedicatedVMOperationThread());
        assert (CurrentIsolate.getCurrentThread().isNull() || VMThreads.StatusSupport.isStatusNativeOrSafepoint()) : VMThreads.StatusSupport.getStatusString(CurrentIsolate.getCurrentThread());
        assert (this.dedicatedVMOperationThread.isRunning()) : "must not queue VM operations before the VM operation thread is started or after it is shut down";
        this.mainQueues.enqueueUninterruptibly(operation, data);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    protected static void markAsQueued(VMOperation operation, NativeVMOperationData data) {
        operation.setFinished(data, false);
        operation.setQueuingThread(data, CurrentIsolate.getCurrentThread());
    }

    private static void markAsFinished(VMOperation operation, NativeVMOperationData data, VMCondition operationFinished) {
        operation.setQueuingThread(data, (IsolateThread)WordFactory.nullPointer());
        operation.setFinished(data, true);
        if (operationFinished != null) {
            operationFinished.broadcast();
        }
    }

    public static void guaranteeOkayToBlock(String message) {
        VMOperationControl control = VMOperationControl.get();
        OpInProgress opInProgress = control.getInProgress();
        if (VMOperation.isInProgress(opInProgress)) {
            Log.log().string(message).newline();
            VMError.shouldNotReachHere("Should not reach here: Not okay to block.");
        }
    }

    @Uninterruptible(reason="called from isolate setup code", mayBeInlined=true)
    public static boolean isFrozen() {
        boolean result = Safepoint.Master.singleton().isFrozen();
        assert (!result || SubstrateOptions.MultiThreaded.getValue().booleanValue());
        return result;
    }

    private static Log log() {
        return SubstrateOptions.TraceVMOperations.getValue() != false ? Log.log() : Log.noopLog();
    }

    private static class VMOpStatusChange {
        long timestamp;
        VMOpStatus status;
        String operation;
        boolean causesSafepoint;
        IsolateThread queueingThread;
        IsolateThread executingThread;
        int nestingLevel;
        UnsignedWord safepointId;

        @Platforms(value={Platform.HOSTED_ONLY.class})
        VMOpStatusChange() {
        }

        void print(Log log, boolean allowJavaHeapAccess) {
            VMOpStatus localStatus = this.status;
            if (localStatus != null) {
                log.unsigned(this.timestamp).string(" - ").spaces(this.nestingLevel * 2).string(localStatus.name());
                if (allowJavaHeapAccess) {
                    log.string(" ").string(this.operation);
                }
                log.string(" (safepoint: ").bool(this.causesSafepoint).string(", queueingThread: ").zhex(this.queueingThread.rawValue()).string(", executingThread: ").zhex(this.executingThread.rawValue()).string(", safepointId: ").unsigned((WordBase)this.safepointId).string(")").newline();
            }
        }
    }

    private static enum VMOpStatus {
        Started,
        Continued,
        Finished;

    }

    private static class VMOpHistory {
        private final RingBuffer<VMOpStatusChange> history = new RingBuffer<VMOpStatusChange>(15, VMOpStatusChange::new);
        private static final RingBuffer.Consumer<VMOpStatusChange> PRINT_WITH_JAVA_HEAP_DATA = VMOpHistory::printEntryWithJavaHeapData;
        private static final RingBuffer.Consumer<VMOpStatusChange> PRINT_WITHOUT_JAVA_HEAP_DATA = VMOpHistory::printEntryWithoutJavaHeapData;

        @Platforms(value={Platform.HOSTED_ONLY.class})
        VMOpHistory() {
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public void add(VMOpStatus status, VMOperation operation, IsolateThread queueingThread, IsolateThread executingThread, int nestingLevel) {
            assert (Heap.getHeap().isInImageHeap((Object)status));
            VMOpStatusChange entry = this.history.next();
            entry.timestamp = System.currentTimeMillis();
            entry.status = status;
            entry.operation = operation.getName();
            entry.causesSafepoint = operation.getCausesSafepoint();
            entry.queueingThread = queueingThread;
            entry.executingThread = executingThread;
            entry.nestingLevel = nestingLevel;
            entry.safepointId = Safepoint.Master.singleton().getSafepointId();
        }

        public void print(Log log, boolean allowJavaHeapAccess) {
            log.string("The ").signed(this.history.size()).string(" most recent VM operation status changes (oldest first):").indent(true);
            this.history.foreach(log, allowJavaHeapAccess ? PRINT_WITH_JAVA_HEAP_DATA : PRINT_WITHOUT_JAVA_HEAP_DATA);
            log.indent(false);
        }

        private static void printEntryWithJavaHeapData(Object context, VMOpStatusChange entry) {
            VMOpHistory.printEntry(context, entry, true);
        }

        private static void printEntryWithoutJavaHeapData(Object context, VMOpStatusChange entry) {
            VMOpHistory.printEntry(context, entry, false);
        }

        private static void printEntry(Object context, VMOpStatusChange entry, boolean allowJavaHeapAccess) {
            Log log = (Log)context;
            entry.print(log, allowJavaHeapAccess);
        }
    }

    protected static class OpInProgress {
        VMOperation operation;
        IsolateThread queueingThread;
        IsolateThread executingThread;
        int nestingLevel;

        protected OpInProgress() {
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public VMOperation getOperation() {
            return this.operation;
        }

        public IsolateThread getQueuingThread() {
            return this.queueingThread;
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public IsolateThread getExecutingThread() {
            return this.executingThread;
        }
    }

    protected static class NativeVMOperationQueue
    extends AllocationFreeQueue<NativeVMOperationData> {
        private NativeVMOperationData head;
        private NativeVMOperationData tail;

        NativeVMOperationQueue(String name) {
            super(name);
        }

        @Override
        public boolean isEmpty() {
            return this.head.isNull();
        }

        @Override
        @Uninterruptible(reason="Called from uninterruptible code.")
        public void push(NativeVMOperationData element) {
            assert (element.getNext().isNull()) : "must not already be queued";
            if (this.head.isNull()) {
                this.head = element;
            } else {
                this.tail.setNext(element);
            }
            this.tail = element;
        }

        @Override
        public NativeVMOperationData pop() {
            if (this.head.isNull()) {
                return (NativeVMOperationData)WordFactory.nullPointer();
            }
            NativeVMOperationData resultElement = this.head;
            this.head = resultElement.getNext();
            resultElement.setNext((NativeVMOperationData)WordFactory.nullPointer());
            return resultElement;
        }

        @Override
        public NativeVMOperationData peek() {
            return this.head;
        }

        @Override
        void remove(NativeVMOperationData prev, NativeVMOperationData remove) {
            if (prev.isNull()) {
                assert (this.head == remove);
                this.head = remove.getNext();
                remove.setNext((NativeVMOperationData)WordFactory.nullPointer());
            } else {
                prev.setNext(remove.getNext());
            }
        }
    }

    protected static class JavaVMOperationQueue
    extends JavaAllocationFreeQueue<JavaVMOperation> {
        JavaVMOperationQueue(String name) {
            super(name);
        }
    }

    protected static abstract class JavaAllocationFreeQueue<T extends Element<T>>
    extends AllocationFreeQueue<T> {
        private T head;
        private T tail;

        JavaAllocationFreeQueue(String name) {
            super(name);
        }

        @Override
        public boolean isEmpty() {
            return this.head == null;
        }

        @Override
        public void push(T element) {
            assert (element.getNext() == null) : "must not already be queued";
            if (this.head == null) {
                this.head = element;
            } else {
                this.tail.setNext(element);
            }
            this.tail = element;
        }

        @Override
        public T pop() {
            if (this.head == null) {
                return null;
            }
            T resultElement = this.head;
            this.head = resultElement.getNext();
            resultElement.setNext(null);
            return resultElement;
        }

        @Override
        public T peek() {
            return this.head;
        }

        @Override
        void remove(T prev, T remove) {
            if (prev == null) {
                assert (this.head == remove);
                this.head = remove.getNext();
                remove.setNext(null);
            } else {
                prev.setNext(remove.getNext());
            }
        }

        public static interface Element<T extends Element<T>> {
            public T getNext();

            public void setNext(T var1);
        }
    }

    protected static abstract class AllocationFreeQueue<T> {
        final String name;

        AllocationFreeQueue(String name) {
            this.name = name;
        }

        abstract boolean isEmpty();

        abstract void push(T var1);

        abstract T pop();

        abstract T peek();

        abstract void remove(T var1, T var2);
    }

    private static final class WorkQueues {
        private final NativeVMOperationQueue nativeNonSafepointOperations;
        private final NativeVMOperationQueue nativeSafepointOperations;
        private final JavaVMOperationQueue javaNonSafepointOperations;
        private final JavaVMOperationQueue javaSafepointOperations;
        final VMMutex mutex;
        private final VMCondition operationQueued;
        private final VMCondition operationFinished;

        @Platforms(value={Platform.HOSTED_ONLY.class})
        WorkQueues(String prefix, boolean needsLocking) {
            this.nativeNonSafepointOperations = new NativeVMOperationQueue(prefix + "NativeNonSafepointOperations");
            this.nativeSafepointOperations = new NativeVMOperationQueue(prefix + "NativeSafepointOperations");
            this.javaNonSafepointOperations = new JavaVMOperationQueue(prefix + "JavaNonSafepointOperations");
            this.javaSafepointOperations = new JavaVMOperationQueue(prefix + "JavaSafepointOperations");
            this.mutex = WorkQueues.createMutex(prefix + "VMOperationControlWorkQueue", needsLocking);
            this.operationQueued = this.createCondition();
            this.operationFinished = this.createCondition();
        }

        boolean isEmpty() {
            return this.nativeNonSafepointOperations.isEmpty() && this.nativeSafepointOperations.isEmpty() && this.javaNonSafepointOperations.isEmpty() && this.javaSafepointOperations.isEmpty();
        }

        void waitForWorkAndExecute() {
            assert (VMOperationControl.isDedicatedVMOperationThread());
            assert (!ThreadingSupportImpl.isRecurringCallbackRegistered(CurrentIsolate.getCurrentThread()));
            assert (this.mutex != null);
            this.mutex.guaranteeIsOwner("Must already be locked.");
            while (this.isEmpty()) {
                this.operationQueued.block();
            }
            this.executeAllQueuedVMOperations();
        }

        void enqueueAndWait(VMOperation operation, NativeVMOperationData data) {
            assert (VMOperationControl.useDedicatedVMOperationThread());
            this.lock();
            try {
                this.enqueue(operation, data);
                this.operationQueued.broadcast();
                while (!operation.isFinished(data)) {
                    this.operationFinished.block();
                }
            }
            finally {
                this.unlock();
            }
        }

        @Uninterruptible(reason="Called from a non-Java thread.")
        void enqueueUninterruptibly(NativeVMOperation operation, NativeVMOperationData data) {
            this.mutex.lockNoTransitionUnspecifiedOwner();
            try {
                this.enqueue(operation, data);
                this.operationQueued.broadcast();
            }
            finally {
                this.mutex.unlockNoTransitionUnspecifiedOwner();
            }
        }

        void enqueueAndExecute(VMOperation operation, NativeVMOperationData data) {
            this.lock();
            try {
                this.enqueue(operation, data);
                this.executeAllQueuedVMOperations();
            }
            finally {
                assert (this.isEmpty()) : "all queued VM operations must have been processed";
                this.unlock();
            }
        }

        private void enqueue(VMOperation operation, NativeVMOperationData data) {
            if (operation instanceof JavaVMOperation) {
                this.enqueue((JavaVMOperation)operation, data);
            } else if (operation instanceof NativeVMOperation) {
                this.enqueue((NativeVMOperation)operation, data);
            } else {
                VMError.shouldNotReachHere();
            }
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        private void enqueue(NativeVMOperation operation, NativeVMOperationData data) {
            assert (operation == data.getNativeVMOperation());
            VMOperationControl.markAsQueued(operation, data);
            if (operation.getCausesSafepoint()) {
                this.nativeSafepointOperations.push(data);
            } else {
                this.nativeNonSafepointOperations.push(data);
            }
        }

        private void enqueue(JavaVMOperation operation, NativeVMOperationData data) {
            VMOperationControl.markAsQueued(operation, data);
            if (operation.getCausesSafepoint()) {
                this.javaSafepointOperations.push(operation);
            } else {
                this.javaNonSafepointOperations.push(operation);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Allocating could result in unexpected recursive VM operations.")
        private void executeAllQueuedVMOperations() {
            this.assertIsLocked();
            this.drain(this.nativeNonSafepointOperations);
            this.drain(this.javaNonSafepointOperations);
            this.filterUnnecessary(this.nativeSafepointOperations);
            this.filterUnnecessary(this.javaSafepointOperations);
            if (!this.nativeSafepointOperations.isEmpty() || !this.javaSafepointOperations.isEmpty()) {
                String safepointReason = null;
                boolean startedSafepoint = false;
                boolean lockedForSafepoint = false;
                Safepoint.Master master = Safepoint.Master.singleton();
                if (!master.isFrozen()) {
                    startedSafepoint = true;
                    safepointReason = WorkQueues.getSafepointReason(this.nativeSafepointOperations, this.javaSafepointOperations);
                    lockedForSafepoint = master.freeze(safepointReason);
                }
                try {
                    this.drain(this.nativeSafepointOperations);
                    this.drain(this.javaSafepointOperations);
                }
                finally {
                    if (startedSafepoint) {
                        master.thaw(safepointReason, lockedForSafepoint);
                    }
                }
            }
        }

        private static String getSafepointReason(NativeVMOperationQueue nativeSafepointOperations, JavaVMOperationQueue javaSafepointOperations) {
            NativeVMOperationData data = nativeSafepointOperations.peek();
            if (data.isNonNull()) {
                return data.getNativeVMOperation().getName();
            }
            VMOperation op = (VMOperation)javaSafepointOperations.peek();
            assert (op != null);
            return op.getName();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void drain(NativeVMOperationQueue workQueue) {
            this.assertIsLocked();
            if (!workQueue.isEmpty()) {
                Log trace = VMOperationControl.log();
                trace.string("[Worklist.drain:  queue: ").string(workQueue.name);
                while (!workQueue.isEmpty()) {
                    NativeVMOperationData data = workQueue.pop();
                    NativeVMOperation operation = data.getNativeVMOperation();
                    try {
                        operation.execute(data);
                    }
                    finally {
                        VMOperationControl.markAsFinished(operation, data, this.operationFinished);
                    }
                }
                trace.string("]").newline();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void drain(JavaVMOperationQueue workQueue) {
            this.assertIsLocked();
            if (!workQueue.isEmpty()) {
                Log trace = VMOperationControl.log();
                trace.string("[Worklist.drain:  queue: ").string(workQueue.name);
                while (!workQueue.isEmpty()) {
                    JavaVMOperation operation = (JavaVMOperation)workQueue.pop();
                    try {
                        operation.execute((NativeVMOperationData)WordFactory.nullPointer());
                    }
                    finally {
                        VMOperationControl.markAsFinished(operation, (NativeVMOperationData)WordFactory.nullPointer(), this.operationFinished);
                    }
                }
                trace.string("]").newline();
            }
        }

        private void filterUnnecessary(JavaVMOperationQueue workQueue) {
            Log trace = VMOperationControl.log();
            JavaVMOperation prev = null;
            JavaVMOperation op = (JavaVMOperation)workQueue.peek();
            while (op != null) {
                JavaVMOperation next = op.getNext();
                if (!op.hasWork((NativeVMOperationData)WordFactory.nullPointer())) {
                    trace.string("[Skipping unnecessary operation in queue ").string(workQueue.name).string(": ").string(op.getName());
                    workQueue.remove(prev, op);
                    VMOperationControl.markAsFinished(op, (NativeVMOperationData)WordFactory.nullPointer(), this.operationFinished);
                } else {
                    prev = op;
                }
                op = next;
            }
        }

        private void filterUnnecessary(NativeVMOperationQueue workQueue) {
            Log trace = VMOperationControl.log();
            NativeVMOperationData prev = (NativeVMOperationData)WordFactory.nullPointer();
            NativeVMOperationData data = workQueue.peek();
            while (data.isNonNull()) {
                NativeVMOperation op = data.getNativeVMOperation();
                NativeVMOperationData next = data.getNext();
                if (!op.hasWork(data)) {
                    trace.string("[Skipping unnecessary operation in queue ").string(workQueue.name).string(": ").string(op.getName());
                    workQueue.remove(prev, data);
                    VMOperationControl.markAsFinished(op, data, this.operationFinished);
                } else {
                    prev = data;
                }
                data = next;
            }
        }

        private void lock() {
            if (this.mutex != null) {
                this.mutex.lock();
            }
        }

        private void unlock() {
            if (this.mutex != null) {
                this.mutex.unlock();
            }
        }

        private void assertIsLocked() {
            if (this.mutex != null) {
                this.mutex.assertIsOwner("must be locked");
            }
        }

        @Platforms(value={Platform.HOSTED_ONLY.class})
        private static VMMutex createMutex(String mutexName, boolean needsLocking) {
            if (needsLocking) {
                return new VMMutex(mutexName);
            }
            return null;
        }

        @Platforms(value={Platform.HOSTED_ONLY.class})
        private VMCondition createCondition() {
            if (this.mutex != null && VMOperationControl.useDedicatedVMOperationThread()) {
                return new VMCondition(this.mutex);
            }
            return null;
        }
    }

    public static class VMOperationThread
    implements Runnable {
        private final Thread thread = new Thread((Runnable)this, "VMOperationThread");
        private volatile IsolateThread isolateThread;
        private boolean stopped;

        @Platforms(value={Platform.HOSTED_ONLY.class})
        VMOperationThread() {
            this.thread.setDaemon(true);
        }

        public void start() {
            this.thread.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            this.isolateThread = CurrentIsolate.getCurrentThread();
            VMOperationControl control = VMOperationControl.get();
            WorkQueues queues = control.mainQueues;
            queues.mutex.lock();
            try {
                while (!this.stopped) {
                    try {
                        queues.waitForWorkAndExecute();
                    }
                    catch (Throwable e) {
                        VMOperationControl.log().string("[VMOperation.execute caught: ").string(e.getClass().getName()).string("]").newline();
                        throw VMError.shouldNotReachHere(e);
                        return;
                    }
                }
            }
            finally {
                queues.mutex.unlock();
                this.stopped = true;
            }
        }

        public void waitUntilStarted() {
            while (this.isolateThread.isNull()) {
                Thread.yield();
            }
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public IsolateThread getIsolateThread() {
            return this.isolateThread;
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public boolean isRunning() {
            return this.isolateThread.isNonNull() && !this.stopped;
        }

        void shutdown() {
            VMOperation.guaranteeInProgress("must only be called from a VM operation");
            this.stopped = true;
        }
    }

    private static class StopVMOperationThread
    extends JavaVMOperation {
        StopVMOperationThread() {
            super(VMOperationInfos.get(StopVMOperationThread.class, "Stop VM operation thread", VMOperation.SystemEffect.NONE));
        }

        @Override
        protected void operate() {
            VMOperationControl.get().dedicatedVMOperationThread.shutdown();
        }
    }
}

