/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.thread;

import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.heap.VMOperationInfo;
import com.oracle.svm.core.thread.NativeVMOperationData;
import com.oracle.svm.core.thread.VMOperation;
import com.oracle.svm.core.thread.VMOperationControl;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public abstract class NativeVMOperation
extends VMOperation {
    @Platforms(value={Platform.HOSTED_ONLY.class})
    protected NativeVMOperation(VMOperationInfo info) {
        super(info);
    }

    public void enqueue(NativeVMOperationData data) {
        assert (data.getNativeVMOperation() == this);
        VMOperationControl.get().enqueue(data);
    }

    @Uninterruptible(reason="Called from a non-Java thread.")
    public void enqueueFromNonJavaThread(NativeVMOperationData data) {
        assert (data.getNativeVMOperation() == this);
        VMOperationControl.get().enqueueFromNonJavaThread(data);
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    protected boolean isFinished(NativeVMOperationData data) {
        return data.getFinished();
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    protected void setFinished(NativeVMOperationData data, boolean value) {
        data.setFinished(value);
    }

    @Override
    protected IsolateThread getQueuingThread(NativeVMOperationData data) {
        return data.getQueuingThread();
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    protected void setQueuingThread(NativeVMOperationData data, IsolateThread value) {
        data.setQueuingThread(value);
    }
}

